/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.table;

import org.gridgain.shaded.org.apache.ignite.table.DataStreamerOperationType;

public interface DataStreamerItem<T> {
    public T get();

    public DataStreamerOperationType operationType();

    public static <T> DataStreamerItem<T> of(T item) {
        return DataStreamerItem.instance(item, DataStreamerOperationType.PUT);
    }

    public static <T> DataStreamerItem<T> of(T item, DataStreamerOperationType op) {
        return DataStreamerItem.instance(item, op);
    }

    public static <T> DataStreamerItem<T> removed(T item) {
        return DataStreamerItem.instance(item, DataStreamerOperationType.REMOVE);
    }

    private static <T> DataStreamerItem<T> instance(final T item, final DataStreamerOperationType operationType) {
        return new DataStreamerItem<T>(){

            @Override
            public T get() {
                return item;
            }

            @Override
            public DataStreamerOperationType operationType() {
                return operationType;
            }
        };
    }
}

