/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.network;

import java.net.InetSocketAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NetworkAddress {
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("(.+):(\\d+)");
    private final String host;
    private final int port;

    public NetworkAddress(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public static NetworkAddress from(String addrStr) {
        int port;
        Matcher matcher = ADDRESS_PATTERN.matcher(addrStr);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Unable to parse the network address from: " + addrStr);
        }
        String host = matcher.group(1);
        String portStr = matcher.group(2);
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Illegal port format: " + portStr, ex);
        }
        return new NetworkAddress(host, port);
    }

    public static NetworkAddress from(InetSocketAddress addr) {
        return new NetworkAddress(addr.getHostName(), addr.getPort());
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkAddress address = (NetworkAddress)o;
        return this.port == address.port && this.host.equals(address.host);
    }

    public int hashCode() {
        int result = this.host.hashCode();
        result = 31 * result + this.port;
        return result;
    }

    public String toString() {
        return this.host + ":" + this.port;
    }
}

