/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import org.gridgain.shaded.org.apache.ignite.internal.util.subscription.ConcatenatedPublisher;
import org.gridgain.shaded.org.apache.ignite.internal.util.subscription.IterableToPublisherAdapter;
import org.gridgain.shaded.org.apache.ignite.internal.util.subscription.OrderedMergePublisher;

public class SubscriptionUtils {
    public static <T> Flow.Publisher<T> concat(Iterator<Flow.Publisher<? extends T>> sources) {
        return new ConcatenatedPublisher<T>(sources);
    }

    @SafeVarargs
    public static <T> Flow.Publisher<T> concat(Flow.Publisher<? extends T> ... sources) {
        return new ConcatenatedPublisher<T>(Arrays.asList(sources).iterator());
    }

    public static <T> Flow.Publisher<T> orderedMerge(Comparator<T> comparator, int prefetch, Iterator<Flow.Publisher<? extends T>> source) {
        ArrayList pubList = new ArrayList();
        source.forEachRemaining(pubList::add);
        return SubscriptionUtils.orderedMerge(comparator, prefetch, (Flow.Publisher[])pubList.toArray(Flow.Publisher[]::new));
    }

    @SafeVarargs
    public static <T> Flow.Publisher<T> orderedMerge(Comparator<T> comparator, int prefetch, Flow.Publisher<? extends T> ... sources) {
        return new OrderedMergePublisher<T>(comparator, prefetch, sources);
    }

    public static <T> Flow.Publisher<T> fromIterable(Iterable<T> iterable) {
        return new IterableToPublisherAdapter<T>(CompletableFuture.completedFuture(iterable), Runnable::run, Integer.MAX_VALUE);
    }

    public static <T> Flow.Publisher<T> fromIterable(CompletableFuture<? extends Iterable<T>> iterableFuture) {
        return new IterableToPublisherAdapter(iterableFuture, Runnable::run, Integer.MAX_VALUE);
    }
}

