/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.thread;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.gridgain.shaded.org.apache.ignite.internal.thread.ThreadAttributes;
import org.gridgain.shaded.org.apache.ignite.internal.thread.ThreadOperation;
import org.gridgain.shaded.org.apache.ignite.internal.tostring.S;
import org.gridgain.shaded.org.apache.ignite.internal.util.worker.IgniteWorker;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

public class IgniteThread
extends Thread
implements ThreadAttributes {
    private final Set<ThreadOperation> allowedOperations;

    public IgniteThread(IgniteWorker worker) {
        this(worker.igniteInstanceName(), worker.name(), worker, new ThreadOperation[0]);
    }

    public IgniteThread(String nodeName, String threadName, Runnable r, ThreadOperation ... allowedOperations) {
        this(IgniteThread.prefixWithNodeName(nodeName, threadName), r, allowedOperations);
    }

    public IgniteThread(String finalName, Runnable r, ThreadOperation ... allowedOperations) {
        super(r, finalName);
        EnumSet<ThreadOperation> operations = EnumSet.noneOf(ThreadOperation.class);
        Collections.addAll(operations, allowedOperations);
        this.allowedOperations = Collections.unmodifiableSet(operations);
    }

    @Nullable
    public static IgniteThread current() {
        Thread thread = IgniteThread.currentThread();
        return thread.getClass() == IgniteThread.class || thread instanceof IgniteThread ? (IgniteThread)thread : null;
    }

    public static String threadPrefix(String nodeName, String threadName) {
        return IgniteThread.prefixWithNodeName(nodeName, threadName) + "-";
    }

    private static String prefixWithNodeName(String nodeName, String threadName) {
        return "%" + nodeName + "%" + threadName;
    }

    @Override
    public String toString() {
        return S.toString(IgniteThread.class, this, "name", (Object)this.getName());
    }

    @Override
    public Set<ThreadOperation> allowedOperations() {
        return this.allowedOperations;
    }
}

