/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.table.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.gridgain.shaded.org.apache.ignite.cache.CacheStore;
import org.gridgain.shaded.org.apache.ignite.internal.lang.IgniteExceptionMapperUtil;
import org.gridgain.shaded.org.apache.ignite.internal.table.criteria.CursorAdapter;
import org.gridgain.shaded.org.apache.ignite.internal.util.CompletableFutures;
import org.gridgain.shaded.org.apache.ignite.internal.util.ExceptionUtils;
import org.gridgain.shaded.org.apache.ignite.internal.util.IgniteUtils;
import org.gridgain.shaded.org.apache.ignite.internal.util.ViewUtils;
import org.gridgain.shaded.org.apache.ignite.lang.AsyncCursor;
import org.gridgain.shaded.org.apache.ignite.lang.Cursor;
import org.gridgain.shaded.org.apache.ignite.lang.NullableValue;
import org.gridgain.shaded.org.apache.ignite.table.ContinuousQueryOptions;
import org.gridgain.shaded.org.apache.ignite.table.DataStreamerItem;
import org.gridgain.shaded.org.apache.ignite.table.DataStreamerOptions;
import org.gridgain.shaded.org.apache.ignite.table.DataStreamerReceiverDescriptor;
import org.gridgain.shaded.org.apache.ignite.table.KeyValueView;
import org.gridgain.shaded.org.apache.ignite.table.TableRowEventBatch;
import org.gridgain.shaded.org.apache.ignite.table.criteria.Criteria;
import org.gridgain.shaded.org.apache.ignite.table.criteria.CriteriaQueryOptions;
import org.gridgain.shaded.org.apache.ignite.tx.IgniteTransactions;
import org.gridgain.shaded.org.apache.ignite.tx.Transaction;
import org.gridgain.shaded.org.apache.ignite.tx.TransactionOptions;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

public abstract class AbstractCachingKeyValueView<K, V>
implements KeyValueView<K, V> {
    private final IgniteTransactions transactions;
    protected final KeyValueView<K, V> view;
    private final CacheStore<K, V> store;

    public AbstractCachingKeyValueView(IgniteTransactions transactions, KeyValueView<K, V> view, CacheStore<K, V> store) {
        this.transactions = transactions;
        this.view = view;
        this.store = store;
    }

    @Override
    @Nullable
    public V get(@Nullable Transaction tx, K key) {
        return this.sync(this.getAsync(tx, key));
    }

    @Override
    public CompletableFuture<V> getAsync(@Nullable Transaction tx, K key) {
        Optional<V> val;
        boolean implicit;
        Objects.requireNonNull(key, "key");
        boolean bl = implicit = tx == null;
        if (implicit) {
            tx = this.transactions.begin(new TransactionOptions().cacheOnly(true));
        }
        if ((val = this.enlistStore(tx, this.store).get(key)) != null) {
            return val.isEmpty() ? CompletableFutures.nullCompletedFuture() : CompletableFuture.completedFuture(val.get());
        }
        Transaction finalTx = tx;
        return ((CompletableFuture)this.view.getAsync(tx, key).thenCompose(valTup -> {
            if (valTup == null) {
                return this.store.loadAsync(key).thenCompose(val0 -> {
                    if (val0 == null) {
                        return CompletableFutures.nullCompletedFuture();
                    }
                    return this.view.putIfAbsentAsync(finalTx, key, val0).thenApply(ignored -> val0);
                });
            }
            return CompletableFuture.completedFuture(valTup);
        })).thenCompose(ret -> {
            if (implicit) {
                return finalTx.commitAsync().thenApply(ignored -> ret);
            }
            return CompletableFuture.completedFuture(ret);
        });
    }

    @Override
    public void put(@Nullable Transaction tx, K key, V val) {
        this.sync(this.putAsync(tx, key, val));
    }

    @Override
    public CompletableFuture<Void> putAsync(@Nullable Transaction tx, K key, V val) {
        boolean implicit;
        Objects.requireNonNull(val, "val");
        boolean bl = implicit = tx == null;
        if (implicit) {
            tx = this.transactions.begin(new TransactionOptions().cacheOnly(true));
        }
        Transaction finalTx = tx;
        return ((CompletableFuture)this.view.putAsync(tx, key, val).thenApply(ignored -> {
            this.enlistStore(finalTx, this.store).put(key, Optional.of(val));
            return null;
        })).thenCompose(ignored -> {
            if (implicit) {
                return finalTx.commitAsync();
            }
            return CompletableFutures.nullCompletedFuture();
        });
    }

    @Override
    public boolean remove(@Nullable Transaction tx, K key) {
        return this.sync(this.removeAsync(tx, key));
    }

    @Override
    public boolean remove(@Nullable Transaction tx, K key, V val) {
        return this.sync(this.removeAsync(tx, key, val));
    }

    @Override
    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, K key) {
        Optional<V> val;
        boolean implicit;
        Objects.requireNonNull(key, "key");
        boolean bl = implicit = tx == null;
        if (implicit) {
            tx = this.transactions.begin(new TransactionOptions().cacheOnly(true));
        }
        if ((val = this.enlistStore(tx, this.store).get(key)) != null && val.isEmpty()) {
            return CompletableFutures.falseCompletedFuture();
        }
        Transaction finalTx = tx;
        return ((CompletableFuture)this.view.removeAsync(tx, key).thenApply(removed -> {
            if (removed.booleanValue()) {
                this.enlistStore(finalTx, this.store).put(key, Optional.empty());
            }
            return removed;
        })).thenCompose(ret -> {
            if (implicit) {
                return finalTx.commitAsync().thenApply(ignored -> ret);
            }
            return CompletableFuture.completedFuture(ret);
        });
    }

    @Override
    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, K key, V val) {
        Optional<V> val0;
        boolean implicit;
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(val, "val");
        boolean bl = implicit = tx == null;
        if (implicit) {
            tx = this.transactions.begin(new TransactionOptions().cacheOnly(true));
        }
        if ((val0 = this.enlistStore(tx, this.store).get(key)) != null && val0.isEmpty()) {
            return CompletableFutures.falseCompletedFuture();
        }
        Transaction finalTx = tx;
        return ((CompletableFuture)this.view.removeAsync(tx, key, val).thenApply(removed -> {
            Map enlisted = this.enlistStore(finalTx, this.store);
            if (removed.booleanValue()) {
                enlisted.put(key, Optional.empty());
            }
            return removed;
        })).thenCompose(ret -> {
            if (implicit) {
                return finalTx.commitAsync().thenApply(ignored -> ret);
            }
            return CompletableFuture.completedFuture(ret);
        });
    }

    @Override
    public NullableValue<V> getNullable(@Nullable Transaction tx, K key) {
        return this.sync(this.getNullableAsync(tx, key));
    }

    @Override
    public CompletableFuture<NullableValue<V>> getNullableAsync(@Nullable Transaction tx, K key) {
        return this.getAsync(tx, key).thenApply(r -> r == null ? null : NullableValue.of(r));
    }

    @Override
    @Nullable
    public V getOrDefault(@Nullable Transaction tx, K key, @Nullable V defaultValue) {
        return this.sync(this.getOrDefaultAsync(tx, key, defaultValue));
    }

    @Override
    public CompletableFuture<V> getOrDefaultAsync(@Nullable Transaction tx, K key, @Nullable V defaultValue) {
        return this.getAsync(tx, key).thenApply(val -> IgniteUtils.nonNullOrElse(val, defaultValue));
    }

    @Override
    public Map<K, V> getAll(@Nullable Transaction tx, Collection<K> keys) {
        return this.sync(this.getAllAsync(tx, keys));
    }

    @Override
    public CompletableFuture<Map<K, V>> getAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        Collection<K> pending;
        boolean implicit;
        ViewUtils.checkKeysForNulls(keys);
        boolean bl = implicit = tx == null;
        if (implicit) {
            tx = this.transactions.begin(new TransactionOptions().cacheOnly(true));
        }
        Map<K, Optional<V>> enlisted = this.enlistStore(tx, this.store);
        HashMap result = IgniteUtils.newHashMap(keys.size());
        if (!implicit) {
            pending = Collections.newSetFromMap(IgniteUtils.newHashMap(keys.size()));
            for (Object key : keys) {
                Optional<V> val = enlisted.get(key);
                if (val != null) {
                    val.ifPresent(v -> result.put(key, v));
                    continue;
                }
                pending.add(key);
            }
            if (pending.isEmpty()) {
                return CompletableFuture.completedFuture(result);
            }
        } else {
            pending = keys;
        }
        Transaction finalTx = tx;
        return ((CompletableFuture)this.view.getAllAsync(tx, pending).thenCompose(hits -> {
            result.putAll(hits);
            HashSet misses = new HashSet();
            for (Object key : pending) {
                if (hits.containsKey(key)) continue;
                misses.add(key);
            }
            return this.store.loadAllAsync(misses).thenCompose(loaded -> {
                result.putAll(loaded);
                return this.view.putAllAsync(finalTx, (Map<K, V>)loaded).thenApply(ignored -> result);
            });
        })).thenCompose(ret -> {
            if (implicit) {
                return finalTx.commitAsync().thenApply(ignored -> ret);
            }
            return CompletableFuture.completedFuture(ret);
        });
    }

    @Override
    public boolean contains(@Nullable Transaction tx, K key) {
        return this.get(tx, key) != null;
    }

    @Override
    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, K key) {
        return this.getAsync(tx, key).thenApply(Objects::nonNull);
    }

    @Override
    public boolean containsAll(@Nullable Transaction tx, Collection<K> keys) {
        return this.getAll(tx, keys).keySet().containsAll(keys);
    }

    @Override
    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        return this.getAllAsync(tx, keys).thenApply(results -> results.keySet().containsAll(keys));
    }

    @Override
    public void putAll(@Nullable Transaction tx, Map<K, V> pairs) {
        this.sync(this.putAllAsync(tx, pairs));
    }

    @Override
    public CompletableFuture<Void> putAllAsync(@Nullable Transaction tx, Map<K, V> pairs) {
        boolean implicit;
        boolean bl = implicit = tx == null;
        if (implicit) {
            tx = this.transactions.begin(new TransactionOptions().cacheOnly(true));
        }
        Transaction finalTx = tx;
        return ((CompletableFuture)this.view.putAllAsync(tx, pairs).thenApply(ignored -> {
            Map enlisted = this.enlistStore(finalTx, this.store);
            for (Map.Entry kvEntry : pairs.entrySet()) {
                enlisted.put(kvEntry.getKey(), Optional.of(kvEntry.getValue()));
            }
            return null;
        })).thenCompose(ret -> {
            if (implicit) {
                return finalTx.commitAsync();
            }
            return CompletableFutures.nullCompletedFuture();
        });
    }

    @Override
    @Nullable
    public V getAndPut(@Nullable Transaction tx, K key, V val) {
        return this.sync(this.getAndPutAsync(tx, key, val));
    }

    @Override
    public CompletableFuture<V> getAndPutAsync(@Nullable Transaction tx, K key, V val) {
        boolean implicit;
        Objects.requireNonNull(val, "val");
        boolean bl = implicit = tx == null;
        if (implicit) {
            tx = this.transactions.begin(new TransactionOptions().cacheOnly(true));
        }
        Transaction finalTx = tx;
        return ((CompletableFuture)this.view.getAndPutAsync(tx, key, val).thenApply(val0 -> {
            Map<Object, Optional<Optional<Object>>> enlisted = this.enlistStore(finalTx, this.store);
            enlisted.put(key, Optional.ofNullable(val0));
            return val0;
        })).thenCompose(ret -> {
            if (implicit) {
                return finalTx.commitAsync().thenApply(ignored -> ret);
            }
            return CompletableFuture.completedFuture(ret);
        });
    }

    @Override
    public NullableValue<V> getNullableAndPut(@Nullable Transaction tx, K key, V val) {
        return this.sync(this.getNullableAndPutAsync(tx, key, val));
    }

    @Override
    public CompletableFuture<NullableValue<V>> getNullableAndPutAsync(@Nullable Transaction tx, K key, V val) {
        return this.getAndPutAsync(tx, key, val).thenApply(r -> r == null ? null : NullableValue.of(r));
    }

    @Override
    public boolean putIfAbsent(@Nullable Transaction tx, K key, V val) {
        return this.sync(this.putIfAbsentAsync(tx, key, val));
    }

    @Override
    public CompletableFuture<Boolean> putIfAbsentAsync(@Nullable Transaction tx, K key, V val) {
        boolean implicit;
        Objects.requireNonNull(val, "val");
        boolean bl = implicit = tx == null;
        if (implicit) {
            tx = this.transactions.begin(new TransactionOptions().cacheOnly(true));
        }
        Transaction finalTx = tx;
        return ((CompletableFuture)this.view.putIfAbsentAsync(tx, key, val).thenApply(res -> {
            Map<Object, Optional<Optional<Object>>> enlisted = this.enlistStore(finalTx, this.store);
            if (!res.booleanValue()) {
                enlisted.put(key, Optional.of(val));
            }
            return res;
        })).thenCompose(ret -> {
            if (implicit) {
                return finalTx.commitAsync().thenApply(ignored -> ret);
            }
            return CompletableFuture.completedFuture(ret);
        });
    }

    @Override
    public Collection<K> removeAll(@Nullable Transaction tx, Collection<K> keys) {
        return this.sync(this.removeAllAsync(tx, keys));
    }

    @Override
    public void removeAll(@Nullable Transaction tx) {
        this.sync(this.removeAllAsync(tx));
    }

    @Override
    public CompletableFuture<Collection<K>> removeAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        Collection<K> pending;
        boolean implicit;
        ViewUtils.checkKeysForNulls(keys);
        boolean bl = implicit = tx == null;
        if (implicit) {
            tx = this.transactions.begin(new TransactionOptions().cacheOnly(true));
        }
        Map enlisted = this.enlistStore(tx, this.store);
        Set result = Collections.newSetFromMap(IgniteUtils.newHashMap(keys.size()));
        if (!implicit) {
            pending = Collections.newSetFromMap(IgniteUtils.newHashMap(keys.size()));
            for (K key : keys) {
                Optional<V> val = enlisted.get(key);
                if (val != null && val.isEmpty()) {
                    result.add(key);
                    continue;
                }
                pending.add(key);
            }
            if (pending.isEmpty()) {
                return CompletableFuture.completedFuture(result);
            }
        } else {
            pending = keys;
        }
        Transaction finalTx = tx;
        return ((CompletableFuture)this.view.removeAllAsync(tx, pending).thenApply(notRemoved -> {
            for (Object k : notRemoved) {
                enlisted.put(k, Optional.empty());
                result.add(k);
            }
            return result;
        })).thenCompose(ret -> {
            if (implicit) {
                return finalTx.commitAsync().thenApply(ignored -> ret);
            }
            return CompletableFuture.completedFuture(ret);
        });
    }

    @Override
    public CompletableFuture<Void> removeAllAsync(@Nullable Transaction tx) {
        return CompletableFuture.failedFuture(new UnsupportedOperationException());
    }

    @Override
    @Nullable
    public V getAndRemove(@Nullable Transaction tx, K key) {
        return this.sync(this.getAndRemoveAsync(tx, key));
    }

    @Override
    public CompletableFuture<V> getAndRemoveAsync(@Nullable Transaction tx, K key) {
        Optional<V> val0;
        boolean implicit;
        Objects.requireNonNull(key, "key");
        boolean bl = implicit = tx == null;
        if (implicit) {
            tx = this.transactions.begin(new TransactionOptions().cacheOnly(true));
        }
        if ((val0 = this.enlistStore(tx, this.store).get(key)) != null && val0.isEmpty()) {
            return CompletableFutures.nullCompletedFuture();
        }
        Transaction finalTx = tx;
        return ((CompletableFuture)this.view.getAndRemoveAsync(tx, key).thenApply(val -> {
            Map enlisted = this.enlistStore(finalTx, this.store);
            if (val == null) {
                enlisted.put(key, Optional.empty());
            }
            return val;
        })).thenCompose(ret -> {
            if (implicit) {
                return finalTx.commitAsync().thenApply(ignored -> ret);
            }
            return CompletableFuture.completedFuture(ret);
        });
    }

    @Override
    public NullableValue<V> getNullableAndRemove(@Nullable Transaction tx, K key) {
        return this.sync(this.getNullableAndRemoveAsync(tx, key));
    }

    @Override
    public CompletableFuture<NullableValue<V>> getNullableAndRemoveAsync(@Nullable Transaction tx, K key) {
        return this.getAndRemoveAsync(tx, key).thenApply(r -> r == null ? null : NullableValue.of(r));
    }

    @Override
    public boolean replace(@Nullable Transaction tx, K key, V val) {
        return this.sync(this.replaceAsync(tx, key, val));
    }

    @Override
    public boolean replace(@Nullable Transaction tx, K key, V oldValue, V newValue) {
        return this.sync(this.replaceAsync(tx, key, oldValue, newValue));
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, K key, V val) {
        boolean implicit;
        Objects.requireNonNull(val, "val");
        boolean bl = implicit = tx == null;
        if (implicit) {
            tx = this.transactions.begin(new TransactionOptions().cacheOnly(true));
        }
        Transaction finalTx = tx;
        return ((CompletableFuture)this.view.replaceAsync(tx, key, val).thenApply(replaced -> {
            Map<Object, Optional<Optional<Object>>> enlisted = this.enlistStore(finalTx, this.store);
            if (replaced.booleanValue()) {
                enlisted.put(key, Optional.of(val));
            }
            return replaced;
        })).thenCompose(ret -> {
            if (implicit) {
                return finalTx.commitAsync().thenApply(ignored -> ret);
            }
            return CompletableFuture.completedFuture(ret);
        });
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, K key, V oldValue, V newValue) {
        boolean implicit;
        Objects.requireNonNull(oldValue, "oldValue");
        Objects.requireNonNull(newValue, "newValue");
        boolean bl = implicit = tx == null;
        if (implicit) {
            tx = this.transactions.begin(new TransactionOptions().cacheOnly(true));
        }
        Transaction finalTx = tx;
        return ((CompletableFuture)this.view.replaceAsync(tx, key, oldValue, newValue).thenApply(replaced -> {
            Map<Object, Optional<Optional<Object>>> enlisted = this.enlistStore(finalTx, this.store);
            if (replaced.booleanValue()) {
                enlisted.put(key, Optional.of(newValue));
            }
            return replaced;
        })).thenCompose(ret -> {
            if (implicit) {
                return finalTx.commitAsync().thenApply(ignored -> ret);
            }
            return CompletableFuture.completedFuture(ret);
        });
    }

    @Override
    @Nullable
    public V getAndReplace(@Nullable Transaction tx, K key, V val) {
        return this.sync(this.getAndReplaceAsync(tx, key, val));
    }

    @Override
    public CompletableFuture<V> getAndReplaceAsync(@Nullable Transaction tx, K key, V val) {
        boolean implicit;
        Objects.requireNonNull(val, "val");
        boolean bl = implicit = tx == null;
        if (implicit) {
            tx = this.transactions.begin(new TransactionOptions().cacheOnly(true));
        }
        Transaction finalTx = tx;
        return ((CompletableFuture)this.view.getAndReplaceAsync(tx, key, val).thenApply(val0 -> {
            Map<Object, Optional<Optional<Object>>> enlisted = this.enlistStore(finalTx, this.store);
            if (val0 != null) {
                enlisted.put(key, Optional.of(val0));
            }
            return val0;
        })).thenCompose(ret -> {
            if (implicit) {
                return finalTx.commitAsync().thenApply(ignored -> ret);
            }
            return CompletableFuture.completedFuture(ret);
        });
    }

    @Override
    public NullableValue<V> getNullableAndReplace(@Nullable Transaction tx, K key, V val) {
        return this.sync(this.getNullableAndReplaceAsync(tx, key, val));
    }

    @Override
    public CompletableFuture<NullableValue<V>> getNullableAndReplaceAsync(@Nullable Transaction tx, K key, V val) {
        return this.getAndReplaceAsync(tx, key, val).thenApply(r -> r == null ? null : NullableValue.of(r));
    }

    @Override
    public void queryContinuously(Flow.Subscriber<TableRowEventBatch<Map.Entry<K, V>>> subscriber, @Nullable ContinuousQueryOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<Map.Entry<K, V>>> publisher, @Nullable DataStreamerOptions options) {
        return this.view.streamData(publisher, options);
    }

    @Override
    public <E, V2, A, R> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, DataStreamerReceiverDescriptor<V2, A, R> receiver, Function<E, Map.Entry<K, V>> keyFunc, Function<E, V2> payloadFunc, @Nullable A receiverArg, @Nullable Flow.Subscriber<R> resultSubscriber, @Nullable DataStreamerOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Cursor<Map.Entry<K, V>> query(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, @Nullable CriteriaQueryOptions opts) {
        return new CursorAdapter<Map.Entry<K, V>>(this.sync(this.queryAsync(tx, criteria, indexName, opts)));
    }

    @Override
    public CompletableFuture<AsyncCursor<Map.Entry<K, V>>> queryAsync(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, @Nullable CriteriaQueryOptions opts) {
        return this.view.queryAsync(tx, criteria, indexName, opts);
    }

    protected abstract Map<K, Optional<V>> enlistStore(Transaction var1, CacheStore<K, V> var2);

    protected <T> T sync(CompletableFuture<T> fut) {
        try {
            return fut.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw (RuntimeException)ExceptionUtils.sneakyThrow(IgniteExceptionMapperUtil.mapToPublicException(e));
        }
        catch (Exception e) {
            Throwable cause = ExceptionUtils.unwrapCause(e);
            throw (RuntimeException)ExceptionUtils.sneakyThrow(cause);
        }
    }

    @Override
    public void close() throws Exception {
        this.view.close();
    }
}

