/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.jdbc.proto.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.gridgain.shaded.org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.gridgain.shaded.org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.gridgain.shaded.org.apache.ignite.internal.jdbc.proto.event.JdbcPrimaryKeyMeta;
import org.gridgain.shaded.org.apache.ignite.internal.jdbc.proto.event.Response;
import org.gridgain.shaded.org.apache.ignite.internal.tostring.S;

public class JdbcMetaPrimaryKeysResult
extends Response {
    private List<JdbcPrimaryKeyMeta> meta;

    public JdbcMetaPrimaryKeysResult() {
    }

    public JdbcMetaPrimaryKeysResult(Collection<JdbcPrimaryKeyMeta> meta) {
        Objects.requireNonNull(meta);
        this.meta = new ArrayList<JdbcPrimaryKeyMeta>(meta);
    }

    @Override
    public void writeBinary(ClientMessagePacker packer) {
        super.writeBinary(packer);
        if (!this.success()) {
            return;
        }
        if (this.meta == null || this.meta.isEmpty()) {
            packer.packNil();
            return;
        }
        packer.packInt(this.meta.size());
        for (JdbcPrimaryKeyMeta keyMeta : this.meta) {
            keyMeta.writeBinary(packer);
        }
    }

    @Override
    public void readBinary(ClientMessageUnpacker unpacker) {
        super.readBinary(unpacker);
        if (!this.success()) {
            return;
        }
        if (unpacker.tryUnpackNil()) {
            this.meta = Collections.emptyList();
            return;
        }
        int size = unpacker.unpackInt();
        this.meta = new ArrayList<JdbcPrimaryKeyMeta>(size);
        for (int i = 0; i < size; ++i) {
            JdbcPrimaryKeyMeta m = new JdbcPrimaryKeyMeta();
            m.readBinary(unpacker);
            this.meta.add(m);
        }
    }

    public List<JdbcPrimaryKeyMeta> meta() {
        return this.meta;
    }

    @Override
    public String toString() {
        return S.toString(JdbcMetaPrimaryKeysResult.class, this);
    }
}

