/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.future;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class InFlightFutures
implements Iterable<CompletableFuture<?>> {
    private final Set<CompletableFuture<?>> inFlightFutures = ConcurrentHashMap.newKeySet();

    public <T> CompletableFuture<T> registerFuture(CompletableFuture<T> future) {
        this.inFlightFutures.add(future);
        future.whenComplete((result, ex) -> this.inFlightFutures.remove(future));
        return future;
    }

    public void cancelInFlightFutures() {
        for (CompletableFuture<?> future : this) {
            future.cancel(true);
        }
    }

    public void failInFlightFutures(Exception cause) {
        for (CompletableFuture<?> future : this) {
            future.completeExceptionally(cause);
        }
    }

    @Override
    public Iterator<CompletableFuture<?>> iterator() {
        return this.inFlightFutures.iterator();
    }
}

