/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.compute;

import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import org.gridgain.shaded.org.apache.ignite.compute.JobState;
import org.gridgain.shaded.org.apache.ignite.compute.JobStatus;
import org.gridgain.shaded.org.apache.ignite.internal.tostring.S;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

public class JobStateImpl
implements JobState {
    private static final long serialVersionUID = 8575969461073736006L;
    private final UUID id;
    private final JobStatus status;
    private final Instant createTime;
    @Nullable
    private final Instant startTime;
    @Nullable
    private final Instant finishTime;

    private JobStateImpl(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
        this.status = Objects.requireNonNull(builder.status, "status");
        this.createTime = Objects.requireNonNull(builder.createTime, "createTime");
        this.startTime = builder.startTime;
        this.finishTime = builder.finishTime;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public JobStatus status() {
        return this.status;
    }

    @Override
    public Instant createTime() {
        return this.createTime;
    }

    @Override
    @Nullable
    public Instant startTime() {
        return this.startTime;
    }

    @Override
    @Nullable
    public Instant finishTime() {
        return this.finishTime;
    }

    public static Builder toBuilder(JobState state) {
        return new Builder(state);
    }

    public String toString() {
        return S.toString(this);
    }

    public static class Builder {
        private UUID id;
        private JobStatus status;
        private Instant createTime;
        @Nullable
        private Instant startTime;
        @Nullable
        private Instant finishTime;

        private Builder() {
        }

        private Builder(JobState state) {
            this.id = state.id();
            this.status = state.status();
            this.createTime = state.createTime();
            this.startTime = state.startTime();
            this.finishTime = state.finishTime();
        }

        public Builder id(UUID id) {
            this.id = id;
            return this;
        }

        public Builder status(JobStatus status) {
            this.status = status;
            return this;
        }

        public Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public Builder startTime(@Nullable Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder finishTime(@Nullable Instant finishTime) {
            this.finishTime = finishTime;
            return this;
        }

        public JobStateImpl build() {
            return new JobStateImpl(this);
        }
    }
}

