/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.client.table;

import org.gridgain.shaded.org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.gridgain.shaded.org.apache.ignite.internal.client.proto.TuplePart;
import org.gridgain.shaded.org.apache.ignite.internal.client.table.ClientColumn;
import org.gridgain.shaded.org.apache.ignite.internal.client.table.ClientSchema;
import org.gridgain.shaded.org.apache.ignite.internal.client.table.MutableTupleBinaryTupleAdapter;
import org.gridgain.shaded.org.apache.ignite.lang.util.IgniteNameUtils;
import org.gridgain.shaded.org.apache.ignite.sql.ColumnType;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

public class ClientTuple
extends MutableTupleBinaryTupleAdapter {
    private final ClientSchema schema;
    private final TuplePart part;
    private final boolean fullBinaryTuple;

    public ClientTuple(ClientSchema schema, TuplePart part, BinaryTupleReader binaryTuple) {
        super(binaryTuple, schema.columns(part).length, null);
        assert (binaryTuple.elementCount() <= schema.columns().length) : "Binary tuple element count is greater than schema column count: [binaryTuple=" + binaryTuple.elementCount() + ", schema=" + schema.columns().length + "]";
        this.schema = schema;
        this.part = part;
        this.fullBinaryTuple = binaryTuple.elementCount() == schema.columns().length;
    }

    @Override
    protected String schemaColumnName(int binaryTupleIndex) {
        return this.column(binaryTupleIndex).name();
    }

    @Override
    protected int binaryTupleIndex(String columnName) {
        return this.binaryTupleIndex(this.column(columnName));
    }

    @Override
    protected int binaryTupleIndex(int publicIndex) {
        if (this.part == TuplePart.KEY_AND_VAL) {
            return publicIndex;
        }
        return this.binaryTupleIndex(this.schema.columns(this.part)[publicIndex]);
    }

    private int binaryTupleIndex(@Nullable ClientColumn column) {
        if (column == null) {
            return -1;
        }
        if (this.fullBinaryTuple) {
            if (this.part == TuplePart.KEY && column.keyIndex() < 0) {
                return -1;
            }
            if (this.part == TuplePart.VAL && column.valIndex() < 0) {
                return -1;
            }
            return column.schemaIndex();
        }
        return this.part == TuplePart.KEY ? column.keyIndex() : column.valIndex();
    }

    @Override
    protected int publicIndex(int binaryTupleIndex) {
        if (this.part == TuplePart.KEY_AND_VAL) {
            return binaryTupleIndex;
        }
        ClientColumn col = this.column(binaryTupleIndex);
        return this.part == TuplePart.KEY ? col.keyIndex() : col.valIndex();
    }

    @Override
    protected ColumnType schemaColumnType(int binaryTupleIndex) {
        ClientColumn column = this.column(binaryTupleIndex);
        return column.type();
    }

    @Override
    protected int schemaDecimalScale(int binaryTupleIndex) {
        return this.column(binaryTupleIndex).scale();
    }

    @Nullable
    private ClientColumn column(String columnName) {
        return this.schema.columnSafe(IgniteNameUtils.parseIdentifier(columnName));
    }

    private ClientColumn column(int binaryTupleIndex) {
        if (this.fullBinaryTuple) {
            return this.schema.columns()[binaryTupleIndex];
        }
        return this.schema.columns(this.part)[binaryTupleIndex];
    }

    public ClientSchema schema() {
        return this.schema;
    }
}

