/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.com.google.common.cache;

import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.gridgain.shaded.com.google.common.annotations.GwtIncompatible;
import org.gridgain.shaded.com.google.common.annotations.VisibleForTesting;
import org.gridgain.shaded.com.google.common.base.MoreObjects;
import org.gridgain.shaded.com.google.common.base.Preconditions;
import org.gridgain.shaded.com.google.common.base.Splitter;
import org.gridgain.shaded.com.google.common.base.Strings;
import org.gridgain.shaded.com.google.common.cache.CacheBuilder;
import org.gridgain.shaded.com.google.common.cache.LocalCache;
import org.gridgain.shaded.com.google.common.collect.ImmutableList;
import org.gridgain.shaded.com.google.common.collect.ImmutableMap;
import org.jspecify.annotations.Nullable;

@GwtIncompatible
public final class CacheBuilderSpec {
    private static final Splitter KEYS_SPLITTER = Splitter.on(',').trimResults();
    private static final Splitter KEY_VALUE_SPLITTER = Splitter.on('=').trimResults();
    private static final ImmutableMap<String, ValueParser> VALUE_PARSERS = ImmutableMap.builder().put("initialCapacity", new InitialCapacityParser()).put("maximumSize", (InitialCapacityParser)((Object)new MaximumSizeParser())).put("maximumWeight", (InitialCapacityParser)((Object)new MaximumWeightParser())).put("concurrencyLevel", (InitialCapacityParser)((Object)new ConcurrencyLevelParser())).put("weakKeys", (InitialCapacityParser)((Object)new KeyStrengthParser(LocalCache.Strength.WEAK))).put("softValues", (InitialCapacityParser)((Object)new ValueStrengthParser(LocalCache.Strength.SOFT))).put("weakValues", (InitialCapacityParser)((Object)new ValueStrengthParser(LocalCache.Strength.WEAK))).put("recordStats", (InitialCapacityParser)((Object)new RecordStatsParser())).put("expireAfterAccess", (InitialCapacityParser)((Object)new AccessDurationParser())).put("expireAfterWrite", (InitialCapacityParser)((Object)new WriteDurationParser())).put("refreshAfterWrite", (InitialCapacityParser)((Object)new RefreshDurationParser())).put("refreshInterval", (InitialCapacityParser)((Object)new RefreshDurationParser())).buildOrThrow();
    @VisibleForTesting
    @Nullable Integer initialCapacity;
    @VisibleForTesting
    @Nullable Long maximumSize;
    @VisibleForTesting
    @Nullable Long maximumWeight;
    @VisibleForTesting
    @Nullable Integer concurrencyLevel;
    @VisibleForTesting
     @Nullable LocalCache.Strength keyStrength;
    @VisibleForTesting
     @Nullable LocalCache.Strength valueStrength;
    @VisibleForTesting
    @Nullable Boolean recordStats;
    @VisibleForTesting
    long writeExpirationDuration;
    @VisibleForTesting
    @Nullable TimeUnit writeExpirationTimeUnit;
    @VisibleForTesting
    long accessExpirationDuration;
    @VisibleForTesting
    @Nullable TimeUnit accessExpirationTimeUnit;
    @VisibleForTesting
    long refreshDuration;
    @VisibleForTesting
    @Nullable TimeUnit refreshTimeUnit;
    private final String specification;

    private CacheBuilderSpec(String specification) {
        this.specification = specification;
    }

    public static CacheBuilderSpec parse(String cacheBuilderSpecification) {
        CacheBuilderSpec spec = new CacheBuilderSpec(cacheBuilderSpecification);
        if (!cacheBuilderSpecification.isEmpty()) {
            for (String keyValuePair : KEYS_SPLITTER.split(cacheBuilderSpecification)) {
                ImmutableList<String> keyAndValue = ImmutableList.copyOf(KEY_VALUE_SPLITTER.split(keyValuePair));
                Preconditions.checkArgument(!keyAndValue.isEmpty(), "blank key-value pair");
                Preconditions.checkArgument(keyAndValue.size() <= 2, "key-value pair %s with more than one equals sign", (Object)keyValuePair);
                String key = (String)keyAndValue.get(0);
                ValueParser valueParser = VALUE_PARSERS.get(key);
                Preconditions.checkArgument(valueParser != null, "unknown key %s", (Object)key);
                String value = keyAndValue.size() == 1 ? null : (String)keyAndValue.get(1);
                valueParser.parse(spec, key, value);
            }
        }
        return spec;
    }

    public static CacheBuilderSpec disableCaching() {
        return CacheBuilderSpec.parse("maximumSize=0");
    }

    CacheBuilder<Object, Object> toCacheBuilder() {
        CacheBuilder<Object, Object> builder = CacheBuilder.newBuilder();
        if (this.initialCapacity != null) {
            builder.initialCapacity(this.initialCapacity);
        }
        if (this.maximumSize != null) {
            builder.maximumSize(this.maximumSize);
        }
        if (this.maximumWeight != null) {
            builder.maximumWeight(this.maximumWeight);
        }
        if (this.concurrencyLevel != null) {
            builder.concurrencyLevel(this.concurrencyLevel);
        }
        if (this.keyStrength != null) {
            switch (this.keyStrength) {
                case WEAK: {
                    builder.weakKeys();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        if (this.valueStrength != null) {
            switch (this.valueStrength) {
                case SOFT: {
                    builder.softValues();
                    break;
                }
                case WEAK: {
                    builder.weakValues();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        if (this.recordStats != null && this.recordStats.booleanValue()) {
            builder.recordStats();
        }
        if (this.writeExpirationTimeUnit != null) {
            builder.expireAfterWrite(this.writeExpirationDuration, this.writeExpirationTimeUnit);
        }
        if (this.accessExpirationTimeUnit != null) {
            builder.expireAfterAccess(this.accessExpirationDuration, this.accessExpirationTimeUnit);
        }
        if (this.refreshTimeUnit != null) {
            builder.refreshAfterWrite(this.refreshDuration, this.refreshTimeUnit);
        }
        return builder;
    }

    public String toParsableString() {
        return this.specification;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).addValue(this.toParsableString()).toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.initialCapacity, this.maximumSize, this.maximumWeight, this.concurrencyLevel, this.keyStrength, this.valueStrength, this.recordStats, CacheBuilderSpec.durationInNanos(this.writeExpirationDuration, this.writeExpirationTimeUnit), CacheBuilderSpec.durationInNanos(this.accessExpirationDuration, this.accessExpirationTimeUnit), CacheBuilderSpec.durationInNanos(this.refreshDuration, this.refreshTimeUnit)});
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CacheBuilderSpec)) {
            return false;
        }
        CacheBuilderSpec that = (CacheBuilderSpec)obj;
        return Objects.equals(this.initialCapacity, that.initialCapacity) && Objects.equals(this.maximumSize, that.maximumSize) && Objects.equals(this.maximumWeight, that.maximumWeight) && Objects.equals(this.concurrencyLevel, that.concurrencyLevel) && Objects.equals((Object)this.keyStrength, (Object)that.keyStrength) && Objects.equals((Object)this.valueStrength, (Object)that.valueStrength) && Objects.equals(this.recordStats, that.recordStats) && Objects.equals(CacheBuilderSpec.durationInNanos(this.writeExpirationDuration, this.writeExpirationTimeUnit), CacheBuilderSpec.durationInNanos(that.writeExpirationDuration, that.writeExpirationTimeUnit)) && Objects.equals(CacheBuilderSpec.durationInNanos(this.accessExpirationDuration, this.accessExpirationTimeUnit), CacheBuilderSpec.durationInNanos(that.accessExpirationDuration, that.accessExpirationTimeUnit)) && Objects.equals(CacheBuilderSpec.durationInNanos(this.refreshDuration, this.refreshTimeUnit), CacheBuilderSpec.durationInNanos(that.refreshDuration, that.refreshTimeUnit));
    }

    private static @Nullable Long durationInNanos(long duration, @Nullable TimeUnit unit) {
        return unit == null ? null : Long.valueOf(unit.toNanos(duration));
    }

    private static String format(String format, Object ... args) {
        return String.format(Locale.ROOT, format, args);
    }

    private static interface ValueParser {
        public void parse(CacheBuilderSpec var1, String var2, @Nullable String var3);
    }

    private static final class InitialCapacityParser
    extends IntegerParser {
        private InitialCapacityParser() {
        }

        @Override
        protected void parseInteger(CacheBuilderSpec spec, int value) {
            Preconditions.checkArgument(spec.initialCapacity == null, "initial capacity was already set to %s", (Object)spec.initialCapacity);
            spec.initialCapacity = value;
        }
    }

    private static final class MaximumSizeParser
    extends LongParser {
        private MaximumSizeParser() {
        }

        @Override
        protected void parseLong(CacheBuilderSpec spec, long value) {
            Preconditions.checkArgument(spec.maximumSize == null, "maximum size was already set to %s", (Object)spec.maximumSize);
            Preconditions.checkArgument(spec.maximumWeight == null, "maximum weight was already set to %s", (Object)spec.maximumWeight);
            spec.maximumSize = value;
        }
    }

    private static final class MaximumWeightParser
    extends LongParser {
        private MaximumWeightParser() {
        }

        @Override
        protected void parseLong(CacheBuilderSpec spec, long value) {
            Preconditions.checkArgument(spec.maximumWeight == null, "maximum weight was already set to %s", (Object)spec.maximumWeight);
            Preconditions.checkArgument(spec.maximumSize == null, "maximum size was already set to %s", (Object)spec.maximumSize);
            spec.maximumWeight = value;
        }
    }

    private static final class ConcurrencyLevelParser
    extends IntegerParser {
        private ConcurrencyLevelParser() {
        }

        @Override
        protected void parseInteger(CacheBuilderSpec spec, int value) {
            Preconditions.checkArgument(spec.concurrencyLevel == null, "concurrency level was already set to %s", (Object)spec.concurrencyLevel);
            spec.concurrencyLevel = value;
        }
    }

    private static final class KeyStrengthParser
    implements ValueParser {
        private final LocalCache.Strength strength;

        public KeyStrengthParser(LocalCache.Strength strength) {
            this.strength = strength;
        }

        @Override
        public void parse(CacheBuilderSpec spec, String key, @Nullable String value) {
            Preconditions.checkArgument(value == null, "key %s does not take values", (Object)key);
            Preconditions.checkArgument(spec.keyStrength == null, "%s was already set to %s", (Object)key, (Object)spec.keyStrength);
            spec.keyStrength = this.strength;
        }
    }

    private static final class ValueStrengthParser
    implements ValueParser {
        private final LocalCache.Strength strength;

        public ValueStrengthParser(LocalCache.Strength strength) {
            this.strength = strength;
        }

        @Override
        public void parse(CacheBuilderSpec spec, String key, @Nullable String value) {
            Preconditions.checkArgument(value == null, "key %s does not take values", (Object)key);
            Preconditions.checkArgument(spec.valueStrength == null, "%s was already set to %s", (Object)key, (Object)spec.valueStrength);
            spec.valueStrength = this.strength;
        }
    }

    private static final class RecordStatsParser
    implements ValueParser {
        private RecordStatsParser() {
        }

        @Override
        public void parse(CacheBuilderSpec spec, String key, @Nullable String value) {
            Preconditions.checkArgument(value == null, "recordStats does not take values");
            Preconditions.checkArgument(spec.recordStats == null, "recordStats already set");
            spec.recordStats = true;
        }
    }

    private static final class AccessDurationParser
    extends DurationParser {
        private AccessDurationParser() {
        }

        @Override
        protected void parseDuration(CacheBuilderSpec spec, long duration, TimeUnit unit) {
            Preconditions.checkArgument(spec.accessExpirationTimeUnit == null, "expireAfterAccess already set");
            spec.accessExpirationDuration = duration;
            spec.accessExpirationTimeUnit = unit;
        }
    }

    private static final class WriteDurationParser
    extends DurationParser {
        private WriteDurationParser() {
        }

        @Override
        protected void parseDuration(CacheBuilderSpec spec, long duration, TimeUnit unit) {
            Preconditions.checkArgument(spec.writeExpirationTimeUnit == null, "expireAfterWrite already set");
            spec.writeExpirationDuration = duration;
            spec.writeExpirationTimeUnit = unit;
        }
    }

    private static final class RefreshDurationParser
    extends DurationParser {
        private RefreshDurationParser() {
        }

        @Override
        protected void parseDuration(CacheBuilderSpec spec, long duration, TimeUnit unit) {
            Preconditions.checkArgument(spec.refreshTimeUnit == null, "refreshAfterWrite already set");
            spec.refreshDuration = duration;
            spec.refreshTimeUnit = unit;
        }
    }

    static abstract class DurationParser
    implements ValueParser {
        DurationParser() {
        }

        protected abstract void parseDuration(CacheBuilderSpec var1, long var2, TimeUnit var4);

        @Override
        public void parse(CacheBuilderSpec spec, String key, @Nullable String value) {
            if (Strings.isNullOrEmpty(value)) {
                throw new IllegalArgumentException("value of key " + key + " omitted");
            }
            try {
                TimeUnit timeUnit;
                char lastChar = value.charAt(value.length() - 1);
                switch (lastChar) {
                    case 'd': {
                        timeUnit = TimeUnit.DAYS;
                        break;
                    }
                    case 'h': {
                        timeUnit = TimeUnit.HOURS;
                        break;
                    }
                    case 'm': {
                        timeUnit = TimeUnit.MINUTES;
                        break;
                    }
                    case 's': {
                        timeUnit = TimeUnit.SECONDS;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(CacheBuilderSpec.format("key %s invalid unit: was %s, must end with one of [dhms]", new Object[]{key, value}));
                    }
                }
                long duration = Long.parseLong(value.substring(0, value.length() - 1));
                this.parseDuration(spec, duration, timeUnit);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(CacheBuilderSpec.format("key %s value set to %s, must be integer", new Object[]{key, value}));
            }
        }
    }

    static abstract class LongParser
    implements ValueParser {
        LongParser() {
        }

        protected abstract void parseLong(CacheBuilderSpec var1, long var2);

        @Override
        public void parse(CacheBuilderSpec spec, String key, @Nullable String value) {
            if (Strings.isNullOrEmpty(value)) {
                throw new IllegalArgumentException("value of key " + key + " omitted");
            }
            try {
                this.parseLong(spec, Long.parseLong(value));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(CacheBuilderSpec.format("key %s value set to %s, must be integer", new Object[]{key, value}), e);
            }
        }
    }

    static abstract class IntegerParser
    implements ValueParser {
        IntegerParser() {
        }

        protected abstract void parseInteger(CacheBuilderSpec var1, int var2);

        @Override
        public void parse(CacheBuilderSpec spec, String key, @Nullable String value) {
            if (Strings.isNullOrEmpty(value)) {
                throw new IllegalArgumentException("value of key " + key + " omitted");
            }
            try {
                this.parseInteger(spec, Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(CacheBuilderSpec.format("key %s value set to %s, must be integer", new Object[]{key, value}), e);
            }
        }
    }
}

