/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.table.criteria;

import java.util.Arrays;
import java.util.Objects;
import org.gridgain.shaded.org.apache.ignite.table.criteria.Column;
import org.gridgain.shaded.org.apache.ignite.table.criteria.Condition;
import org.gridgain.shaded.org.apache.ignite.table.criteria.CriteriaVisitor;
import org.gridgain.shaded.org.apache.ignite.table.criteria.Expression;
import org.gridgain.shaded.org.apache.ignite.table.criteria.Operator;
import org.gridgain.shaded.org.apache.ignite.table.criteria.Parameter;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

public interface Criteria {
    public <C> void accept(CriteriaVisitor<C> var1, @Nullable C var2);

    public static Expression columnValue(String columnName, Condition condition) {
        Criteria[] oldElements = condition.getElements();
        Criteria[] newElements = new Criteria[oldElements.length + 1];
        newElements[0] = new Column(columnName);
        System.arraycopy(oldElements, 0, newElements, 1, oldElements.length);
        return new Expression(condition.getOperator(), newElements);
    }

    public static Expression not(Expression expression) {
        Objects.requireNonNull(expression, "expression must not be null");
        return new Expression(Operator.NOT, expression);
    }

    public static Expression and(Expression ... expressions) {
        if (expressions == null || expressions.length == 0 || Arrays.stream(expressions).anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("expressions must not be empty or null");
        }
        return new Expression(Operator.AND, expressions);
    }

    public static Expression or(Expression ... expressions) {
        if (expressions == null || expressions.length == 0 || Arrays.stream(expressions).anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("expressions must not be empty or null");
        }
        return new Expression(Operator.OR, expressions);
    }

    public static <T> Condition equalTo(Comparable<T> value) {
        if (value == null) {
            return Criteria.nullValue();
        }
        return new Condition(Operator.EQ, new Parameter<Comparable<T>>(value));
    }

    public static Condition equalTo(byte[] value) {
        if (value == null) {
            return Criteria.nullValue();
        }
        return new Condition(Operator.EQ, new Parameter<byte[]>(value));
    }

    public static <T> Condition notEqualTo(Comparable<T> value) {
        if (value == null) {
            return Criteria.notNullValue();
        }
        return new Condition(Operator.NOT_EQ, new Parameter<Comparable<T>>(value));
    }

    public static Condition notEqualTo(byte[] value) {
        if (value == null) {
            return Criteria.notNullValue();
        }
        return new Condition(Operator.NOT_EQ, new Parameter<byte[]>(value));
    }

    public static <T> Condition greaterThan(Comparable<T> value) {
        return new Condition(Operator.GT, new Parameter<Comparable<T>>(value));
    }

    public static <T> Condition greaterThanOrEqualTo(Comparable<T> value) {
        return new Condition(Operator.GOE, new Parameter<Comparable<T>>(value));
    }

    public static <T> Condition lessThan(Comparable<T> value) {
        return new Condition(Operator.LT, new Parameter<Comparable<T>>(value));
    }

    public static <T> Condition lessThanOrEqualTo(Comparable<T> value) {
        return new Condition(Operator.LOE, new Parameter<Comparable<T>>(value));
    }

    public static Condition nullValue() {
        return new Condition(Operator.IS_NULL, new Criteria[0]);
    }

    public static Condition notNullValue() {
        return new Condition(Operator.IS_NOT_NULL, new Criteria[0]);
    }

    public static <T> Condition in(Comparable<T> ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("values must not be empty or null");
        }
        if (values.length == 1) {
            return Criteria.equalTo(values[0]);
        }
        Criteria[] args = (Criteria[])Arrays.stream(values).map(Parameter::new).toArray(Criteria[]::new);
        return new Condition(Operator.IN, args);
    }

    public static Condition in(byte[] ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("values must not be empty or null");
        }
        if (values.length == 1) {
            return Criteria.equalTo(values[0]);
        }
        Criteria[] args = (Criteria[])Arrays.stream(values).map(Parameter::new).toArray(Criteria[]::new);
        return new Condition(Operator.IN, args);
    }

    public static <T> Condition notIn(Comparable<T> ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("values must not be empty or null");
        }
        if (values.length == 1) {
            return Criteria.notEqualTo(values[0]);
        }
        Criteria[] args = (Criteria[])Arrays.stream(values).map(Parameter::new).toArray(Criteria[]::new);
        return new Condition(Operator.NOT_IN, args);
    }

    public static Condition notIn(byte[] ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("values must not be empty or null");
        }
        if (values.length == 1) {
            return Criteria.notEqualTo(values[0]);
        }
        Criteria[] args = (Criteria[])Arrays.stream(values).map(Parameter::new).toArray(Criteria[]::new);
        return new Condition(Operator.NOT_IN, args);
    }
}

