/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.util;

import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.gridgain.shaded.org.apache.ignite.internal.util.PendingComparableValuesTracker;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

public class PendingIndependentComparableValuesTracker<T extends Comparable<T>, R>
extends PendingComparableValuesTracker<T, R> {
    private final ConcurrentSkipListMap<T, Set<CompletableFuture<R>>> valueFutures = new ConcurrentSkipListMap();

    public PendingIndependentComparableValuesTracker(T initialValue) {
        super(initialValue);
    }

    @Override
    protected void completeWaitersOnUpdate(T newValue, @Nullable R futureResult) {
        NavigableMap smallerFutures = this.valueFutures.headMap((Object)newValue, true);
        smallerFutures.forEach((k, futureSet) -> futureSet.forEach(f -> f.complete(futureResult)));
        smallerFutures.clear();
    }

    @Override
    protected CompletableFuture<R> addNewWaiter(T valueToWait) {
        CompletableFuture future = new CompletableFuture();
        this.valueFutures.compute(valueToWait, (k, v) -> {
            if (v == null) {
                v = ConcurrentHashMap.newKeySet();
            }
            v.add(future);
            return v;
        });
        Map.Entry currentEntry = this.currentEntry();
        if (((Comparable)currentEntry.getKey()).compareTo(valueToWait) >= 0) {
            future.complete(currentEntry.getValue());
        }
        return future;
    }

    @Override
    protected void cleanupWaitersOnClose(Exception waiterCompletionException) {
        this.valueFutures.forEach((k, futureSet) -> futureSet.forEach(f -> f.completeExceptionally(waiterCompletionException)));
        this.valueFutures.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.valueFutures.isEmpty();
    }
}

