/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.type;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;
import org.gridgain.shaded.org.apache.ignite.internal.type.DecimalNativeType;
import org.gridgain.shaded.org.apache.ignite.internal.type.NativeType;
import org.gridgain.shaded.org.apache.ignite.internal.type.TemporalNativeType;
import org.gridgain.shaded.org.apache.ignite.internal.type.VarlenNativeType;
import org.gridgain.shaded.org.apache.ignite.sql.ColumnType;
import org.gridgain.shaded.org.jetbrains.annotations.Contract;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

public class NativeTypes {
    public static final int MAX_TIME_PRECISION = 9;
    public static final NativeType BOOLEAN = new NativeType(ColumnType.BOOLEAN, 1);
    public static final NativeType INT8 = new NativeType(ColumnType.INT8, 1);
    public static final NativeType INT16 = new NativeType(ColumnType.INT16, 2);
    public static final NativeType INT32 = new NativeType(ColumnType.INT32, 4);
    public static final NativeType INT64 = new NativeType(ColumnType.INT64, 8);
    public static final NativeType FLOAT = new NativeType(ColumnType.FLOAT, 4);
    public static final NativeType DOUBLE = new NativeType(ColumnType.DOUBLE, 8);
    public static final NativeType UUID = new NativeType(ColumnType.UUID, 16);
    public static final NativeType STRING = new VarlenNativeType(ColumnType.STRING, 65536);
    public static final NativeType BYTES = new VarlenNativeType(ColumnType.BYTE_ARRAY, 65536);
    public static final NativeType DATE = new NativeType(ColumnType.DATE, 3);
    public static final NativeType DURATION = new NativeType(ColumnType.DURATION, 8);
    public static final NativeType PERIOD = new NativeType(ColumnType.PERIOD, 4);

    private NativeTypes() {
    }

    public static NativeType stringOf(int len) {
        return new VarlenNativeType(ColumnType.STRING, len);
    }

    public static NativeType blobOf(int len) {
        return new VarlenNativeType(ColumnType.BYTE_ARRAY, len);
    }

    public static NativeType decimalOf(int precision, int scale) {
        return new DecimalNativeType(precision, scale);
    }

    public static NativeType time(int precision) {
        return TemporalNativeType.time(precision);
    }

    public static NativeType datetime(int precision) {
        return TemporalNativeType.datetime(precision);
    }

    public static NativeType timestamp(int precision) {
        return TemporalNativeType.timestamp(precision);
    }

    @Contract(value="null -> null")
    @Nullable
    public static NativeType fromObject(@Nullable Object val) {
        if (val == null) {
            return null;
        }
        Class<?> cls = val.getClass();
        if (!NativeTypes.supportedClass(cls)) {
            return null;
        }
        if (cls == Boolean.class) {
            return BOOLEAN;
        }
        if (cls == Byte.class) {
            return INT8;
        }
        if (cls == Short.class) {
            return INT16;
        }
        if (cls == Integer.class) {
            return INT32;
        }
        if (cls == Long.class) {
            return INT64;
        }
        if (cls == Float.class) {
            return FLOAT;
        }
        if (cls == Double.class) {
            return DOUBLE;
        }
        if (cls == LocalDate.class) {
            return DATE;
        }
        if (cls == LocalTime.class) {
            assert (val instanceof LocalTime) : val.getClass().getCanonicalName();
            return NativeTypes.time(NativeTypes.derivePrecisionFromNanos(((LocalTime)val).getNano()));
        }
        if (cls == LocalDateTime.class) {
            assert (val instanceof LocalDateTime) : val.getClass().getCanonicalName();
            return NativeTypes.datetime(NativeTypes.derivePrecisionFromNanos(((LocalDateTime)val).getNano()));
        }
        if (cls == Instant.class) {
            assert (val instanceof Instant) : val.getClass().getCanonicalName();
            return NativeTypes.timestamp(NativeTypes.derivePrecisionFromNanos(((Instant)val).getNano()));
        }
        if (cls == byte[].class) {
            return NativeTypes.blobOf(((byte[])val).length);
        }
        if (cls == String.class) {
            return NativeTypes.stringOf(((CharSequence)val).length());
        }
        if (cls == UUID.class) {
            return UUID;
        }
        if (cls == BigDecimal.class) {
            return NativeTypes.decimalOf(((BigDecimal)val).precision(), ((BigDecimal)val).scale());
        }
        throw new UnsupportedOperationException("Class is not supported: " + cls);
    }

    private static boolean supportedClass(Class<?> cls) {
        assert (cls != null);
        return cls == Boolean.class || cls == Byte.class || cls == Short.class || cls == Integer.class || cls == Long.class || cls == Float.class || cls == Double.class || cls == LocalDate.class || cls == LocalTime.class || cls == LocalDateTime.class || cls == Instant.class || cls == byte[].class || cls == String.class || cls == UUID.class || cls == BigDecimal.class;
    }

    private static int derivePrecisionFromNanos(int nanos) {
        if (nanos == 0) {
            return 0;
        }
        int trailingZeroes = 0;
        while (nanos % 10 == 0) {
            ++trailingZeroes;
            nanos /= 10;
        }
        return 9 - trailingZeroes;
    }
}

