/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.table;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.gridgain.shaded.org.apache.ignite.internal.wrapper.Wrapper;
import org.gridgain.shaded.org.apache.ignite.internal.wrapper.Wrappers;
import org.gridgain.shaded.org.apache.ignite.lang.AsyncCursor;
import org.gridgain.shaded.org.apache.ignite.lang.Cursor;
import org.gridgain.shaded.org.apache.ignite.lang.NullableValue;
import org.gridgain.shaded.org.apache.ignite.table.ContinuousQueryOptions;
import org.gridgain.shaded.org.apache.ignite.table.DataStreamerItem;
import org.gridgain.shaded.org.apache.ignite.table.DataStreamerOptions;
import org.gridgain.shaded.org.apache.ignite.table.DataStreamerReceiverDescriptor;
import org.gridgain.shaded.org.apache.ignite.table.KeyValueView;
import org.gridgain.shaded.org.apache.ignite.table.TableRowEventBatch;
import org.gridgain.shaded.org.apache.ignite.table.criteria.Criteria;
import org.gridgain.shaded.org.apache.ignite.table.criteria.CriteriaQueryOptions;
import org.gridgain.shaded.org.apache.ignite.tx.Transaction;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

public class CloseableKeyValueView<K, V>
implements KeyValueView<K, V>,
Closeable,
Wrapper {
    private final KeyValueView<K, V> base;
    private volatile boolean closed = false;

    public CloseableKeyValueView(KeyValueView<K, V> base) {
        this.base = base;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    @Nullable
    public V get(@Nullable Transaction tx, K key) {
        this.checkState();
        return this.base.get(tx, key);
    }

    @Override
    public CompletableFuture<V> getAsync(@Nullable Transaction tx, K key) {
        this.checkState();
        return this.base.getAsync(tx, key);
    }

    @Override
    public NullableValue<V> getNullable(@Nullable Transaction tx, K key) {
        this.checkState();
        return this.base.getNullable(tx, key);
    }

    @Override
    public CompletableFuture<NullableValue<V>> getNullableAsync(@Nullable Transaction tx, K key) {
        this.checkState();
        return this.base.getNullableAsync(tx, key);
    }

    @Override
    @Nullable
    public V getOrDefault(@Nullable Transaction tx, K key, @Nullable V defaultValue) {
        this.checkState();
        return this.base.getOrDefault(tx, key, defaultValue);
    }

    @Override
    public CompletableFuture<V> getOrDefaultAsync(@Nullable Transaction tx, K key, @Nullable V defaultValue) {
        this.checkState();
        return this.base.getOrDefaultAsync(tx, key, defaultValue);
    }

    @Override
    public Map<K, V> getAll(@Nullable Transaction tx, Collection<K> keys) {
        this.checkState();
        return this.base.getAll(tx, keys);
    }

    @Override
    public CompletableFuture<Map<K, V>> getAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        this.checkState();
        return this.base.getAllAsync(tx, keys);
    }

    @Override
    public boolean contains(@Nullable Transaction tx, K key) {
        this.checkState();
        return this.base.contains(tx, key);
    }

    @Override
    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, K key) {
        this.checkState();
        return this.base.containsAsync(tx, key);
    }

    @Override
    public boolean containsAll(@Nullable Transaction tx, Collection<K> keys) {
        this.checkState();
        return this.base.containsAll(tx, keys);
    }

    @Override
    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        this.checkState();
        return this.base.containsAllAsync(tx, keys);
    }

    @Override
    public void put(@Nullable Transaction tx, K key, @Nullable V val) {
        this.checkState();
        this.base.put(tx, key, val);
    }

    @Override
    public CompletableFuture<Void> putAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        this.checkState();
        return this.base.putAsync(tx, key, val);
    }

    @Override
    public void putAll(@Nullable Transaction tx, Map<K, V> pairs) {
        this.checkState();
        this.base.putAll(tx, pairs);
    }

    @Override
    public CompletableFuture<Void> putAllAsync(@Nullable Transaction tx, Map<K, V> pairs) {
        this.checkState();
        return this.base.putAllAsync(tx, pairs);
    }

    @Override
    @Nullable
    public V getAndPut(@Nullable Transaction tx, K key, @Nullable V val) {
        this.checkState();
        return this.base.getAndPut(tx, key, val);
    }

    @Override
    public CompletableFuture<V> getAndPutAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        this.checkState();
        return this.base.getAndPutAsync(tx, key, val);
    }

    @Override
    public NullableValue<V> getNullableAndPut(@Nullable Transaction tx, K key, @Nullable V val) {
        this.checkState();
        return this.base.getNullableAndPut(tx, key, val);
    }

    @Override
    public CompletableFuture<NullableValue<V>> getNullableAndPutAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        this.checkState();
        return this.base.getNullableAndPutAsync(tx, key, val);
    }

    @Override
    public boolean putIfAbsent(@Nullable Transaction tx, K key, @Nullable V val) {
        this.checkState();
        return this.base.putIfAbsent(tx, key, val);
    }

    @Override
    public CompletableFuture<Boolean> putIfAbsentAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        this.checkState();
        return this.base.putIfAbsentAsync(tx, key, val);
    }

    @Override
    public boolean remove(@Nullable Transaction tx, K key) {
        this.checkState();
        return this.base.remove(tx, key);
    }

    @Override
    public boolean remove(@Nullable Transaction tx, K key, V val) {
        this.checkState();
        return this.base.remove(tx, key, val);
    }

    @Override
    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, K key) {
        this.checkState();
        return this.base.removeAsync(tx, key);
    }

    @Override
    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, K key, V val) {
        this.checkState();
        return this.base.removeAsync(tx, key, val);
    }

    @Override
    public void removeAll(@Nullable Transaction tx) {
        this.checkState();
        this.base.removeAll(tx);
    }

    @Override
    public Collection<K> removeAll(@Nullable Transaction tx, Collection<K> keys) {
        this.checkState();
        return this.base.removeAll(tx, keys);
    }

    @Override
    public CompletableFuture<Collection<K>> removeAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        this.checkState();
        return this.base.removeAllAsync(tx, keys);
    }

    @Override
    public CompletableFuture<Void> removeAllAsync(@Nullable Transaction tx) {
        this.checkState();
        return this.base.removeAllAsync(tx);
    }

    @Override
    @Nullable
    public V getAndRemove(@Nullable Transaction tx, K key) {
        this.checkState();
        return this.base.getAndRemove(tx, key);
    }

    @Override
    public CompletableFuture<V> getAndRemoveAsync(@Nullable Transaction tx, K key) {
        this.checkState();
        return this.base.getAndRemoveAsync(tx, key);
    }

    @Override
    public NullableValue<V> getNullableAndRemove(@Nullable Transaction tx, K key) {
        this.checkState();
        return this.base.getNullableAndRemove(tx, key);
    }

    @Override
    public CompletableFuture<NullableValue<V>> getNullableAndRemoveAsync(@Nullable Transaction tx, K key) {
        this.checkState();
        return this.base.getNullableAndRemoveAsync(tx, key);
    }

    @Override
    public boolean replace(@Nullable Transaction tx, K key, @Nullable V val) {
        this.checkState();
        return this.base.replace(tx, key, val);
    }

    @Override
    public boolean replace(@Nullable Transaction tx, K key, @Nullable V oldValue, @Nullable V newValue) {
        this.checkState();
        return this.base.replace(tx, key, oldValue, newValue);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        this.checkState();
        return this.base.replaceAsync(tx, key, val);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, K key, @Nullable V oldVal, @Nullable V newVal) {
        this.checkState();
        return this.base.replaceAsync(tx, key, oldVal, newVal);
    }

    @Override
    @Nullable
    public V getAndReplace(@Nullable Transaction tx, K key, @Nullable V val) {
        this.checkState();
        return this.base.getAndReplace(tx, key, val);
    }

    @Override
    public CompletableFuture<V> getAndReplaceAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        this.checkState();
        return this.base.getAndReplaceAsync(tx, key, val);
    }

    @Override
    public NullableValue<V> getNullableAndReplace(@Nullable Transaction tx, K key, @Nullable V val) {
        this.checkState();
        return this.base.getNullableAndReplace(tx, key, val);
    }

    @Override
    public CompletableFuture<NullableValue<V>> getNullableAndReplaceAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        this.checkState();
        return this.base.getNullableAndReplaceAsync(tx, key, val);
    }

    @Override
    public void queryContinuously(Flow.Subscriber<TableRowEventBatch<Map.Entry<K, V>>> subscriber, @Nullable ContinuousQueryOptions options) {
        this.checkState();
        this.base.queryContinuously(subscriber, options);
    }

    @Override
    public void queryContinuously(Flow.Subscriber<TableRowEventBatch<Map.Entry<K, V>>> subscriber) {
        this.checkState();
        this.base.queryContinuously(subscriber);
    }

    @Override
    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<Map.Entry<K, V>>> publisher, @Nullable DataStreamerOptions options) {
        this.checkState();
        return this.base.streamData(publisher, options);
    }

    @Override
    public <E, P, A, R> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, DataStreamerReceiverDescriptor<P, A, R> receiver, Function<E, Map.Entry<K, V>> keyFunc, Function<E, P> payloadFunc, @Nullable A receiverArg, @Nullable Flow.Subscriber<R> resultSubscriber, @Nullable DataStreamerOptions options) {
        this.checkState();
        return this.base.streamData(publisher, receiver, keyFunc, payloadFunc, receiverArg, resultSubscriber, options);
    }

    @Override
    public Cursor<Map.Entry<K, V>> query(@Nullable Transaction tx, @Nullable Criteria criteria) {
        this.checkState();
        return this.base.query(tx, criteria);
    }

    @Override
    public Cursor<Map.Entry<K, V>> query(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName) {
        this.checkState();
        return this.base.query(tx, criteria, indexName);
    }

    @Override
    public Cursor<Map.Entry<K, V>> query(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, @Nullable CriteriaQueryOptions opts) {
        this.checkState();
        return this.base.query(tx, criteria, indexName, opts);
    }

    @Override
    public CompletableFuture<AsyncCursor<Map.Entry<K, V>>> queryAsync(@Nullable Transaction tx, @Nullable Criteria criteria) {
        this.checkState();
        return this.base.queryAsync(tx, criteria);
    }

    @Override
    public CompletableFuture<AsyncCursor<Map.Entry<K, V>>> queryAsync(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName) {
        this.checkState();
        return this.base.queryAsync(tx, criteria, indexName);
    }

    @Override
    public CompletableFuture<AsyncCursor<Map.Entry<K, V>>> queryAsync(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, @Nullable CriteriaQueryOptions opts) {
        this.checkState();
        return this.base.queryAsync(tx, criteria, indexName, opts);
    }

    protected void checkState() {
        if (this.closed) {
            throw new IllegalStateException("View already closed.");
        }
    }

    @Override
    public <T> T unwrap(Class<T> classToUnwrap) {
        return Wrappers.unwrap(this.base, classToUnwrap);
    }
}

