/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.jdbc.proto.event;

import java.util.Objects;
import org.apache.ignite.internal.jdbc.JdbcConverterUtils;
import org.gridgain.shaded.org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.gridgain.shaded.org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.gridgain.shaded.org.apache.ignite.internal.jdbc.proto.event.ClientMessageUtils;
import org.gridgain.shaded.org.apache.ignite.internal.jdbc.proto.event.Response;
import org.gridgain.shaded.org.apache.ignite.internal.lang.IgniteInternalException;
import org.gridgain.shaded.org.apache.ignite.internal.tostring.S;
import org.gridgain.shaded.org.apache.ignite.lang.ErrorGroups;
import org.gridgain.shaded.org.apache.ignite.sql.ColumnType;

public class JdbcColumnMeta
extends Response {
    private boolean nullable;
    private String label;
    private String schemaName;
    private String tblName;
    private String colName;
    private ColumnType columnType;
    private int precision;
    private int scale;

    public JdbcColumnMeta() {
    }

    public JdbcColumnMeta(String label, ColumnType columnType) {
        this(label, null, null, null, columnType, -1, -1, true);
    }

    public JdbcColumnMeta(String label, String schemaName, String tblName, String colName, ColumnType columnType, int precision, int scale, boolean nullable) {
        this.label = label;
        this.schemaName = schemaName;
        this.tblName = tblName;
        this.colName = colName;
        this.nullable = nullable;
        this.columnType = columnType;
        this.precision = precision;
        this.scale = scale;
    }

    public String columnLabel() {
        return this.label;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public String tableName() {
        return this.tblName;
    }

    public String columnName() {
        return this.colName != null ? this.colName : this.label;
    }

    public ColumnType columnType() {
        return this.columnType;
    }

    public int dataType() {
        return JdbcColumnMeta.typeId(this.columnType);
    }

    public String dataTypeName() {
        return JdbcColumnMeta.typeName(this.columnType);
    }

    public String defaultValue() {
        return null;
    }

    public int precision() {
        return this.precision;
    }

    public int scale() {
        return this.scale;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public String dataTypeClass() {
        return JdbcConverterUtils.columnTypeToJdbcClass(this.columnType).getName();
    }

    @Override
    public void writeBinary(ClientMessagePacker packer) {
        super.writeBinary(packer);
        if (!this.success()) {
            return;
        }
        packer.packString(this.label);
        ClientMessageUtils.writeStringNullable(packer, this.schemaName);
        ClientMessageUtils.writeStringNullable(packer, this.tblName);
        ClientMessageUtils.writeStringNullable(packer, this.colName);
        packer.packInt(this.columnType.id());
        packer.packBoolean(this.nullable);
        packer.packInt(this.precision);
        packer.packInt(this.scale);
    }

    @Override
    public void readBinary(ClientMessageUnpacker unpacker) {
        super.readBinary(unpacker);
        if (!this.success()) {
            return;
        }
        this.label = unpacker.unpackString();
        this.schemaName = ClientMessageUtils.readStringNullable(unpacker);
        this.tblName = ClientMessageUtils.readStringNullable(unpacker);
        this.colName = ClientMessageUtils.readStringNullable(unpacker);
        this.columnType = ColumnType.getById(unpacker.unpackInt());
        this.nullable = unpacker.unpackBoolean();
        this.precision = unpacker.unpackInt();
        this.scale = unpacker.unpackInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcColumnMeta meta = (JdbcColumnMeta)o;
        return this.nullable == meta.nullable && this.columnType == meta.columnType && this.precision == meta.precision && this.scale == meta.scale && Objects.equals(this.schemaName, meta.schemaName) && Objects.equals(this.tblName, meta.tblName) && Objects.equals(this.colName, meta.colName);
    }

    public int hashCode() {
        int result = this.nullable ? 1 : 0;
        result = 31 * result + (this.schemaName != null ? this.schemaName.hashCode() : 0);
        result = 31 * result + (this.tblName != null ? this.tblName.hashCode() : 0);
        result = 31 * result + (this.colName != null ? this.colName.hashCode() : 0);
        result = 31 * result + this.columnType.id();
        result = 31 * result + this.precision;
        result = 31 * result + this.scale;
        return result;
    }

    @Override
    public String toString() {
        return S.toString(JdbcColumnMeta.class, this);
    }

    private static String typeName(ColumnType columnType) {
        switch (columnType) {
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case INT8: {
                return "TINYINT";
            }
            case INT16: {
                return "SMALLINT";
            }
            case INT32: {
                return "INTEGER";
            }
            case INT64: {
                return "BIGINT";
            }
            case FLOAT: {
                return "REAL";
            }
            case DOUBLE: {
                return "DOUBLE";
            }
            case STRING: {
                return "VARCHAR";
            }
            case BYTE_ARRAY: {
                return "VARBINARY";
            }
            case TIME: {
                return "TIME";
            }
            case DATETIME: {
                return "TIMESTAMP";
            }
            case TIMESTAMP: {
                return "TIMESTAMP WITH LOCAL TIME ZONE";
            }
            case DATE: {
                return "DATE";
            }
            case DECIMAL: {
                return "DECIMAL";
            }
            case NULL: {
                return "NULL";
            }
            case UUID: {
                return "UUID";
            }
            case PERIOD: 
            case DURATION: {
                return "OTHER";
            }
        }
        throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Unknown column type: " + columnType);
    }

    private static int typeId(ColumnType columnType) {
        switch (columnType) {
            case BOOLEAN: {
                return 16;
            }
            case INT8: {
                return -6;
            }
            case INT16: {
                return 5;
            }
            case INT32: {
                return 4;
            }
            case INT64: {
                return -5;
            }
            case FLOAT: {
                return 7;
            }
            case DOUBLE: {
                return 8;
            }
            case STRING: {
                return 12;
            }
            case BYTE_ARRAY: {
                return -3;
            }
            case TIME: {
                return 92;
            }
            case DATETIME: {
                return 93;
            }
            case DATE: {
                return 91;
            }
            case DECIMAL: {
                return 3;
            }
            case NULL: {
                return 0;
            }
            case TIMESTAMP: 
            case UUID: 
            case PERIOD: 
            case DURATION: {
                return 1111;
            }
        }
        throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Unknown column type: " + columnType);
    }
}

