/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.jdbc.proto.event;

import java.util.ArrayList;
import java.util.List;
import org.gridgain.shaded.org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.gridgain.shaded.org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.gridgain.shaded.org.apache.ignite.internal.jdbc.proto.ClientMessage;
import org.gridgain.shaded.org.apache.ignite.internal.jdbc.proto.event.ClientMessageUtils;
import org.gridgain.shaded.org.apache.ignite.internal.jdbc.proto.event.JdbcObservableTimeAwareRequest;
import org.gridgain.shaded.org.apache.ignite.internal.tostring.S;
import org.gridgain.shaded.org.apache.ignite.internal.util.CollectionUtils;

public class JdbcBatchExecuteRequest
extends JdbcObservableTimeAwareRequest
implements ClientMessage {
    private String schemaName;
    private List<String> queries;
    private boolean autoCommit;
    private long queryTimeoutMillis;
    private long correlationToken;

    public JdbcBatchExecuteRequest() {
    }

    public JdbcBatchExecuteRequest(String schemaName, List<String> queries, boolean autoCommit, long queryTimeoutMillis, long correlationToken) {
        assert (!CollectionUtils.nullOrEmpty(queries));
        this.schemaName = schemaName;
        this.queries = queries;
        this.autoCommit = autoCommit;
        this.queryTimeoutMillis = queryTimeoutMillis;
        this.correlationToken = correlationToken;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public List<String> queries() {
        return this.queries;
    }

    public boolean autoCommit() {
        return this.autoCommit;
    }

    public long queryTimeoutMillis() {
        return this.queryTimeoutMillis;
    }

    public long correlationToken() {
        return this.correlationToken;
    }

    @Override
    public void writeBinary(ClientMessagePacker packer) {
        packer.packBoolean(this.autoCommit);
        ClientMessageUtils.writeStringNullable(packer, this.schemaName);
        packer.packInt(this.queries.size());
        for (String q : this.queries) {
            packer.packString(q);
        }
        packer.packLong(this.queryTimeoutMillis);
        packer.packLong(this.correlationToken);
    }

    @Override
    public void readBinary(ClientMessageUnpacker unpacker) {
        this.autoCommit = unpacker.unpackBoolean();
        this.schemaName = ClientMessageUtils.readStringNullable(unpacker);
        int n = unpacker.unpackInt();
        this.queries = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            this.queries.add(unpacker.unpackString());
        }
        this.queryTimeoutMillis = unpacker.unpackLong();
        this.correlationToken = unpacker.unpackLong();
    }

    public String toString() {
        return S.toString(JdbcBatchExecuteRequest.class, this);
    }
}

