/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.client.table;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.BitSet;
import java.util.Objects;
import java.util.UUID;
import org.gridgain.shaded.org.apache.ignite.internal.binarytuple.BinaryTupleContainer;
import org.gridgain.shaded.org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.gridgain.shaded.org.apache.ignite.internal.tostring.S;
import org.gridgain.shaded.org.apache.ignite.lang.util.IgniteNameUtils;
import org.gridgain.shaded.org.apache.ignite.sql.ColumnType;
import org.gridgain.shaded.org.apache.ignite.table.Tuple;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

public abstract class MutableTupleBinaryTupleAdapter
implements Tuple,
BinaryTupleContainer {
    private BinaryTupleReader binaryTuple;
    private final int columnCount;
    @Nullable
    private Tuple tuple;
    @Nullable
    private final BitSet noValueSet;

    public MutableTupleBinaryTupleAdapter(BinaryTupleReader binaryTuple, int columnCount, @Nullable BitSet noValueSet) {
        assert (binaryTuple != null) : "binaryTuple != null";
        this.binaryTuple = binaryTuple;
        this.columnCount = columnCount;
        this.noValueSet = noValueSet;
    }

    @Override
    public int columnCount() {
        if (this.tuple != null) {
            return this.tuple.columnCount();
        }
        int cnt = this.columnCount;
        if (this.noValueSet != null) {
            cnt -= this.noValueSet.cardinality();
        }
        return cnt;
    }

    @Override
    public String columnName(int columnIndex) {
        return this.tuple != null ? this.tuple.columnName(columnIndex) : this.schemaColumnName0(columnIndex);
    }

    @Override
    public int columnIndex(String columnName) {
        if (this.tuple != null) {
            return this.tuple.columnIndex(columnName);
        }
        int binaryTupleIndex = this.binaryTupleIndex(columnName, null);
        return binaryTupleIndex < 0 ? -1 : this.publicIndex(binaryTupleIndex);
    }

    @Override
    public <T> T valueOrDefault(String columnName, T defaultValue) {
        if (this.tuple != null) {
            return this.tuple.valueOrDefault(columnName, defaultValue);
        }
        int binaryTupleIndex = this.binaryTupleIndex(columnName, null);
        return (T)(binaryTupleIndex < 0 || this.publicIndex(binaryTupleIndex) < 0 || this.noValueSet != null && this.noValueSet.get(binaryTupleIndex) ? defaultValue : this.object(binaryTupleIndex));
    }

    @Override
    public <T> T value(String columnName) {
        if (this.tuple != null) {
            return this.tuple.value(columnName);
        }
        int binaryTupleIndex = this.binaryTupleIndex(columnName, null);
        if (binaryTupleIndex < 0 || this.publicIndex(binaryTupleIndex) < 0) {
            throw new IllegalArgumentException("Column doesn't exist [name=" + columnName + "]");
        }
        return (T)this.object(binaryTupleIndex);
    }

    @Override
    public <T> T value(int columnIndex) {
        if (this.tuple != null) {
            return this.tuple.value(columnIndex);
        }
        Objects.checkIndex(columnIndex, this.columnCount);
        int binaryTupleIndex = this.binaryTupleIndex(columnIndex);
        return (T)this.object(binaryTupleIndex);
    }

    @Override
    public boolean booleanValue(String columnName) {
        return this.tuple != null ? this.tuple.booleanValue(columnName) : this.binaryTuple.booleanValue(this.validateSchemaColumnType(columnName, ColumnType.BOOLEAN));
    }

    @Override
    public boolean booleanValue(int columnIndex) {
        return this.tuple != null ? this.tuple.booleanValue(columnIndex) : this.binaryTuple.booleanValue(this.validateSchemaColumnType(columnIndex, ColumnType.BOOLEAN));
    }

    @Override
    public byte byteValue(String columnName) {
        return this.tuple != null ? this.tuple.byteValue(columnName) : this.binaryTuple.byteValue(this.validateSchemaColumnType(columnName, ColumnType.INT8));
    }

    @Override
    public byte byteValue(int columnIndex) {
        return this.tuple != null ? this.tuple.byteValue(columnIndex) : this.binaryTuple.byteValue(this.validateSchemaColumnType(columnIndex, ColumnType.INT8));
    }

    @Override
    public short shortValue(String columnName) {
        return this.tuple != null ? this.tuple.shortValue(columnName) : this.binaryTuple.shortValue(this.validateSchemaColumnType(columnName, ColumnType.INT16));
    }

    @Override
    public short shortValue(int columnIndex) {
        return this.tuple != null ? this.tuple.shortValue(columnIndex) : this.binaryTuple.shortValue(this.validateSchemaColumnType(columnIndex, ColumnType.INT16));
    }

    @Override
    public int intValue(String columnName) {
        return this.tuple != null ? this.tuple.intValue(columnName) : this.binaryTuple.intValue(this.validateSchemaColumnType(columnName, ColumnType.INT32));
    }

    @Override
    public int intValue(int columnIndex) {
        return this.tuple != null ? this.tuple.intValue(columnIndex) : this.binaryTuple.intValue(this.validateSchemaColumnType(columnIndex, ColumnType.INT32));
    }

    @Override
    public long longValue(String columnName) {
        return this.tuple != null ? this.tuple.longValue(columnName) : this.binaryTuple.longValue(this.validateSchemaColumnType(columnName, ColumnType.INT64));
    }

    @Override
    public long longValue(int columnIndex) {
        return this.tuple != null ? this.tuple.longValue(columnIndex) : this.binaryTuple.longValue(this.validateSchemaColumnType(columnIndex, ColumnType.INT64));
    }

    @Override
    public float floatValue(String columnName) {
        return this.tuple != null ? this.tuple.floatValue(columnName) : this.binaryTuple.floatValue(this.validateSchemaColumnType(columnName, ColumnType.FLOAT));
    }

    @Override
    public float floatValue(int columnIndex) {
        return this.tuple != null ? this.tuple.floatValue(columnIndex) : this.binaryTuple.floatValue(this.validateSchemaColumnType(columnIndex, ColumnType.FLOAT));
    }

    @Override
    public double doubleValue(String columnName) {
        return this.tuple != null ? this.tuple.doubleValue(columnName) : this.binaryTuple.doubleValue(this.validateSchemaColumnType(columnName, ColumnType.DOUBLE));
    }

    @Override
    public double doubleValue(int columnIndex) {
        return this.tuple != null ? this.tuple.doubleValue(columnIndex) : this.binaryTuple.doubleValue(this.validateSchemaColumnType(columnIndex, ColumnType.DOUBLE));
    }

    @Override
    public BigDecimal decimalValue(String columnName) {
        return this.tuple != null ? this.tuple.decimalValue(columnName) : this.binaryTuple.decimalValue(this.validateSchemaColumnType(columnName, ColumnType.DECIMAL), Integer.MIN_VALUE);
    }

    @Override
    public BigDecimal decimalValue(int columnIndex) {
        return this.tuple != null ? this.tuple.decimalValue(columnIndex) : this.binaryTuple.decimalValue(this.validateSchemaColumnType(columnIndex, ColumnType.DECIMAL), Integer.MIN_VALUE);
    }

    @Override
    public String stringValue(String columnName) {
        return this.tuple != null ? this.tuple.stringValue(columnName) : this.binaryTuple.stringValue(this.validateSchemaColumnType(columnName, ColumnType.STRING));
    }

    @Override
    public String stringValue(int columnIndex) {
        return this.tuple != null ? this.tuple.stringValue(columnIndex) : this.binaryTuple.stringValue(this.validateSchemaColumnType(columnIndex, ColumnType.STRING));
    }

    @Override
    public byte[] bytesValue(String columnName) {
        return this.tuple != null ? this.tuple.bytesValue(columnName) : this.binaryTuple.bytesValue(this.validateSchemaColumnType(columnName, ColumnType.BYTE_ARRAY));
    }

    @Override
    public byte[] bytesValue(int columnIndex) {
        return this.tuple != null ? this.tuple.bytesValue(columnIndex) : this.binaryTuple.bytesValue(this.validateSchemaColumnType(columnIndex, ColumnType.BYTE_ARRAY));
    }

    @Override
    public UUID uuidValue(String columnName) {
        return this.tuple != null ? this.tuple.uuidValue(columnName) : this.binaryTuple.uuidValue(this.validateSchemaColumnType(columnName, ColumnType.UUID));
    }

    @Override
    public UUID uuidValue(int columnIndex) {
        return this.tuple != null ? this.tuple.uuidValue(columnIndex) : this.binaryTuple.uuidValue(this.validateSchemaColumnType(columnIndex, ColumnType.UUID));
    }

    @Override
    public LocalDate dateValue(String columnName) {
        return this.tuple != null ? this.tuple.dateValue(columnName) : this.binaryTuple.dateValue(this.validateSchemaColumnType(columnName, ColumnType.DATE));
    }

    @Override
    public LocalDate dateValue(int columnIndex) {
        return this.tuple != null ? this.tuple.dateValue(columnIndex) : this.binaryTuple.dateValue(this.validateSchemaColumnType(columnIndex, ColumnType.DATE));
    }

    @Override
    public LocalTime timeValue(String columnName) {
        return this.tuple != null ? this.tuple.timeValue(columnName) : this.binaryTuple.timeValue(this.validateSchemaColumnType(columnName, ColumnType.TIME));
    }

    @Override
    public LocalTime timeValue(int columnIndex) {
        return this.tuple != null ? this.tuple.timeValue(columnIndex) : this.binaryTuple.timeValue(this.validateSchemaColumnType(columnIndex, ColumnType.TIME));
    }

    @Override
    public LocalDateTime datetimeValue(String columnName) {
        return this.tuple != null ? this.tuple.datetimeValue(columnName) : this.binaryTuple.dateTimeValue(this.validateSchemaColumnType(columnName, ColumnType.DATETIME));
    }

    @Override
    public LocalDateTime datetimeValue(int columnIndex) {
        return this.tuple != null ? this.tuple.datetimeValue(columnIndex) : this.binaryTuple.dateTimeValue(this.validateSchemaColumnType(columnIndex, ColumnType.DATETIME));
    }

    @Override
    public Instant timestampValue(String columnName) {
        return this.tuple != null ? this.tuple.timestampValue(columnName) : this.binaryTuple.timestampValue(this.validateSchemaColumnType(columnName, ColumnType.TIMESTAMP));
    }

    @Override
    public Instant timestampValue(int columnIndex) {
        return this.tuple != null ? this.tuple.timestampValue(columnIndex) : this.binaryTuple.timestampValue(this.validateSchemaColumnType(columnIndex, ColumnType.TIMESTAMP));
    }

    @Override
    public Tuple set(String columnName, @Nullable Object value) {
        if (this.tuple == null) {
            this.tuple = Tuple.copy(this);
            this.binaryTuple = null;
        }
        this.tuple.set(columnName, value);
        return this;
    }

    @Override
    public int hashCode() {
        return Tuple.hashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Tuple) {
            return Tuple.equals(this, (Tuple)obj);
        }
        return false;
    }

    @Override
    @Nullable
    public BinaryTupleReader binaryTuple() {
        if (this.tuple != null) {
            return null;
        }
        if (this.noValueSet != null && !this.noValueSet.isEmpty()) {
            return null;
        }
        return this.binaryTuple;
    }

    protected abstract String schemaColumnName(int var1);

    protected abstract ColumnType schemaColumnType(int var1);

    protected abstract int schemaDecimalScale(int var1);

    protected int publicIndex(int binaryTupleIndex) {
        return binaryTupleIndex;
    }

    protected abstract int binaryTupleIndex(String var1);

    protected int binaryTupleIndex(int publicIndex) {
        return publicIndex;
    }

    private int binaryTupleIndex(String columnName, @Nullable ColumnType type) {
        ColumnType actualType;
        int binaryTupleIndex = this.binaryTupleIndex(columnName);
        if (binaryTupleIndex < 0) {
            return binaryTupleIndex;
        }
        if (type != null && type != (actualType = this.schemaColumnType(binaryTupleIndex))) {
            throw new ClassCastException("Column with name '" + columnName + "' has type " + actualType + " but " + type + " was requested");
        }
        return binaryTupleIndex;
    }

    private int validateSchemaColumnType(String columnName, ColumnType type) {
        int index = this.binaryTupleIndex(columnName, type);
        if (index < 0) {
            throw new IllegalArgumentException("Column doesn't exist [name=" + columnName + "]");
        }
        return index;
    }

    private int validateSchemaColumnType(int publicIndex, ColumnType type) {
        Objects.checkIndex(publicIndex, this.columnCount);
        int binaryTupleIndex = this.binaryTupleIndex(publicIndex);
        ColumnType actualType = this.schemaColumnType(binaryTupleIndex);
        if (type != actualType) {
            throw new ClassCastException("Column with index " + publicIndex + " has type " + actualType + " but " + type + " was requested");
        }
        return binaryTupleIndex;
    }

    private String schemaColumnName0(int publicIndex) {
        Objects.checkIndex(publicIndex, this.columnCount);
        return IgniteNameUtils.quoteIfNeeded(this.schemaColumnName(this.binaryTupleIndex(publicIndex)));
    }

    @Nullable
    private Object object(int binaryTupleIndex) {
        if (this.binaryTuple.hasNullValue(binaryTupleIndex)) {
            return null;
        }
        ColumnType type = this.schemaColumnType(binaryTupleIndex);
        switch (type) {
            case BOOLEAN: {
                return this.binaryTuple.booleanValue(binaryTupleIndex);
            }
            case INT8: {
                return this.binaryTuple.byteValue(binaryTupleIndex);
            }
            case INT16: {
                return this.binaryTuple.shortValue(binaryTupleIndex);
            }
            case INT32: {
                return this.binaryTuple.intValue(binaryTupleIndex);
            }
            case INT64: {
                return this.binaryTuple.longValue(binaryTupleIndex);
            }
            case FLOAT: {
                return Float.valueOf(this.binaryTuple.floatValue(binaryTupleIndex));
            }
            case DOUBLE: {
                return this.binaryTuple.doubleValue(binaryTupleIndex);
            }
            case DECIMAL: {
                return this.binaryTuple.decimalValue(binaryTupleIndex, this.schemaDecimalScale(binaryTupleIndex));
            }
            case DATE: {
                return this.binaryTuple.dateValue(binaryTupleIndex);
            }
            case TIME: {
                return this.binaryTuple.timeValue(binaryTupleIndex);
            }
            case DATETIME: {
                return this.binaryTuple.dateTimeValue(binaryTupleIndex);
            }
            case TIMESTAMP: {
                return this.binaryTuple.timestampValue(binaryTupleIndex);
            }
            case UUID: {
                return this.binaryTuple.uuidValue(binaryTupleIndex);
            }
            case STRING: {
                return this.binaryTuple.stringValue(binaryTupleIndex);
            }
            case BYTE_ARRAY: {
                return this.binaryTuple.bytesValue(binaryTupleIndex);
            }
            case PERIOD: {
                return this.binaryTuple.periodValue(binaryTupleIndex);
            }
            case DURATION: {
                return this.binaryTuple.durationValue(binaryTupleIndex);
            }
        }
        throw new IllegalStateException("Unsupported type: " + type);
    }

    public String toString() {
        return S.tupleToString(this);
    }
}

