/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.compute;

import java.util.List;
import java.util.Objects;
import org.gridgain.shaded.org.apache.ignite.compute.ComputeJob;
import org.gridgain.shaded.org.apache.ignite.compute.JobExecutionOptions;
import org.gridgain.shaded.org.apache.ignite.deployment.DeploymentUnit;
import org.gridgain.shaded.org.apache.ignite.marshalling.Marshaller;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

public class JobDescriptor<T, R> {
    private final String jobClassName;
    private final List<DeploymentUnit> units;
    private final JobExecutionOptions options;
    @Nullable
    private final Marshaller<T, byte[]> argumentMarshaller;
    @Nullable
    private final Marshaller<R, byte[]> resultMarshaller;
    private final Class<R> resultClass;

    private JobDescriptor(String jobClassName, List<DeploymentUnit> units, JobExecutionOptions options, @Nullable Marshaller<T, byte[]> argumentMarshaller, @Nullable Marshaller<R, byte[]> resultMarshaller, @Nullable Class<R> resultClass) {
        this.jobClassName = jobClassName;
        this.units = units;
        this.options = options;
        this.argumentMarshaller = argumentMarshaller;
        this.resultMarshaller = resultMarshaller;
        this.resultClass = resultClass;
    }

    public String jobClassName() {
        return this.jobClassName;
    }

    public List<DeploymentUnit> units() {
        return this.units;
    }

    public JobExecutionOptions options() {
        return this.options;
    }

    public static <T, R> Builder<T, R> builder(String jobClassName) {
        Objects.requireNonNull(jobClassName);
        return new Builder(jobClassName);
    }

    public static <T, R> Builder<T, R> builder(Class<? extends ComputeJob<T, R>> jobClass) {
        Objects.requireNonNull(jobClass);
        return new Builder(jobClass.getName());
    }

    @Nullable
    public Marshaller<T, byte[]> argumentMarshaller() {
        return this.argumentMarshaller;
    }

    @Nullable
    public Marshaller<R, byte[]> resultMarshaller() {
        return this.resultMarshaller;
    }

    @Nullable
    public Class<R> resultClass() {
        return this.resultClass;
    }

    public static class Builder<T, R> {
        private final String jobClassName;
        private List<DeploymentUnit> units;
        private JobExecutionOptions options;
        private Marshaller<T, byte[]> argumentMarshaller;
        private Marshaller<R, byte[]> resultMarshaller;
        private Class<R> resultClass;

        private Builder(String jobClassName) {
            Objects.requireNonNull(jobClassName);
            this.jobClassName = jobClassName;
        }

        public Builder<T, R> units(List<DeploymentUnit> units) {
            this.units = units;
            return this;
        }

        public Builder<T, R> units(DeploymentUnit ... units) {
            this.units = List.of(units);
            return this;
        }

        public Builder<T, R> options(JobExecutionOptions options) {
            this.options = options;
            return this;
        }

        public Builder<T, R> argumentMarshaller(Marshaller<T, byte[]> marshaller) {
            this.argumentMarshaller = marshaller;
            return this;
        }

        public Builder<T, R> resultMarshaller(Marshaller<R, byte[]> marshaller) {
            this.resultMarshaller = marshaller;
            return this;
        }

        public Builder<T, R> resultClass(Class<R> resultClass) {
            this.resultClass = resultClass;
            return this;
        }

        public JobDescriptor<T, R> build() {
            return new JobDescriptor<T, R>(this.jobClassName, this.units == null ? List.of() : this.units, this.options == null ? JobExecutionOptions.DEFAULT : this.options, this.argumentMarshaller, this.resultMarshaller, this.resultClass);
        }
    }
}

