/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rbac.privileges.exception;

import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.lang.GridgainErrorGroups;
import org.gridgain.shaded.org.apache.ignite.lang.IgniteException;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

public class AuthorizationException
extends IgniteException {
    public AuthorizationException(Set<Privilege> wantedPrivileges, Set<String> roles) {
        super(GridgainErrorGroups.Rbac.AUTHORIZATION_FAILED_ERR, (roles.size() == 1 ? "Role " + (String)roles.stream().findFirst().get() + " does" : "Roles " + roles + " do") + " not have privilege(s) " + AuthorizationException.format(wantedPrivileges));
    }

    private static String format(Set<Privilege> privileges) {
        return privileges.stream().map(Privilege::format).sorted().collect(Collectors.joining(", ", "[", "]"));
    }

    public AuthorizationException(UUID traceId, int code, String message, @Nullable Throwable cause) {
        super(traceId, code, message, cause);
    }
}

