/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rbac.configuration;

import java.util.Objects;
import org.gridgain.internal.rbac.configuration.PrivilegeNameGenerator;
import org.gridgain.internal.rbac.configuration.PrivilegeView;
import org.gridgain.internal.rbac.configuration.PrivilegesValidator;
import org.gridgain.internal.rbac.privileges.Action;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.rbac.privileges.exception.IllegalPrivilegeException;
import org.gridgain.shaded.org.apache.ignite.configuration.NamedListView;
import org.gridgain.shaded.org.apache.ignite.configuration.validation.ValidationContext;
import org.gridgain.shaded.org.apache.ignite.configuration.validation.ValidationIssue;
import org.gridgain.shaded.org.apache.ignite.configuration.validation.Validator;
import org.gridgain.shaded.org.apache.ignite.internal.util.StringUtils;

public class PrivilegesValidatorImpl
implements Validator<PrivilegesValidator, NamedListView<? extends PrivilegeView>> {
    public static final PrivilegesValidatorImpl INSTANCE = new PrivilegesValidatorImpl();

    @Override
    public void validate(PrivilegesValidator annotation, ValidationContext<NamedListView<? extends PrivilegeView>> ctx) {
        NamedListView<? extends PrivilegeView> newValue = ctx.getNewValue();
        for (String key : newValue.namedListKeys()) {
            PrivilegeView privilegeView = newValue.get(key);
            if (!PrivilegesValidatorImpl.validateAction(ctx, privilegeView)) {
                return;
            }
            PrivilegesValidatorImpl.validateSelector(ctx, privilegeView);
            PrivilegesValidatorImpl.validatePrivilegeName(ctx, key, privilegeView);
        }
    }

    private static boolean validateAction(ValidationContext<NamedListView<? extends PrivilegeView>> ctx, PrivilegeView privilegeView) {
        String newAction = privilegeView.action();
        try {
            Action.valueOf(newAction);
        }
        catch (IllegalArgumentException e) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), "Invalid privilege action: " + newAction));
            return false;
        }
        return true;
    }

    private static void validateSelector(ValidationContext<NamedListView<? extends PrivilegeView>> ctx, PrivilegeView newValue) {
        try {
            Privilege.Builder builder = Privilege.builder().action(Action.valueOf(newValue.action()));
            if (!StringUtils.nullOrBlank(newValue.on())) {
                builder.selector(newValue.on());
            }
            builder.build();
        }
        catch (IllegalPrivilegeException e) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), e.getMessage()));
        }
    }

    private static void validatePrivilegeName(ValidationContext<NamedListView<? extends PrivilegeView>> ctx, String key, PrivilegeView newValue) {
        String correctName = PrivilegeNameGenerator.privilegeName(newValue.action(), newValue.on());
        if (!Objects.equals(correctName, key)) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), "Invalid privilege entry key " + key + ". Name should be " + correctName));
        }
    }
}

