/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.apache.ignite.internal.jdbc.JdbcConnection;
import org.apache.ignite.internal.jdbc.JdbcStatement;
import org.gridgain.shaded.org.apache.ignite.internal.jdbc.proto.IgniteQueryErrorCode;
import org.gridgain.shaded.org.apache.ignite.internal.jdbc.proto.JdbcStatementType;
import org.gridgain.shaded.org.apache.ignite.internal.jdbc.proto.event.JdbcBatchExecuteResult;
import org.gridgain.shaded.org.apache.ignite.internal.jdbc.proto.event.JdbcBatchPreparedStmntRequest;
import org.gridgain.shaded.org.apache.ignite.internal.util.ArrayUtils;
import org.gridgain.shaded.org.apache.ignite.internal.util.CollectionUtils;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

public class JdbcPreparedStatement
extends JdbcStatement
implements PreparedStatement {
    private static final Set<JDBCType> SUPPORTED_TYPES = EnumSet.of(JDBCType.BOOLEAN, new JDBCType[]{JDBCType.TINYINT, JDBCType.SMALLINT, JDBCType.INTEGER, JDBCType.BIGINT, JDBCType.FLOAT, JDBCType.REAL, JDBCType.DOUBLE, JDBCType.DECIMAL, JDBCType.DATE, JDBCType.TIME, JDBCType.TIMESTAMP, JDBCType.CHAR, JDBCType.VARCHAR, JDBCType.BINARY, JDBCType.VARBINARY, JDBCType.NULL, JDBCType.OTHER});
    private final String sql;
    private List<Object> currentArgs;
    private List<Object[]> batchedArgs;

    JdbcPreparedStatement(JdbcConnection conn, String sql, int resHoldability, String schema) {
        super(conn, resHoldability, schema);
        this.sql = sql;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.executeWithArguments(JdbcStatementType.SELECT_STATEMENT_TYPE, false);
        ResultSet rs = this.getResultSet();
        if (rs == null) {
            throw new SQLException("The query isn't SELECT query: " + this.sql, "42000");
        }
        return rs;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw new SQLException("The method 'executeQuery(String)' is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.ensureNotClosed();
        this.closeResults();
        if (CollectionUtils.nullOrEmpty(this.batchedArgs)) {
            return ArrayUtils.INT_EMPTY_ARRAY;
        }
        long correlationToken = this.nextToken();
        JdbcBatchPreparedStmntRequest req = new JdbcBatchPreparedStmntRequest(this.conn.getSchema(), this.sql, this.batchedArgs, this.conn.getAutoCommit(), this.queryTimeoutMillis, correlationToken);
        try {
            JdbcBatchExecuteResult res = this.conn.handler().batchPrepStatementAsync(this.conn.connectionId(), req).get();
            if (!res.success()) {
                throw new BatchUpdateException(res.err(), IgniteQueryErrorCode.codeToSqlState(res.getErrorCode()), res.getErrorCode(), res.updateCounts());
            }
            int[] nArray = res.updateCounts();
            return nArray;
        }
        catch (InterruptedException e) {
            throw new SQLException("Thread was interrupted.", e);
        }
        catch (ExecutionException e) {
            throw new SQLException("Batch request failed.", e);
        }
        catch (CancellationException e) {
            throw new SQLException("Batch request canceled.", "57014");
        }
        finally {
            this.batchedArgs = null;
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.executeWithArguments(JdbcStatementType.UPDATE_STATEMENT_TYPE, false);
        int res = this.getUpdateCount();
        if (res == -1) {
            throw new SQLException("The query is not DML statement: " + this.sql, "42000");
        }
        return res;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new SQLException("The method 'executeUpdate(String)' is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("The method 'executeUpdate(String, int)' is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public int executeUpdate(String sql, String[] colNames) throws SQLException {
        throw new SQLException("The method 'executeUpdate(String, String[])' is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public int executeUpdate(String sql, int[] colNames) throws SQLException {
        throw new SQLException("The method 'executeUpdate(String, int[])' is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public boolean execute() throws SQLException {
        this.executeWithArguments(JdbcStatementType.ANY_STATEMENT_TYPE, true);
        return this.isQuery();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw new SQLException("The method 'execute(String)' is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("The method 'executeUpdate(String, int)' is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public boolean execute(String sql, int[] colNames) throws SQLException {
        throw new SQLException("The method 'execute(String, int[])' is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public boolean execute(String sql, String[] colNames) throws SQLException {
        throw new SQLException("The method 'execute(String, String[]) is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public void addBatch() throws SQLException {
        this.ensureNotClosed();
        if (this.batchedArgs == null) {
            this.batchedArgs = new ArrayList<Object[]>();
        }
        this.batchedArgs.add(this.currentArgs.stream().map(this::convertJdbcTypeToInternal).toArray());
        this.currentArgs = null;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLException("The method 'addBatch(String)' is called on PreparedStatement instance.", "0A000");
    }

    @Override
    public void clearBatch() throws SQLException {
        this.ensureNotClosed();
        this.batchedArgs = null;
    }

    @Override
    public void setNull(int paramIdx, int sqlType) throws SQLException {
        JdbcPreparedStatement.checkType(sqlType);
        this.setArgument(paramIdx, null);
    }

    @Override
    public void setNull(int paramIdx, int sqlType, String typeName) throws SQLException {
        JdbcPreparedStatement.checkType(sqlType);
        this.setArgument(paramIdx, null);
    }

    @Override
    public void setBoolean(int paramIdx, boolean x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setByte(int paramIdx, byte x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setShort(int paramIdx, short x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setInt(int paramIdx, int x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setLong(int paramIdx, long x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setFloat(int paramIdx, float x) throws SQLException {
        this.setArgument(paramIdx, Float.valueOf(x));
    }

    @Override
    public void setDouble(int paramIdx, double x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setBigDecimal(int paramIdx, BigDecimal x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setString(int paramIdx, String x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setBytes(int paramIdx, byte[] x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setDate(int paramIdx, Date x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setDate(int paramIdx, Date x, Calendar cal) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setTime(int paramIdx, Time x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setTime(int paramIdx, Time x, Calendar cal) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setTimestamp(int paramIdx, Timestamp x) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setTimestamp(int paramIdx, Timestamp x, Calendar cal) throws SQLException {
        this.setArgument(paramIdx, x);
    }

    @Override
    public void setAsciiStream(int paramIdx, InputStream x, int len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void setAsciiStream(int paramIdx, InputStream x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void setAsciiStream(int paramIdx, InputStream x, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void setUnicodeStream(int paramIdx, InputStream x, int len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void setBinaryStream(int paramIdx, InputStream x, int len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void setBinaryStream(int paramIdx, InputStream x, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void setBinaryStream(int paramIdx, InputStream x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void clearParameters() throws SQLException {
        this.ensureNotClosed();
        this.currentArgs = null;
    }

    @Override
    public void setObject(int paramIdx, Object x, int targetSqlType) throws SQLException {
        JdbcPreparedStatement.checkType(targetSqlType);
        throw new SQLFeatureNotSupportedException("Conversion to target sql type is not supported.");
    }

    @Override
    public void setObject(int paramIdx, Object x) throws SQLException {
        if (x == null) {
            this.setNull(paramIdx, 1111);
        } else if (x instanceof Boolean) {
            this.setBoolean(paramIdx, (Boolean)x);
        } else if (x instanceof Byte) {
            this.setByte(paramIdx, (Byte)x);
        } else if (x instanceof Short) {
            this.setShort(paramIdx, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(paramIdx, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(paramIdx, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(paramIdx, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(paramIdx, (Double)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(paramIdx, (BigDecimal)x);
        } else if (x instanceof String) {
            this.setString(paramIdx, (String)x);
        } else if (x instanceof byte[]) {
            this.setBytes(paramIdx, (byte[])x);
        } else if (x instanceof Date) {
            this.setDate(paramIdx, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(paramIdx, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(paramIdx, (Timestamp)x);
        } else if (x instanceof UUID) {
            this.setArgument(paramIdx, x);
        } else {
            throw new SQLFeatureNotSupportedException("Parameter is not supported: " + x + " <" + x.getClass().getTypeName() + ">");
        }
    }

    @Override
    public void setObject(int paramIdx, Object x, int targetSqlType, int scaleOrLen) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Conversion to target sql type is not supported.");
    }

    @Override
    public void setCharacterStream(int paramIdx, Reader x, int len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void setCharacterStream(int paramIdx, Reader x, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void setCharacterStream(int paramIdx, Reader x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public void setRef(int paramIdx, Ref x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setBlob(int paramIdx, Blob x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setBlob(int paramIdx, InputStream inputStream) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setBlob(int paramIdx, InputStream inputStream, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setClob(int paramIdx, Clob x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setClob(int paramIdx, Reader reader, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setClob(int paramIdx, Reader reader) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setArray(int paramIdx, Array x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Meta data for prepared statement is not supported.");
    }

    @Override
    public void setURL(int paramIdx, URL x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Parameter type is unsupported. [cls=" + URL.class + "]");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Parameter metadata are not supported.");
    }

    @Override
    public void setRowId(int paramIdx, RowId x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setNString(int paramIdx, String val) throws SQLException {
        this.ensureNotClosed();
        this.setString(paramIdx, val);
    }

    @Override
    public void setNCharacterStream(int paramIdx, Reader val, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setNCharacterStream(int paramIdx, Reader val) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setNClob(int paramIdx, NClob val) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setNClob(int paramIdx, Reader reader) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setNClob(int paramIdx, Reader reader, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setSQLXML(int paramIdx, SQLXML xmlObj) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(Objects.requireNonNull(iface))) {
            throw new SQLException("Prepared statement is not a wrapper for " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(JdbcPreparedStatement.class);
    }

    private void setArgument(int paramIdx, Object val) throws SQLException {
        this.ensureNotClosed();
        if (paramIdx < 1) {
            throw new SQLException("Parameter index is invalid: " + paramIdx);
        }
        if (this.currentArgs == null) {
            this.currentArgs = new ArrayList<Object>(paramIdx);
        }
        while (this.currentArgs.size() < paramIdx) {
            this.currentArgs.add(null);
        }
        this.currentArgs.set(paramIdx - 1, val);
    }

    @Nullable
    private Object convertJdbcTypeToInternal(@Nullable Object val) {
        if (val instanceof java.util.Date) {
            if (val instanceof Timestamp) {
                Timestamp timeStamp = (Timestamp)val;
                return timeStamp.toLocalDateTime();
            }
            if (val instanceof Date) {
                Date date = (Date)val;
                return date.toLocalDate();
            }
            if (val instanceof Time) {
                Time time = (Time)val;
                return time.toLocalTime();
            }
            return ((java.util.Date)val).toInstant();
        }
        return val;
    }

    List<Object> getArguments() {
        return this.currentArgs;
    }

    private void executeWithArguments(JdbcStatementType statementType, boolean multiStatement) throws SQLException {
        Object[] args = this.currentArgs == null ? ArrayUtils.OBJECT_EMPTY_ARRAY : this.currentArgs.stream().map(this::convertJdbcTypeToInternal).toArray();
        this.execute0(statementType, this.sql, multiStatement, args);
    }

    private static void checkType(int sqlType) throws SQLException {
        JDBCType jdbcType = JDBCType.valueOf(sqlType);
        if (!SUPPORTED_TYPES.contains(jdbcType)) {
            throw new SQLFeatureNotSupportedException("Type is not supported: " + sqlType);
        }
    }
}

