/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.table.mapper;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.gridgain.shaded.org.apache.ignite.catalog.annotations.Column;
import org.gridgain.shaded.org.apache.ignite.lang.util.IgniteNameUtils;
import org.gridgain.shaded.org.apache.ignite.table.mapper.Mapper;
import org.gridgain.shaded.org.apache.ignite.table.mapper.OneColumnMapperImpl;
import org.gridgain.shaded.org.apache.ignite.table.mapper.PojoMapperImpl;
import org.gridgain.shaded.org.apache.ignite.table.mapper.TypeConverter;

public final class MapperBuilder<T> {
    private final Class<T> targetType;
    private final Map<String, String> columnToFields;
    private final Map<String, TypeConverter<?, ?>> columnConverters = new HashMap();
    private final String mappedToColumn;
    private boolean automapFlag = false;
    private boolean isStale;

    MapperBuilder(Class<T> targetType) {
        this.targetType = MapperBuilder.ensureValidPojo(targetType);
        this.mappedToColumn = null;
        this.columnToFields = new HashMap<String, String>(targetType.getDeclaredFields().length);
    }

    MapperBuilder(Class<T> targetType, String mappedColumn) {
        this.targetType = Mapper.ensureNativelySupported(targetType);
        this.mappedToColumn = mappedColumn;
        this.columnToFields = null;
    }

    private static <O> Class<O> ensureValidPojo(Class<O> type) {
        if (Mapper.nativelySupported(type)) {
            throw new IllegalArgumentException("Unsupported class. Can't map fields of natively supported type: " + type.getName());
        }
        if (type.isAnonymousClass() || type.isLocalClass() || type.isSynthetic() || type.isMemberClass() && !Modifier.isStatic(type.getModifiers())) {
            throw new IllegalArgumentException("Unsupported class. Only top-level or nested static classes are supported: " + type.getName());
        }
        if (Modifier.isAbstract(type.getModifiers())) {
            throw new IllegalArgumentException("Unsupported class. Abstract classes are not supported: " + type.getName());
        }
        if (type.isEnum()) {
            throw new IllegalArgumentException("Unsupported class. Enum is not supported, please use a converter: " + type.getName());
        }
        if (type.isArray()) {
            throw new IllegalArgumentException("Unsupported class. Arrays are not supported: " + type.getName());
        }
        if (type.isAnnotation() || type.isInterface()) {
            throw new IllegalArgumentException("Unsupported class. Interfaces are not supported: " + type.getName());
        }
        try {
            type.getDeclaredConstructor(new Class[0]);
            return type;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class must have default constructor: " + type.getName());
        }
    }

    private void ensureNotStale() {
        if (this.isStale) {
            throw new IllegalStateException("Mapper builder can't be reused.");
        }
    }

    private String requireValidField(String fieldName) {
        try {
            if (fieldName == null || this.targetType.getDeclaredField(fieldName) == null) {
                throw new IllegalArgumentException("Mapping for a column already exists: " + fieldName);
            }
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(String.format("Field not found for class: field=%s, class=%s", fieldName, this.targetType.getName()));
        }
        return fieldName;
    }

    public MapperBuilder<T> map(String fieldName, String columnName, String ... fieldColumnPairs) {
        this.ensureNotStale();
        String colName0 = IgniteNameUtils.parseIdentifier(columnName);
        if (this.columnToFields == null) {
            throw new IllegalArgumentException("Natively supported types doesn't support field mapping.");
        }
        if (fieldColumnPairs.length % 2 != 0) {
            throw new IllegalArgumentException("fieldColumnPairs length should be even.");
        }
        if (this.columnToFields.put(Objects.requireNonNull(colName0), this.requireValidField(fieldName)) != null) {
            throw new IllegalArgumentException("Mapping for a column already exists: " + colName0);
        }
        for (int i = 0; i < fieldColumnPairs.length; i += 2) {
            if (this.columnToFields.put(IgniteNameUtils.parseIdentifier(Objects.requireNonNull(fieldColumnPairs[i + 1])), this.requireValidField(fieldColumnPairs[i])) == null) continue;
            throw new IllegalArgumentException("Mapping for a column already exists: " + colName0);
        }
        return this;
    }

    public <ObjectT, ColumnT> MapperBuilder<T> map(String fieldName, String columnName, TypeConverter<ObjectT, ColumnT> converter) {
        this.map(fieldName, columnName, new String[0]);
        this.convert(columnName, converter);
        return this;
    }

    public <ObjectT, ColumnT> MapperBuilder<T> convert(String columnName, TypeConverter<ObjectT, ColumnT> converter) {
        this.ensureNotStale();
        if (this.columnConverters.put(IgniteNameUtils.parseIdentifier(columnName), converter) != null) {
            throw new IllegalArgumentException("Column converter already exists: " + columnName);
        }
        return this;
    }

    public MapperBuilder<T> automap() {
        this.ensureNotStale();
        this.automapFlag = true;
        return this;
    }

    public Mapper<T> build() {
        this.ensureNotStale();
        this.isStale = true;
        if (this.columnToFields == null) {
            return new OneColumnMapperImpl<T>(this.targetType, this.mappedToColumn, this.columnConverters.get(this.mappedToColumn));
        }
        Map<String, String> mapping = this.columnToFields;
        HashSet<String> fields = new HashSet<String>(mapping.size());
        for (String fldName : mapping.values()) {
            if (fields.add(fldName)) continue;
            throw new IllegalStateException("More than one column is mapped to the field: field=" + fldName);
        }
        if (this.automapFlag) {
            Arrays.stream(this.targetType.getDeclaredFields()).filter(fld -> !Modifier.isStatic(fld.getModifiers()) && !Modifier.isTransient(fld.getModifiers())).map(MapperBuilder::getColumnToFieldMapping).filter(entry -> !fields.contains(entry.getValue())).forEach(entry -> mapping.putIfAbsent(((String)entry.getKey()).toUpperCase(), (String)entry.getValue()));
        }
        return new PojoMapperImpl<T>(this.targetType, mapping, this.columnConverters);
    }

    private static AbstractMap.SimpleEntry<String, String> getColumnToFieldMapping(Field fld) {
        String fldName = fld.getName();
        Column column = fld.getAnnotation(Column.class);
        if (column == null) {
            return new AbstractMap.SimpleEntry<String, String>(fldName, fldName);
        }
        String columnName = column.value().isEmpty() ? fldName : column.value();
        return new AbstractMap.SimpleEntry<String, String>(columnName, fldName);
    }
}

