/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.util;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.gridgain.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.gridgain.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.gridgain.shaded.it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import org.gridgain.shaded.it.unimi.dsi.fastutil.ints.IntSet;
import org.gridgain.shaded.it.unimi.dsi.fastutil.ints.IntSets;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

public final class CollectionUtils {
    private static final Object NO_NEXT_ELEMENT = new Object();

    private CollectionUtils() {
    }

    public static boolean nullOrEmpty(@Nullable Collection<?> col) {
        return col == null || col.isEmpty();
    }

    public static boolean nullOrEmpty(@Nullable Iterable<?> c) {
        return c == null || (c instanceof Collection ? ((Collection)c).isEmpty() : !c.iterator().hasNext());
    }

    public static boolean nullOrEmpty(@Nullable Map<?, ?> col) {
        return col == null || col.isEmpty();
    }

    public static boolean nullOrEmpty(@Nullable Iterator<?> iter) {
        return iter == null || !iter.hasNext();
    }

    @Nullable
    public static <T> T first(List<? extends T> list) {
        if (CollectionUtils.nullOrEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Nullable
    public static <T> T first(Collection<? extends T> col) {
        if (CollectionUtils.nullOrEmpty(col)) {
            return null;
        }
        return col.iterator().next();
    }

    @Nullable
    public static <T> T first(Iterable<? extends T> iterable) {
        if (iterable == null) {
            return null;
        }
        Iterator<T> it = iterable.iterator();
        if (!it.hasNext()) {
            return null;
        }
        return it.next();
    }

    public static <T> Set<T> union(@Nullable Set<T> firstSet, @Nullable Set<T> secondSet) {
        boolean isFirstSetEmptyOrNull = CollectionUtils.nullOrEmpty(firstSet);
        boolean isSecondSetEmptyOrNull = CollectionUtils.nullOrEmpty(secondSet);
        if (isFirstSetEmptyOrNull && isSecondSetEmptyOrNull) {
            return Set.of();
        }
        if (isFirstSetEmptyOrNull) {
            return Collections.unmodifiableSet(secondSet);
        }
        if (isSecondSetEmptyOrNull) {
            return Collections.unmodifiableSet(firstSet);
        }
        HashSet<T> union = new HashSet<T>(firstSet);
        union.addAll(secondSet);
        return Collections.unmodifiableSet(union);
    }

    @SafeVarargs
    public static <T> Collection<T> concat(final Collection<T> ... collections) {
        if (collections == null || collections.length == 0) {
            return List.of();
        }
        return new AbstractCollection<T>(){

            @Override
            public Iterator<T> iterator() {
                return CollectionUtils.concat(collections).iterator();
            }

            @Override
            public int size() {
                int size = 0;
                for (int i = 0; i < collections.length; ++i) {
                    size += collections[i].size();
                }
                return size;
            }

            @Override
            public boolean contains(Object o) {
                for (int i = 0; i < collections.length; ++i) {
                    if (!collections[i].contains(o)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @SafeVarargs
    public static <T> Iterable<T> concat(final Iterable<? extends T> ... iterables) {
        if (iterables == null || iterables.length == 0) {
            return Collections::emptyIterator;
        }
        return () -> new Iterator<T>(){
            int idx = 0;
            Iterator<? extends T> curr = Collections.emptyIterator();

            @Override
            public boolean hasNext() {
                while (!this.curr.hasNext() && this.idx < iterables.length) {
                    this.curr = iterables[this.idx++].iterator();
                }
                return this.curr.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.curr.next();
            }
        };
    }

    @SafeVarargs
    public static <T> Iterator<T> concat(final Iterator<? extends T> ... iterators) {
        if (iterators == null || iterators.length == 0) {
            return Collections.emptyIterator();
        }
        return new Iterator<T>(){
            int idx = 0;
            Iterator<? extends T> curr = Collections.emptyIterator();

            @Override
            public boolean hasNext() {
                while (!this.curr.hasNext() && this.idx < iterators.length) {
                    this.curr = iterators[this.idx++];
                }
                return this.curr.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.curr.next();
            }
        };
    }

    public static <T> Iterator<T> concat(@Nullable Iterable<Iterator<? extends T>> iterators) {
        if (iterators == null) {
            return Collections.emptyIterator();
        }
        return CollectionUtils.concat(iterators.iterator());
    }

    public static <T> Iterator<T> concat(final @Nullable Iterator<Iterator<? extends T>> iterators) {
        if (iterators == null || !iterators.hasNext()) {
            return Collections.emptyIterator();
        }
        return new Iterator<T>(){
            Iterator<? extends T> curr = Collections.emptyIterator();

            @Override
            public boolean hasNext() {
                while (!this.curr.hasNext() && iterators.hasNext()) {
                    this.curr = (Iterator)iterators.next();
                }
                return this.curr.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.curr.next();
            }
        };
    }

    @SafeVarargs
    public static <T> List<T> concat(final List<T> ... lists) {
        if (lists == null || lists.length == 0) {
            return List.of();
        }
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                for (List list : lists) {
                    if (index >= list.size()) {
                        index -= list.size();
                        continue;
                    }
                    return list.get(index);
                }
                throw new IndexOutOfBoundsException(index);
            }

            @Override
            public Iterator<T> iterator() {
                return CollectionUtils.concat(lists).iterator();
            }

            @Override
            public int size() {
                int size = 0;
                for (List list : lists) {
                    size += list.size();
                }
                return size;
            }

            @Override
            public boolean contains(Object o) {
                for (List list : lists) {
                    if (!list.contains(o)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T> Set<T> difference(@Nullable Set<T> a, @Nullable Set<T> b) {
        if (CollectionUtils.nullOrEmpty(a)) {
            return Set.of();
        }
        if (CollectionUtils.nullOrEmpty(b)) {
            return Collections.unmodifiableSet(a);
        }
        HashSet<T> res = null;
        for (T t : a) {
            if (b.contains(t)) continue;
            if (res == null) {
                res = new HashSet<T>();
            }
            res.add(t);
        }
        return res == null ? Set.of() : Collections.unmodifiableSet(res);
    }

    public static IntSet setOf(Collection<Integer> coll) {
        return IntSets.unmodifiable(new IntOpenHashSet(coll));
    }

    public static <T> Set<T> intersect(Set<T> op1, Set<T> op2) {
        return op1.stream().filter(op2::contains).collect(Collectors.toSet());
    }

    @Nullable
    public static <T> T last(List<? extends T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public static <T, V> Collector<T, ?, Int2ObjectMap<V>> toIntMapCollector(Function<T, Integer> keyMapper, Function<T, V> valueMapper) {
        return Collectors.toMap(keyMapper, valueMapper, (oldVal, newVal) -> newVal, Int2ObjectOpenHashMap::new);
    }

    @Nullable
    public static <T> List<T> copyOrNull(@Nullable List<T> list) {
        if (list == null) {
            return null;
        }
        return List.copyOf(list);
    }

    @Nullable
    public static <T> Set<T> copyOrNull(@Nullable Set<T> set) {
        if (set == null) {
            return null;
        }
        return Set.copyOf(set);
    }

    @Nullable
    public static <K, V> Map<K, V> copyOrNull(@Nullable Map<K, V> map) {
        if (map == null) {
            return null;
        }
        return Map.copyOf(map);
    }

    public static <T1, T2> Iterable<T2> mapIterable(final @Nullable Iterable<? extends T1> iterable, final @Nullable Function<? super T1, ? extends T2> mapper, final @Nullable Predicate<? super T1> predicate) {
        if (iterable == null) {
            return Collections.emptyList();
        }
        if (mapper == null && predicate == null) {
            return iterable;
        }
        return new Iterable<T2>(){

            @Override
            public Iterator<T2> iterator() {
                final Iterator innerIterator = iterable.iterator();
                return new Iterator<T2>(){
                    @Nullable
                    T1 current = this.advance();

                    @Override
                    public boolean hasNext() {
                        return this.current != NO_NEXT_ELEMENT;
                    }

                    @Override
                    public T2 next() {
                        Object current = this.current;
                        if (current == NO_NEXT_ELEMENT) {
                            throw new NoSuchElementException();
                        }
                        this.current = this.advance();
                        return mapper == null ? current : mapper.apply(current);
                    }

                    @Nullable
                    private T1 advance() {
                        while (innerIterator.hasNext()) {
                            Object next = innerIterator.next();
                            if (predicate != null && !predicate.test(next)) continue;
                            return next;
                        }
                        return NO_NEXT_ELEMENT;
                    }
                };
            }
        };
    }

    public static <T1, T2> Set<T2> mapToImmutableSet(Set<T1> input, Function<T1, T2> mapper) {
        Object[] r = new Object[input.size()];
        int counter = 0;
        for (T1 name : input) {
            r[counter++] = mapper.apply(name);
        }
        return Set.of(r);
    }

    public static <T, R> List<R> view(final List<T> list, final Function<? super T, ? extends R> mapper) {
        if (list.isEmpty()) {
            return List.of();
        }
        return new AbstractList<R>(){

            @Override
            public R get(int index) {
                return mapper.apply(list.get(index));
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    public static <T> void setListAtIndex(List<T> list, int i, T element) {
        if (list.size() < i) {
            list.addAll(Collections.nCopies(i - list.size(), null));
        }
        if (list.size() < i + 1) {
            list.add(element);
        } else {
            T prev = list.set(i, element);
            assert (prev == null) : String.format("Found previous value %s at index %d", prev, i);
        }
    }
}

