/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.streamer;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

class StreamerBuffer<T> {
    private final int capacity;
    private final Function<List<T>, CompletableFuture<?>> flusher;
    private List<T> buf;
    private boolean closed;
    private long lastFlushNanos = System.nanoTime();
    private CompletableFuture<?> flushFut;

    StreamerBuffer(int capacity, Function<List<T>, CompletableFuture<?>> flusher) {
        this.capacity = capacity;
        this.flusher = flusher;
        this.buf = new ArrayList<T>(capacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(T item) {
        List<T> bufToFlush = null;
        StreamerBuffer streamerBuffer = this;
        synchronized (streamerBuffer) {
            if (this.closed) {
                throw new IllegalStateException("Streamer is closed, can't add items.");
            }
            this.buf.add(item);
            if (this.buf.size() >= this.capacity) {
                bufToFlush = this.buf;
                this.buf = new ArrayList<T>(this.capacity);
                this.lastFlushNanos = System.nanoTime();
            }
        }
        this.flushBuf(bufToFlush);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushAndClose() {
        List<T> bufToFlush;
        StreamerBuffer streamerBuffer = this;
        synchronized (streamerBuffer) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            bufToFlush = this.buf;
        }
        this.flushBuf(bufToFlush);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void autoFlush(long intervalNanos) {
        List<T> bufToFlush;
        StreamerBuffer streamerBuffer = this;
        synchronized (streamerBuffer) {
            if (this.closed || this.buf.isEmpty()) {
                return;
            }
            if (this.flushFut != null && !this.flushFut.isDone()) {
                return;
            }
            if (System.nanoTime() - this.lastFlushNanos < intervalNanos) {
                return;
            }
            bufToFlush = this.buf;
            this.buf = new ArrayList<T>(this.capacity);
            this.lastFlushNanos = System.nanoTime();
        }
        this.flushBuf(bufToFlush);
    }

    synchronized void forEach(Consumer<T> consumer) {
        if (this.closed) {
            return;
        }
        this.buf.forEach(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuf(@Nullable List<T> bufToFlush) {
        if (bufToFlush == null || bufToFlush.isEmpty()) {
            return;
        }
        CompletableFuture<?> fut = this.flusher.apply(bufToFlush);
        StreamerBuffer streamerBuffer = this;
        synchronized (streamerBuffer) {
            this.flushFut = fut;
        }
    }
}

