/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.properties;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.gridgain.shaded.org.apache.ignite.internal.lang.IgniteInternalException;

public class IgniteProperties {
    public static final String VERSION = "ignite.version";
    public static final String PRODUCT = "ignite.product";
    public static final String COMMIT_HASH = "ignite.release.commit";
    public static final String RELEASE_TYPE = "ignite.release.type";
    private static final String FILE_PATH = "ignite.properties";
    private static final Properties PROPS = IgniteProperties.readProperties("ignite.properties");

    private static Properties readProperties(String path) {
        Properties properties = new Properties();
        try (InputStream is = IgniteProperties.class.getClassLoader().getResourceAsStream(path);){
            properties.load(is);
        }
        catch (IOException e) {
            throw new IgniteInternalException("Failed to read properties file: " + path, (Throwable)e);
        }
        return properties;
    }

    public static String get(String key) {
        return PROPS.getProperty(key, "");
    }

    private IgniteProperties() {
    }
}

