/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.metrics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.gridgain.shaded.org.apache.ignite.internal.metrics.AbstractMetric;
import org.gridgain.shaded.org.apache.ignite.internal.metrics.CompositeMetric;
import org.gridgain.shaded.org.apache.ignite.internal.metrics.LongGauge;
import org.gridgain.shaded.org.apache.ignite.internal.metrics.LongMetric;
import org.gridgain.shaded.org.apache.ignite.internal.metrics.Metric;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

public class DistributionMetric
extends AbstractMetric
implements CompositeMetric {
    private static final AtomicReferenceFieldUpdater<DistributionMetric, List> scalarMetricsUpdater = AtomicReferenceFieldUpdater.newUpdater(DistributionMetric.class, List.class, "scalarMetrics");
    private static final long FIRST_LOW_BOUND = 0L;
    private static final String FIRST_LOW_BOUND_STRING = "0";
    private static final String INF = "inf";
    private static final char RANGE_DIVIDER = '_';
    private static final String BUCKET_DIVIDER = ", ";
    private static final String METRIC_DIVIDER = ": ";
    private final AtomicLongArray measurements;
    private final long[] bounds;
    private volatile List<Metric> scalarMetrics = null;

    public DistributionMetric(String name, @Nullable String desc, long[] bounds) {
        super(name, desc);
        assert (bounds != null && bounds.length > 0);
        assert (bounds[0] >= 0L);
        assert (DistributionMetric.isSortedAndUnique(bounds));
        this.bounds = bounds;
        this.measurements = new AtomicLongArray(bounds.length + 1);
    }

    private static boolean isSortedAndUnique(long[] arr) {
        if (arr.length < 2) {
            return true;
        }
        for (int i = 1; i < arr.length; ++i) {
            if (arr[i - 1] < arr[i]) continue;
            return false;
        }
        return true;
    }

    public void add(long x) {
        assert (x >= 0L);
        for (int i = 0; i < this.bounds.length; ++i) {
            if (x > this.bounds[i]) continue;
            this.measurements.incrementAndGet(i);
            return;
        }
        this.measurements.incrementAndGet(this.bounds.length);
    }

    public long[] value() {
        long[] res = new long[this.measurements.length()];
        for (int i = 0; i < this.measurements.length(); ++i) {
            res[i] = this.measurements.get(i);
        }
        return res;
    }

    @Override
    public String getValueAsString() {
        StringBuilder sb = new StringBuilder("[");
        List<Metric> scalarMetrics = this.asScalarMetrics();
        for (int i = 0; i < scalarMetrics.size(); ++i) {
            LongMetric m = (LongMetric)scalarMetrics.get(i);
            String shortenedScalarMetricName = m.name().substring(this.name().length() + 1);
            sb.append(shortenedScalarMetricName).append(METRIC_DIVIDER).append(m.value());
            if (i >= scalarMetrics.size() - 1) continue;
            sb.append(BUCKET_DIVIDER);
        }
        sb.append(']');
        return sb.toString();
    }

    public long[] bounds() {
        return this.bounds;
    }

    @Override
    public List<Metric> asScalarMetrics() {
        if (this.scalarMetrics == null) {
            ArrayList<LongGauge> metrics = new ArrayList<LongGauge>();
            String from = FIRST_LOW_BOUND_STRING;
            int i = 0;
            while (i < this.measurements.length()) {
                String to = i == this.measurements.length() - 1 ? INF : String.valueOf(this.bounds[i]);
                String name = this.name() + "_" + from + "_" + to;
                int index = i++;
                LongGauge gauge = new LongGauge(name, "Single distribution bucket", () -> this.measurements.get(index));
                metrics.add(gauge);
                from = to;
            }
            scalarMetricsUpdater.compareAndSet(this, null, Collections.unmodifiableList(metrics));
        }
        return this.scalarMetrics;
    }
}

