/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.hlc;

import java.util.concurrent.atomic.AtomicLong;
import org.gridgain.shaded.org.apache.ignite.internal.hlc.HybridTimestamp;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

public interface HybridTimestampTracker {
    public static final HybridTimestampTracker EMPTY_TS_PROVIDER = new HybridTimestampTracker(){

        @Override
        @Nullable
        public HybridTimestamp get() {
            return null;
        }

        @Override
        public long getLong() {
            return 0L;
        }

        @Override
        public void update(@Nullable HybridTimestamp ts) {
        }

        @Override
        public void update(long ts) {
        }
    };

    public static HybridTimestampTracker emptyTracker() {
        return EMPTY_TS_PROVIDER;
    }

    public static HybridTimestampTracker atomicTracker(final @Nullable HybridTimestamp intTs) {
        return new HybridTimestampTracker(){
            private final AtomicLong timestamp;
            {
                this.timestamp = new AtomicLong(HybridTimestamp.hybridTimestampToLong(intTs));
            }

            @Override
            @Nullable
            public HybridTimestamp get() {
                return HybridTimestamp.nullableHybridTimestamp(this.timestamp.get());
            }

            @Override
            public long getLong() {
                return this.timestamp.get();
            }

            @Override
            public void update(@Nullable HybridTimestamp ts) {
                long tsVal = HybridTimestamp.hybridTimestampToLong(ts);
                this.timestamp.updateAndGet(x -> Math.max(x, tsVal));
            }

            @Override
            public void update(long ts) {
                this.timestamp.updateAndGet(x -> Math.max(x, ts));
            }
        };
    }

    @Nullable
    public HybridTimestamp get();

    public long getLong();

    public void update(@Nullable HybridTimestamp var1);

    public void update(long var1);
}

