/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.client.sql;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.gridgain.shaded.org.apache.ignite.internal.client.PartitionMapping;
import org.gridgain.shaded.org.apache.ignite.internal.client.sql.ClientDirectTxMode;
import org.gridgain.shaded.org.apache.ignite.internal.client.sql.ClientPartitionAwarenessMetadata;
import org.gridgain.shaded.org.apache.ignite.internal.client.table.ClientColumn;
import org.gridgain.shaded.org.apache.ignite.internal.client.table.ClientSchema;
import org.gridgain.shaded.org.apache.ignite.internal.client.table.ClientTable;
import org.gridgain.shaded.org.apache.ignite.internal.util.HashCalculator;
import org.jspecify.annotations.Nullable;

public class PartitionMappingProvider {
    private final int tableId;
    private final Supplier<@Nullable ClientSchema> schemaProvider;
    private final Supplier<@Nullable List<String>> assignmentsProvider;
    private final int[] indexes;
    private final int[] hash;
    private final ClientDirectTxMode directTxMode;

    static PartitionMappingProvider create(ClientTable table, ClientPartitionAwarenessMetadata meta) {
        assert (table.tableId() == meta.tableId());
        CompletableFuture<ClientSchema> schemaFuture = table.getLatestSchema();
        return new PartitionMappingProvider(meta.tableId(), meta.indexes(), meta.hash(), meta.directTxMode(), () -> schemaFuture.getNow(null), () -> table.getPartitionAssignment().getNow(null));
    }

    private PartitionMappingProvider(int tableId, int[] indexes, int[] hash, ClientDirectTxMode directTxMode, Supplier<@Nullable ClientSchema> schemaProvider, Supplier<@Nullable List<String>> assignmentsProvider) {
        this.tableId = tableId;
        this.indexes = indexes;
        this.hash = hash;
        this.directTxMode = directTxMode;
        this.schemaProvider = schemaProvider;
        this.assignmentsProvider = assignmentsProvider;
    }

    public int tableId() {
        return this.tableId;
    }

    public int[] indexes() {
        return this.indexes;
    }

    public int[] hash() {
        return this.hash;
    }

    public ClientDirectTxMode directTxMode() {
        return this.directTxMode;
    }

    public boolean ready() {
        return this.schemaProvider.get() != null && this.assignmentsProvider.get() != null;
    }

    public @Nullable PartitionMapping get(Object[] params) {
        ClientSchema schema = this.schemaProvider.get();
        List<String> assignments = this.assignmentsProvider.get();
        if (schema == null || assignments == null) {
            return null;
        }
        HashCalculator calculator = new HashCalculator();
        ClientColumn[] colocationColumns = schema.colocationColumns();
        if (colocationColumns.length != this.indexes.length) {
            assert (false);
            return null;
        }
        for (int i = 0; i < colocationColumns.length; ++i) {
            int idx = this.indexes[i];
            if (idx >= params.length) {
                return null;
            }
            if (idx >= 0) {
                ClientColumn column = colocationColumns[i];
                calculator.append(params[this.indexes[i]], column.scale(), column.precision());
                continue;
            }
            calculator.combine(this.hash[-(idx + 1)]);
        }
        int colocationHash = calculator.hash();
        int part = Math.abs(colocationHash % assignments.size());
        String node = assignments.get(part);
        if (node == null) {
            return null;
        }
        return new PartitionMapping(this.tableId, node, part);
    }
}

