/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.client;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.gridgain.shaded.org.jetbrains.annotations.Nullable;

class ClientFutureUtils {
    ClientFutureUtils() {
    }

    @Nullable
    static <T> T getNowSafe(CompletableFuture<T> fut) {
        try {
            return fut.getNow(null);
        }
        catch (Throwable e) {
            return null;
        }
    }

    static <T> CompletableFuture<T> doWithRetryAsync(Supplier<CompletableFuture<T>> func, @Nullable Predicate<T> resultValidator, Predicate<RetryContext> retryPredicate) {
        CompletableFuture resFut = new CompletableFuture();
        RetryContext ctx = new RetryContext();
        ClientFutureUtils.doWithRetryAsync(func, resultValidator, retryPredicate, resFut, ctx);
        return resFut;
    }

    private static <T> void doWithRetryAsync(Supplier<CompletableFuture<T>> func, @Nullable Predicate<T> validator, Predicate<RetryContext> retryPredicate, CompletableFuture<T> resFut, RetryContext ctx) {
        func.get().whenComplete((res, err) -> {
            try {
                if (err == null && (validator == null || validator.test(res))) {
                    resFut.complete(res);
                    return;
                }
                if (err != null) {
                    if (ctx.errors == null) {
                        ctx.errors = new ArrayList();
                    }
                    ctx.errors.add((Throwable)err);
                }
                if (retryPredicate.test(ctx)) {
                    ++ctx.attempt;
                    ClientFutureUtils.doWithRetryAsync(func, validator, retryPredicate, resFut, ctx);
                } else if (ctx.errors == null || ctx.errors.isEmpty()) {
                    resFut.completeExceptionally(new IllegalStateException("doWithRetry failed without exception"));
                } else {
                    Throwable resErr = ctx.errors.get(0);
                    for (int i = 1; i < ctx.errors.size(); ++i) {
                        resErr.addSuppressed(ctx.errors.get(i));
                    }
                    resFut.completeExceptionally(resErr);
                }
            }
            catch (Throwable t) {
                resFut.completeExceptionally(t);
            }
        });
    }

    static class RetryContext {
        int attempt;
        @Nullable
        ArrayList<Throwable> errors;

        RetryContext() {
        }

        @Nullable
        Throwable lastError() {
            return this.errors == null || this.errors.isEmpty() ? null : this.errors.get(this.errors.size() - 1);
        }
    }
}

