/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.shaded.org.apache.ignite.internal.catalog.sql;

import java.util.Objects;
import org.gridgain.shaded.org.apache.ignite.internal.catalog.sql.AbstractCatalogQuery;
import org.gridgain.shaded.org.apache.ignite.internal.catalog.sql.Name;
import org.gridgain.shaded.org.apache.ignite.internal.catalog.sql.QueryContext;
import org.gridgain.shaded.org.apache.ignite.sql.IgniteSql;
import org.gridgain.shaded.org.apache.ignite.table.QualifiedName;

class DropCacheImpl
extends AbstractCatalogQuery<Name> {
    private Name cacheName;
    private boolean ifExists;

    DropCacheImpl(IgniteSql sql) {
        super(sql);
    }

    @Override
    protected Name result() {
        return this.cacheName;
    }

    DropCacheImpl name(QualifiedName name) {
        Objects.requireNonNull(name, "Cache name must not be null");
        this.cacheName = Name.qualified(name);
        return this;
    }

    DropCacheImpl name(Name name) {
        Objects.requireNonNull(name, "Cache name must not be null");
        this.cacheName = name;
        return this;
    }

    DropCacheImpl ifExists() {
        this.ifExists = true;
        return this;
    }

    @Override
    protected void accept(QueryContext ctx) {
        ctx.sql("DROP CACHE ");
        if (this.ifExists) {
            ctx.sql("IF EXISTS ");
        }
        ctx.visit(this.cacheName);
        ctx.sql(";");
    }
}

