/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database.inlinecolumn;

import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.AbstractInlineIndexColumn;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueBoolean;

public class BooleanInlineIndexColumn
extends AbstractInlineIndexColumn {
    public BooleanInlineIndexColumn(Column col) {
        super(col, 1, (short)1);
    }

    @Override
    protected int compare0(long pageAddr, int off, Value v, int type) {
        if (this.type() != type) {
            return Integer.MIN_VALUE;
        }
        boolean bool1 = PageUtils.getByte((long)pageAddr, (int)(off + 1)) != 0;
        boolean bool2 = v.getBoolean();
        return Integer.signum(Boolean.compare(bool1, bool2));
    }

    @Override
    protected int put0(long pageAddr, int off, Value val, int maxSize) {
        assert (this.type() == val.getValueType());
        PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getValueType()));
        PageUtils.putByte((long)pageAddr, (int)(off + 1), (byte)((byte)(val.getBoolean() ? 1 : 0)));
        return this.size() + 1;
    }

    @Override
    protected Value get0(long pageAddr, int off) {
        return ValueBoolean.get((PageUtils.getByte((long)pageAddr, (int)(off + 1)) != 0 ? 1 : 0) != 0);
    }

    @Override
    protected int inlineSizeOf0(Value val) {
        assert (val.getType().getValueType() == this.type());
        return this.size() + 1;
    }
}

