/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.query.h2.H2QueryInfo;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.Nullable;

public final class LongRunningQueryManager {
    private static final long CHECK_PERIOD = 1000L;
    private static final long DFLT_FETCHED_SIZE_THRESHOLD = 100000L;
    public static final String LONG_QUERY_EXEC_MSG = "Query execution is too long";
    public static final String LONG_QUERY_FINISHED_MSG = "Long running query is finished: ";
    public static final String LONG_QUERY_ERROR_MSG = "Long running query is finished with error: ";
    private final ConcurrentHashMap<H2QueryInfo, TimeoutChecker> qrys = new ConcurrentHashMap();
    private final GridWorker checkWorker;
    private final IgniteLogger log;
    private volatile long timeout;
    private volatile int timeoutMult = 2;
    private volatile long rsSizeThreshold = 100000L;
    private volatile int rsSizeThresholdMult = 2;

    public LongRunningQueryManager(GridKernalContext ctx) {
        this.log = ctx.log(LongRunningQueryManager.class);
        this.checkWorker = new GridWorker(ctx.igniteInstanceName(), "long-qry", this.log){

            protected void body() throws IgniteInterruptedCheckedException {
                while (true) {
                    LongRunningQueryManager.this.checkLongRunning();
                    U.sleep((long)1000L);
                }
            }
        };
        this.timeout = ctx.config().getSqlConfiguration().getLongQueryWarningTimeout();
        IgniteThread thread = new IgniteThread(this.checkWorker);
        thread.setDaemon(true);
        thread.start();
    }

    public void stop() {
        this.checkWorker.cancel();
        this.qrys.clear();
    }

    public void registerQuery(H2QueryInfo qryInfo) {
        assert (qryInfo != null);
        long timeout0 = this.timeout;
        if (timeout0 > 0L) {
            this.qrys.put(qryInfo, new TimeoutChecker(timeout0, this.timeoutMult));
        }
    }

    public void unregisterQuery(H2QueryInfo qryInfo, @Nullable Throwable err) {
        assert (qryInfo != null);
        if (this.qrys.remove(qryInfo) != null && qryInfo.time() > this.timeout) {
            if (err == null) {
                qryInfo.printLogMessage(this.log, LONG_QUERY_FINISHED_MSG, null);
            } else {
                qryInfo.printLogMessage(this.log, LONG_QUERY_ERROR_MSG + err.getMessage(), null, false);
            }
        }
    }

    private void checkLongRunning() {
        for (Map.Entry<H2QueryInfo, TimeoutChecker> e : this.qrys.entrySet()) {
            H2QueryInfo qinfo = e.getKey();
            if (!e.getValue().checkTimeout(qinfo.time())) continue;
            qinfo.printLogMessage(this.log, LONG_QUERY_EXEC_MSG, null);
            if (e.getValue().timeoutMult > 1) continue;
            this.qrys.remove(qinfo);
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public int getTimeoutMultiplier() {
        return this.timeoutMult;
    }

    public void setTimeoutMultiplier(int timeoutMult) {
        this.timeoutMult = timeoutMult;
    }

    public long getResultSetSizeThreshold() {
        return this.rsSizeThreshold;
    }

    public void setResultSetSizeThreshold(long rsSizeThreshold) {
        this.rsSizeThreshold = rsSizeThreshold;
    }

    public int getResultSetSizeThresholdMultiplier() {
        return this.rsSizeThresholdMult;
    }

    public void setResultSetSizeThresholdMultiplier(int rsSizeThresholdMult) {
        this.rsSizeThresholdMult = Math.max(rsSizeThresholdMult, 1);
    }

    private static class TimeoutChecker {
        private long timeout;
        private final int timeoutMult;

        public TimeoutChecker(long timeout, int timeoutMult) {
            this.timeout = timeout;
            this.timeoutMult = timeoutMult;
        }

        public boolean checkTimeout(long time) {
            if (time > this.timeout) {
                if (this.timeoutMult > 1) {
                    this.timeout *= (long)this.timeoutMult;
                }
                return true;
            }
            return false;
        }
    }
}

