/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.record.IndexRenameRootPageRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.persistence.RootPage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.pendingtask.DurableBackgroundTask;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.pendingtask.DurableBackgroundTaskResult;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIoResolver;
import org.apache.ignite.internal.processors.query.h2.database.H2Tree;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.Nullable;

public class DurableBackgroundCleanupIndexTreeTaskV2
extends IgniteDataTransferObject
implements DurableBackgroundTask<Long> {
    private static final long serialVersionUID = 0L;
    public static H2TreeFactory idxTreeFactory = new H2TreeFactory();
    @Nullable
    private volatile transient IgniteLogger log;
    private String uid;
    @Nullable
    private String grpName;
    private String cacheName;
    private String idxName;
    private String oldTreeName;
    private String newTreeName;
    private int segments;
    private volatile transient boolean needToRen;
    private final transient Map<Integer, RootPage> rootPages = new ConcurrentHashMap<Integer, RootPage>();
    @Nullable
    private volatile transient GridWorker worker;
    private final transient AtomicLong pageCnt = new AtomicLong();

    public DurableBackgroundCleanupIndexTreeTaskV2(@Nullable String grpName, String cacheName, String idxName, String oldTreeName, String newTreeName, int segments, @Nullable H2Tree[] trees) {
        this.uid = UUID.randomUUID().toString();
        this.grpName = grpName;
        this.cacheName = cacheName;
        this.idxName = idxName;
        this.oldTreeName = oldTreeName;
        this.newTreeName = newTreeName;
        this.segments = segments;
        if (trees != null) {
            assert (trees.length == segments) : "Invalid number of index trees [trees=" + trees.length + ", segments=" + segments + ']';
            this.rootPages.putAll(DurableBackgroundCleanupIndexTreeTaskV2.toRootPages(trees));
        }
        this.needToRen = true;
    }

    public DurableBackgroundCleanupIndexTreeTaskV2() {
    }

    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeLongString((DataOutput)out, (String)this.uid);
        U.writeLongString((DataOutput)out, (String)this.grpName);
        U.writeLongString((DataOutput)out, (String)this.cacheName);
        U.writeLongString((DataOutput)out, (String)this.idxName);
        U.writeLongString((DataOutput)out, (String)this.oldTreeName);
        U.writeLongString((DataOutput)out, (String)this.newTreeName);
        out.writeInt(this.segments);
    }

    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.uid = U.readLongString((DataInput)in);
        this.grpName = U.readLongString((DataInput)in);
        this.cacheName = U.readLongString((DataInput)in);
        this.idxName = U.readLongString((DataInput)in);
        this.oldTreeName = U.readLongString((DataInput)in);
        this.newTreeName = U.readLongString((DataInput)in);
        this.segments = in.readInt();
    }

    public String name() {
        return "drop-sql-index-" + this.cacheName + "-" + this.idxName + "-" + this.uid;
    }

    public void cancel() {
        this.rootPages.clear();
        GridWorker w = this.worker;
        if (w != null) {
            this.worker = null;
            U.awaitForWorkersStop(Collections.singleton(w), (boolean)true, (IgniteLogger)this.log);
        }
    }

    public IgniteInternalFuture<DurableBackgroundTaskResult<Long>> executeAsync(GridKernalContext ctx) {
        GridFinishedFuture outFut;
        block8: {
            assert (this.worker == null);
            this.log = ctx.log(DurableBackgroundCleanupIndexTreeTaskV2.class);
            final CacheGroupContext grpCtx = ctx.cache().cacheGroup(CU.cacheGroupId((String)this.cacheName, (String)this.grpName));
            if (grpCtx != null) {
                try {
                    if (this.needToRen) {
                        DurableBackgroundCleanupIndexTreeTaskV2.renameIndexRootPages(grpCtx, this.cacheName, this.oldTreeName, this.newTreeName, this.segments);
                        this.needToRen = false;
                    }
                    if (this.rootPages.isEmpty()) {
                        this.rootPages.putAll(DurableBackgroundCleanupIndexTreeTaskV2.findIndexRootPages(grpCtx, this.cacheName, this.newTreeName, this.segments));
                    }
                    if (!this.rootPages.isEmpty()) {
                        final GridFutureAdapter fut = new GridFutureAdapter();
                        GridWorker w = new GridWorker(ctx.igniteInstanceName(), "async-worker-" + this.name(), this.log){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            protected void body() {
                                try {
                                    Iterator it = DurableBackgroundCleanupIndexTreeTaskV2.this.rootPages.entrySet().iterator();
                                    while (it.hasNext()) {
                                        Map.Entry e = it.next();
                                        RootPage rootPage = (RootPage)e.getValue();
                                        int segment = (Integer)e.getKey();
                                        long pages = DurableBackgroundCleanupIndexTreeTaskV2.destroyIndexTrees(grpCtx, rootPage, DurableBackgroundCleanupIndexTreeTaskV2.this.cacheName, DurableBackgroundCleanupIndexTreeTaskV2.this.newTreeName, DurableBackgroundCleanupIndexTreeTaskV2.this.idxName, segment);
                                        if (pages > 0L) {
                                            DurableBackgroundCleanupIndexTreeTaskV2.this.pageCnt.addAndGet(pages);
                                        }
                                        it.remove();
                                    }
                                    fut.onDone((Object)DurableBackgroundTaskResult.complete((Object)DurableBackgroundCleanupIndexTreeTaskV2.this.pageCnt.get()));
                                }
                                catch (Throwable t) {
                                    fut.onDone((Object)DurableBackgroundTaskResult.restart((Throwable)t));
                                }
                                finally {
                                    DurableBackgroundCleanupIndexTreeTaskV2.this.worker = null;
                                }
                            }
                        };
                        new IgniteThread(w).start();
                        this.worker = w;
                        outFut = fut;
                        break block8;
                    }
                    outFut = new GridFinishedFuture((Object)DurableBackgroundTaskResult.complete());
                }
                catch (Throwable t) {
                    outFut = new GridFinishedFuture((Object)DurableBackgroundTaskResult.restart((Throwable)t));
                }
            } else {
                outFut = new GridFinishedFuture((Object)DurableBackgroundTaskResult.complete());
            }
        }
        return outFut;
    }

    public synchronized void renameIndexTrees(CacheGroupContext grpCtx) throws IgniteCheckedException {
        DurableBackgroundCleanupIndexTreeTaskV2.renameIndexRootPages(grpCtx, this.cacheName, this.oldTreeName, this.newTreeName, this.segments);
        this.needToRen = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long destroyIndexTrees(CacheGroupContext grpCtx, RootPage rootPage, String cacheName, String treeName, String idxName, int segment) throws IgniteCheckedException {
        long pageCnt = 0L;
        grpCtx.shared().database().checkpointReadLock();
        try {
            H2Tree tree = idxTreeFactory.create(grpCtx, rootPage, treeName, idxName, cacheName);
            pageCnt += tree.destroy(null, true);
            if (grpCtx.offheap().dropRootPageForIndex(CU.cacheId((String)cacheName), treeName, segment) != null) {
                ++pageCnt;
            }
        }
        finally {
            grpCtx.shared().database().checkpointReadUnlock();
        }
        return pageCnt;
    }

    public static Map<Integer, RootPage> findIndexRootPages(CacheGroupContext grpCtx, String cacheName, String treeName, int segments) throws IgniteCheckedException {
        HashMap<Integer, RootPage> rootPages = new HashMap<Integer, RootPage>();
        for (int i = 0; i < segments; ++i) {
            RootPage rootPage = grpCtx.offheap().findRootPageForIndex(CU.cacheId((String)cacheName), treeName, i);
            if (rootPage == null) continue;
            rootPages.put(i, rootPage);
        }
        return rootPages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameIndexRootPages(CacheGroupContext grpCtx, String cacheName, String oldTreeName, String newTreeName, int segments) throws IgniteCheckedException {
        IgniteWriteAheadLogManager wal = grpCtx.shared().wal();
        int cacheId = CU.cacheId((String)cacheName);
        if (wal != null) {
            wal.log((WALRecord)new IndexRenameRootPageRecord(cacheId, oldTreeName, newTreeName, segments));
        }
        grpCtx.shared().database().checkpointReadLock();
        try {
            for (int i = 0; i < segments; ++i) {
                grpCtx.offheap().renameRootPageForIndex(cacheId, oldTreeName, newTreeName, i);
            }
        }
        finally {
            grpCtx.shared().database().checkpointReadUnlock();
        }
    }

    public static Map<Integer, RootPage> toRootPages(H2Tree[] trees) {
        if (F.isEmpty((Object[])trees)) {
            return Collections.emptyMap();
        }
        HashMap<Integer, RootPage> res = new HashMap<Integer, RootPage>();
        for (int i = 0; i < trees.length; ++i) {
            H2Tree tree = trees[i];
            assert (tree != null) : "No tree for segment: " + i;
            res.put(i, new RootPage(new FullPageId(tree.getMetaPageId(), tree.groupId()), tree.created()));
        }
        return res;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public String idxName() {
        return this.idxName;
    }

    public boolean needToRename() {
        return this.needToRen;
    }

    public String toString() {
        return S.toString(DurableBackgroundCleanupIndexTreeTaskV2.class, (Object)((Object)this));
    }

    public static class H2TreeFactory {
        protected H2Tree create(final CacheGroupContext grpCtx, RootPage rootPage, String treeName, String idxName, String cacheName) throws IgniteCheckedException {
            IgniteCacheOffheapManager offheap = grpCtx.offheap();
            final GridKernalContext ctx = grpCtx.shared().kernalContext();
            return new H2Tree(null, null, treeName, idxName, cacheName, null, offheap.reuseListForIndex(treeName), grpCtx.groupId(), grpCtx.cacheOrGroupName(), grpCtx.dataRegion().pageMemory(), grpCtx.shared().wal(), (AtomicLong)offheap.globalRemoveId(), rootPage.pageId().pageId(), false, Collections.emptyList(), Collections.emptyList(), new AtomicInteger(0), false, false, false, null, ctx.failure(), grpCtx.shared().diagnostic().pageLockTracker(), null, null, null, 0, PageIoResolver.DEFAULT_PAGE_IO_RESOLVER){

                @Override
                protected void temporaryReleaseLock() {
                    grpCtx.shared().database().checkpointReadUnlock();
                    grpCtx.shared().database().checkpointReadLock();
                }

                @Override
                protected long maxLockHoldTime() {
                    long sysWorkerBlockedTimeout = ctx.workersRegistry().getSystemWorkerBlockedTimeout();
                    return sysWorkerBlockedTimeout == 0L ? Long.MAX_VALUE : sysWorkerBlockedTimeout / 10L;
                }
            };
        }
    }
}

