/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.io;

import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.query.BulkLoadContextCursor;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.bulkload.BulkLoadAckClientParameters;
import org.apache.ignite.internal.processors.bulkload.BulkLoadCacheWriter;
import org.apache.ignite.internal.processors.bulkload.BulkLoadCsvFormat;
import org.apache.ignite.internal.processors.bulkload.BulkLoadFormat;
import org.apache.ignite.internal.processors.bulkload.BulkLoadLocationFile;
import org.apache.ignite.internal.processors.bulkload.BulkLoadLocationTable;
import org.apache.ignite.internal.processors.bulkload.BulkLoadParser;
import org.apache.ignite.internal.processors.bulkload.BulkLoadProcessor;
import org.apache.ignite.internal.processors.bulkload.BulkLoadStreamerWriter;
import org.apache.ignite.internal.processors.io.BulkLoadCommandProcessor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.dml.DmlBulkLoadDataConverter;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlan;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlanBuilder;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.sql.command.SqlBulkLoadCommand;
import org.apache.ignite.internal.util.lang.IgniteClosureX;

public class BasicBulkLoadCommandProcessor
implements BulkLoadCommandProcessor {
    @Override
    public FieldsQueryCursor<List<?>> processBulkLoadCommand(GridKernalContext ctx, SqlBulkLoadCommand cmd, Long qryId) throws IgniteCheckedException {
        if (cmd.from() instanceof BulkLoadLocationTable && cmd.into() instanceof BulkLoadLocationFile) {
            throw new IgniteSQLException(String.format("To use export feature, enable gridgain-bulkload module (requires Enterprise or Ultimate Edition)", cmd.format().name()), 2002);
        }
        if (!(cmd.format() instanceof BulkLoadCsvFormat)) {
            throw new IgniteSQLException(String.format("To use %s format, enable gridgain-bulkload module (requires Enterprise or Ultimate Edition)", cmd.format().name()), 2002);
        }
        if (cmd.packetSize() == null) {
            cmd.packetSize(0x400000);
        }
        IgniteH2Indexing idx = (IgniteH2Indexing)ctx.query().getIndexing();
        BulkLoadLocationTable into = (BulkLoadLocationTable)cmd.into();
        GridH2Table tbl = idx.schemaManager().dataTable(into.schemaName(), into.tableName());
        if (tbl == null) {
            throw new IgniteSQLException("Table does not exist: " + into.tableName(), 3001);
        }
        H2Utils.checkAndStartNotStartedCache(ctx, tbl);
        UpdatePlan plan = UpdatePlanBuilder.planForBulkLoad(into.columns(), tbl);
        DmlBulkLoadDataConverter dataConverter = new DmlBulkLoadDataConverter(plan);
        IgniteDataStreamer streamer = ctx.grid().dataStreamer(tbl.cacheName());
        BulkLoadStreamerWriter outputWriter = new BulkLoadStreamerWriter(streamer);
        BulkLoadParser inputParser = BulkLoadParser.createParser((BulkLoadFormat)cmd.format());
        BulkLoadProcessor processor = new BulkLoadProcessor(inputParser, (IgniteClosureX)dataConverter, (BulkLoadCacheWriter)outputWriter, idx.runningQueryManager(), qryId, ctx.tracing());
        String path = ((BulkLoadLocationFile)cmd.from()).path();
        BulkLoadAckClientParameters params = new BulkLoadAckClientParameters(path, cmd.packetSize().intValue());
        return new BulkLoadContextCursor(processor, params);
    }
}

