/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.util.Arrays;
import java.util.Collection;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.managers.systemview.GridSystemViewManager;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadWriteMetastorage;
import org.apache.ignite.internal.processors.metastorage.persistence.ReadWriteMetaStorageMock;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsHelper;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsInMemoryStoreImpl;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsPersistenceStoreImpl;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsRepository;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsStore;
import org.apache.ignite.internal.processors.query.stat.ObjectPartitionStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.StatisticsAbstractTest;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;
import org.apache.ignite.internal.processors.subscription.GridInternalSubscriptionProcessor;
import org.apache.ignite.testframework.junits.logger.GridTestLog4jLogger;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class StatisticsStorageUnitTest
extends StatisticsAbstractTest {
    private static final StatisticsKey KEY1 = new StatisticsKey("schema", "obj");
    private static final StatisticsKey KEY2 = new StatisticsKey("schema", "obj2");
    @Parameterized.Parameter(value=0)
    public String testLb;
    @Parameterized.Parameter(value=1)
    public IgniteStatisticsStore store;

    @Parameterized.Parameters(name="cacheMode={0}")
    public static Collection<Object[]> parameters() throws IgniteCheckedException {
        MetastorageLifecycleListener[] lsnr = new MetastorageLifecycleListener[1];
        IgniteStatisticsHelper helper = (IgniteStatisticsHelper)Mockito.mock(IgniteStatisticsHelper.class);
        GridInternalSubscriptionProcessor subscriptionProcessor = (GridInternalSubscriptionProcessor)Mockito.mock(GridInternalSubscriptionProcessor.class);
        ((GridInternalSubscriptionProcessor)Mockito.doAnswer(invocation -> {
            lsnr[0] = (MetastorageLifecycleListener)invocation.getArgument(0);
            return lsnr[0];
        }).when((Object)subscriptionProcessor)).registerMetastorageListener((MetastorageLifecycleListener)Mockito.any(MetastorageLifecycleListener.class));
        IgniteStatisticsInMemoryStoreImpl inMemoryStore = new IgniteStatisticsInMemoryStoreImpl(cls -> log);
        GridSystemViewManager sysViewMgr = (GridSystemViewManager)Mockito.mock(GridSystemViewManager.class);
        IgniteStatisticsRepository statsRepos = new IgniteStatisticsRepository((IgniteStatisticsStore)inMemoryStore, sysViewMgr, helper, cls -> log);
        IgniteCacheDatabaseSharedManager dbMgr = new IgniteCacheDatabaseSharedManager();
        IgniteStatisticsPersistenceStoreImpl persStore = new IgniteStatisticsPersistenceStoreImpl(subscriptionProcessor, dbMgr, cls -> new GridTestLog4jLogger());
        ReadWriteMetaStorageMock metastorage = new ReadWriteMetaStorageMock();
        lsnr[0].onReadyForReadWrite((ReadWriteMetastorage)metastorage);
        return Arrays.asList({"IgniteStatisticsInMemoryStoreImpl", inMemoryStore}, {"IgniteStatisticsPersistenceStoreImpl", persStore});
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.store = new IgniteStatisticsInMemoryStoreImpl(cls -> log);
    }

    @Test
    public void testClearAll() {
        this.store.clearAllStatistics();
        this.store.saveLocalPartitionStatistics(KEY1, this.getPartitionStatistics(1));
        this.store.clearAllStatistics();
        StatisticsStorageUnitTest.assertTrue((boolean)this.store.getLocalPartitionsStatistics(KEY1).isEmpty());
        StatisticsStorageUnitTest.assertNull((Object)this.store.getLocalPartitionStatistics(KEY1, 1));
    }

    @Test
    public void testSingleOperations() {
        ObjectPartitionStatisticsImpl partStat = this.getPartitionStatistics(21);
        this.store.saveLocalPartitionStatistics(KEY1, partStat);
        StatisticsStorageUnitTest.assertEquals((Object)partStat, (Object)this.store.getLocalPartitionStatistics(KEY1, 21));
        StatisticsStorageUnitTest.assertNull((Object)this.store.getLocalPartitionStatistics(KEY1, 2));
        StatisticsStorageUnitTest.assertNull((Object)this.store.getLocalPartitionStatistics(KEY2, 1));
    }

    @Test
    public void testGroupOperations() {
        ObjectPartitionStatisticsImpl partStat1 = this.getPartitionStatistics(101);
        ObjectPartitionStatisticsImpl partStat2 = this.getPartitionStatistics(102);
        ObjectPartitionStatisticsImpl partStat3 = this.getPartitionStatistics(103);
        this.store.replaceLocalPartitionsStatistics(KEY1, Arrays.asList(partStat1, partStat2, partStat3));
        StatisticsStorageUnitTest.assertEquals((int)3, (int)this.store.getLocalPartitionsStatistics(KEY1).size());
        StatisticsStorageUnitTest.assertEquals((int)0, (int)this.store.getLocalPartitionsStatistics(KEY2).size());
    }
}

