/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.util.Arrays;
import java.util.Collection;
import org.apache.ignite.Ignite;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.internal.processors.query.stat.StatisticsAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PSUCompositeIndexTableStatisticsUsageTest
extends StatisticsAbstractTest {
    @Parameterized.Parameter(value=0)
    public CacheMode cacheMode;

    @Parameterized.Parameters(name="cacheMode={0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({CacheMode.REPLICATED}, {CacheMode.PARTITIONED});
    }

    @Override
    protected void beforeTestsStarted() throws Exception {
        Ignite node = this.startGridsMultiThreaded(2);
        node.getOrCreateCache("default");
    }

    protected void beforeTest() throws Exception {
        this.sql("DROP TABLE IF EXISTS ci_table");
        this.sql("CREATE TABLE ci_table (ID INT, col_a int, col_b int, col_c int, col_d int, PRIMARY key (ID, col_a, col_b, col_c)) WITH \"TEMPLATE=" + this.cacheMode + "\"");
        this.sql("CREATE INDEX ci_table_abc ON ci_table(col_a, col_b, col_c)");
        for (int i = 0; i < 1000; ++i) {
            String sql = String.format("INSERT INTO ci_table(id, col_a, col_b, col_c) VALUES(%d, %d, %d, %d)", i, i, i * 2, i * 10);
            this.sql(sql);
        }
        this.collectStatistics("ci_table");
    }

    @Test
    public void selectAllColumns() {
        String sql = "select count(*) from ci_table i1 where col_a is null and col_b is null and col_c < 2";
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"CI_TABLE_ABC"}, sql, new String[1][]);
        this.sql("CREATE INDEX ci_table_c ON ci_table(col_c)");
        this.updateStatistics("ci_table");
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"CI_TABLE_ABC"}, sql, new String[1][]);
        this.sql("DROP INDEX IF EXISTS ci_table_c");
        this.updateStatistics("ci_table");
    }

    @Test
    public void selectAllColumns2() {
        String sql = "select count(*) from ci_table i1 where col_a is not null and col_b is not null and col_c = 2";
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[0], sql, new String[1][]);
        this.sql("CREATE INDEX ci_table_c ON ci_table(col_c)");
        this.updateStatistics("ci_table");
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"CI_TABLE_C"}, sql, new String[1][]);
        this.sql("DROP INDEX IF EXISTS ci_table_c");
        this.updateStatistics("ci_table");
    }

    @Test
    public void selectIdAndAllColumns() {
        String sql = "select count(*) from ci_table i1 where id = 1 and col_a is null and col_b is null and col_c < 2";
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[0], sql, new String[1][]);
    }
}

