/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.processors.query.stat.ColumnStatistics;
import org.apache.ignite.internal.processors.query.stat.ColumnStatisticsCollector;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueBoolean;
import org.gridgain.internal.h2.value.ValueByte;
import org.gridgain.internal.h2.value.ValueDate;
import org.gridgain.internal.h2.value.ValueDecimal;
import org.gridgain.internal.h2.value.ValueDouble;
import org.gridgain.internal.h2.value.ValueFloat;
import org.gridgain.internal.h2.value.ValueInt;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueShort;
import org.gridgain.internal.h2.value.ValueString;
import org.gridgain.internal.h2.value.ValueUuid;
import org.junit.Test;

public class ColumnStatisticsCollectorTest
extends GridCommonAbstractTest {
    private static final Map<Value[], Comparator<Value>> types = new HashMap<Value[], Comparator<Value>>();

    @Test
    public void testZeroAggregation() {
        Value[] zeroArr = new Value[]{};
        for (Map.Entry<Value[], Comparator<Value>> type : types.entrySet()) {
            ColumnStatisticsCollectorTest.testAggregation(type.getValue(), type.getKey()[0].getType(), 0, zeroArr);
        }
    }

    @Test
    public void testSingleNullAggregation() {
        for (Map.Entry<Value[], Comparator<Value>> type : types.entrySet()) {
            ColumnStatisticsCollectorTest.testAggregation(type.getValue(), type.getKey()[0].getType(), 1, new Value[0]);
        }
    }

    @Test
    public void testMultipleNullsAggregation() {
        Value[] zeroArr = new Value[]{};
        for (Map.Entry<Value[], Comparator<Value>> type : types.entrySet()) {
            ColumnStatisticsCollectorTest.testAggregation(type.getValue(), type.getKey()[0].getType(), 1000, zeroArr);
        }
    }

    @Test
    public void testSingleAggregation() {
        for (Map.Entry<Value[], Comparator<Value>> type : types.entrySet()) {
            for (Value v : type.getKey()) {
                ColumnStatisticsCollectorTest.testAggregation(type.getValue(), v.getType(), 0, v);
            }
        }
    }

    @Test
    public void testMultipleAggregation() {
        for (Map.Entry<Value[], Comparator<Value>> type : types.entrySet()) {
            Value[] vals = type.getKey();
            ColumnStatisticsCollectorTest.testAggregation(type.getValue(), vals[0].getType(), 0, vals);
        }
    }

    @Test
    public void testMultipleWithNullsAggregation() {
        for (Map.Entry<Value[], Comparator<Value>> type : types.entrySet()) {
            Value[] vals = type.getKey();
            ColumnStatisticsCollectorTest.testAggregation(type.getValue(), vals[0].getType(), vals.length, vals);
        }
    }

    private static void testAggregation(Comparator<Value> comp, TypeInfo type, int nulls, Value ... vals) {
        int i;
        Column intCol = new Column("test", type);
        ColumnStatisticsCollector collector = new ColumnStatisticsCollector(intCol, comp);
        ColumnStatisticsCollector collectorInverted = new ColumnStatisticsCollector(intCol, comp);
        for (i = 0; i < vals.length; ++i) {
            collector.add(vals[i]);
            collectorInverted.add(vals[vals.length - 1 - i]);
        }
        for (i = 0; i < nulls; ++i) {
            collector.add((Value)ValueNull.INSTANCE);
            collectorInverted.add((Value)ValueNull.INSTANCE);
        }
        ColumnStatistics res = collector.finish();
        ColumnStatistics resInverted = collectorInverted.finish();
        ColumnStatisticsCollectorTest.testAggregationResult(res, nulls, vals);
        ColumnStatisticsCollectorTest.testAggregationResult(resInverted, nulls, vals);
    }

    private static void testAggregationResult(ColumnStatistics res, int nulls, Value ... vals) {
        if (vals.length == 0) {
            ColumnStatisticsCollectorTest.assertNull((Object)res.min());
            ColumnStatisticsCollectorTest.assertNull((Object)res.max());
        } else {
            ColumnStatisticsCollectorTest.assertEquals((Object)vals[0], (Object)res.min());
            ColumnStatisticsCollectorTest.assertEquals((Object)vals[vals.length - 1], (Object)res.max());
        }
        ColumnStatisticsCollectorTest.assertEquals((long)nulls, (long)res.nulls());
        int distinct = vals.length == 0 ? 0 : new HashSet<Value>(Arrays.asList(vals)).size();
        ColumnStatisticsCollectorTest.assertEquals((long)distinct, (long)res.distinct());
        ColumnStatisticsCollectorTest.assertEquals((long)(vals.length + nulls), (long)res.total());
        ColumnStatisticsCollectorTest.assertNotNull((Object)res.raw());
    }

    static {
        types.put(new Value[]{ValueBoolean.get((boolean)false), ValueBoolean.get((boolean)true)}, (v1, v2) -> Boolean.compare(v1.getBoolean(), v2.getBoolean()));
        types.put(new Value[]{ValueInt.get((int)1), ValueInt.get((int)2), ValueInt.get((int)10)}, (v1, v2) -> Integer.compare(v1.getInt(), v2.getInt()));
        types.put(new Value[]{ValueShort.get((short)1), ValueShort.get((short)3)}, (v1, v2) -> Short.compare(v1.getShort(), v2.getShort()));
        types.put(new Value[]{ValueString.get((String)"1"), ValueString.get((String)"9")}, (v1, v2) -> v1.getString().compareTo(v2.getString()));
        types.put(new Value[]{ValueDecimal.get((BigDecimal)BigDecimal.ONE), ValueDecimal.get((BigDecimal)BigDecimal.TEN)}, (v1, v2) -> v1.getBigDecimal().compareTo(v2.getBigDecimal()));
        types.put(new Value[]{ValueDate.fromMillis((long)1L), ValueDate.fromMillis((long)10000L), ValueDate.fromMillis((long)9999999L)}, (v1, v2) -> v1.getDate().compareTo(v2.getDate()));
        types.put(new Value[]{ValueUuid.get((long)1L, (long)2L), ValueUuid.get((long)2L, (long)1L), ValueUuid.get((long)2L, (long)2L)}, (v1, v2) -> new UUID(((ValueUuid)v1).getHigh(), ((ValueUuid)v1).getLow()).compareTo(new UUID(((ValueUuid)v2).getHigh(), ((ValueUuid)v2).getLow())));
        types.put(new Value[]{ValueFloat.get((float)1.0f), ValueFloat.get((float)10.0f)}, (v1, v2) -> Float.compare(v1.getFloat(), v2.getFloat()));
        types.put(new Value[]{ValueDouble.get((double)1.0), ValueDouble.get((double)10.0)}, (v1, v2) -> Double.compare(v1.getDouble(), v2.getDouble()));
        types.put(new Value[]{ValueByte.get((byte)1), ValueByte.get((byte)2)}, (v1, v2) -> Byte.compare(v1.getByte(), v2.getByte()));
    }
}

