/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.processors.query.stat.BusyExecutor;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class BusyExecutorTest
extends GridCommonAbstractTest {
    private static final int TIME_TO_START_THREAD = 300;
    private IgniteThreadPoolExecutor pool;

    @Before
    public void createPool() {
        this.pool = new IgniteThreadPoolExecutor("BusyExecutorPrefix", "BusyExecutorTest", 0, 2, 60000L, new LinkedBlockingQueue(), -1, new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                BusyExecutorTest.fail((String)e.getMessage());
            }
        });
    }

    @After
    public void stopPool() {
        List unfinishedTasks;
        if (this.pool != null && !(unfinishedTasks = this.pool.shutdownNow()).isEmpty()) {
            BusyExecutorTest.fail((String)String.format("%d BusyExecutorTest tasks cancelled.", unfinishedTasks.size()));
        }
    }

    @Test
    public void testInactiveExecutor() throws Exception {
        BusyExecutor be = new BusyExecutor("testInactiveExecutor", this.pool, c -> log);
        CDLTask task = new CDLTask();
        BusyExecutorTest.assertFalse((boolean)be.busyRun((Runnable)task));
        Thread.sleep(300L);
        BusyExecutorTest.assertEquals((long)1L, (long)task.started.getCount());
        be.execute((Runnable)task);
        Thread.sleep(300L);
        BusyExecutorTest.assertEquals((long)1L, (long)task.started.getCount());
        BusyExecutorTest.assertFalse((boolean)((Boolean)be.submit((Runnable)task).get()));
        Thread.sleep(300L);
        BusyExecutorTest.assertEquals((long)1L, (long)task.started.getCount());
    }

    @Test
    public void testActivateDeactivate() throws Exception {
        BusyExecutor be = new BusyExecutor("testActivateDeactivate", this.pool, c -> log);
        CDLTask taskExec = new CDLTask();
        CDLTask taskSubmit = new CDLTask();
        be.activate();
        be.execute((Runnable)taskExec);
        CompletableFuture submitFuture = be.submit((Runnable)taskSubmit);
        Thread.sleep(300L);
        BusyExecutorTest.assertEquals((long)0L, (long)taskExec.started.getCount());
        GridTestUtils.runAsync(() -> be.deactivate(() -> {
            taskExec.finished.countDown();
            taskSubmit.finished.countDown();
        }));
        BusyExecutorTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> 0L == taskExec.finished.getCount(), (long)300L));
        BusyExecutorTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> 0L == taskSubmit.finished.getCount(), (long)300L));
    }

    @Test
    public void testNormalExecution() throws InterruptedException {
        BusyExecutor be = new BusyExecutor("testActivateDeactivate", this.pool, c -> log);
        be.activate();
        CompletableFuture[] futures = new CompletableFuture[100];
        CountDownLatch executed = new CountDownLatch(futures.length * 2);
        for (int i = 0; i < futures.length; ++i) {
            futures[i] = be.submit(() -> {
                try {
                    Thread.sleep(42L);
                    executed.countDown();
                    be.execute(() -> executed.countDown());
                }
                catch (InterruptedException e) {
                    BusyExecutorTest.fail((String)e.getMessage());
                }
            });
        }
        executed.await(10L, TimeUnit.SECONDS);
    }

    private class CDLTask
    implements Runnable {
        public CountDownLatch started = new CountDownLatch(1);
        public CountDownLatch finished = new CountDownLatch(1);

        private CDLTask() {
        }

        @Override
        public void run() {
            this.started.countDown();
            try {
                this.finished.await();
            }
            catch (InterruptedException e) {
                BusyExecutorTest.fail((String)e.getMessage());
            }
        }
    }
}

