/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.oom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.exceptions.SqlMemoryQuotaExceededException;
import org.apache.ignite.internal.processors.cache.query.IgniteQueryErrorCode;
import org.apache.ignite.internal.processors.query.h2.H2ManagedLocalResult;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.oom.BasicQueryMemoryTrackerSelfTest;
import org.apache.ignite.internal.util.IgniteUtils;
import org.junit.Test;

public class QueryMemoryTrackerSelfTest
extends BasicQueryMemoryTrackerSelfTest {
    @Override
    protected boolean isLocal() {
        return false;
    }

    @Override
    protected long globalQuotaSize() {
        return 0xB00000L;
    }

    @Override
    @Test
    public void testUnionOfSmallDataSetsWithLargeResult() {
        this.maxMem = 0x300000L;
        this.checkQueryExpectOOM("select * from T as T0, T as T1 where T0.id < 1 UNION select * from T as T2, T as T3 where T2.id >= 2 AND T2.id < 3", false);
        QueryMemoryTrackerSelfTest.assertEquals((int)5, (int)localResults.size());
        QueryMemoryTrackerSelfTest.assertTrue((this.maxMem > ((H2ManagedLocalResult)localResults.get(0)).memoryReserved() + ((H2ManagedLocalResult)localResults.get(1)).memoryReserved() ? 1 : 0) != 0);
        QueryMemoryTrackerSelfTest.assertEquals((int)1000, (int)((H2ManagedLocalResult)localResults.get(0)).getRowCount());
        QueryMemoryTrackerSelfTest.assertEquals((int)1000, (int)((H2ManagedLocalResult)localResults.get(1)).getRowCount());
        QueryMemoryTrackerSelfTest.assertTrue((this.maxMem > ((H2ManagedLocalResult)localResults.get(3)).memoryReserved() + ((H2ManagedLocalResult)localResults.get(4)).memoryReserved() ? 1 : 0) != 0);
        QueryMemoryTrackerSelfTest.assertEquals((int)1000, (int)((H2ManagedLocalResult)localResults.get(3)).getRowCount());
        QueryMemoryTrackerSelfTest.assertEquals((int)1000, (int)((H2ManagedLocalResult)localResults.get(4)).getRowCount());
        QueryMemoryTrackerSelfTest.assertTrue((2000 > ((H2ManagedLocalResult)localResults.get(2)).getRowCount() ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testQueryWithLimit() throws Exception {
        this.execQuery("select * from K LIMIT 500", false);
        QueryMemoryTrackerSelfTest.assertEquals((int)2, (int)localResults.size());
        QueryMemoryTrackerSelfTest.assertEquals((int)500, (int)((H2ManagedLocalResult)localResults.get(0)).getRowCount());
        QueryMemoryTrackerSelfTest.assertEquals((int)500, (int)((H2ManagedLocalResult)localResults.get(1)).getRowCount());
    }

    @Override
    @Test
    public void testLazyQueryWithHighLimit() {
        this.checkQueryExpectOOM("select * from K LIMIT 8000", true);
        QueryMemoryTrackerSelfTest.assertEquals((int)1, (int)localResults.size());
        QueryMemoryTrackerSelfTest.assertTrue((8000 > ((H2ManagedLocalResult)localResults.get(0)).getRowCount() ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testLazyQueryWithSortByIndexedCol() {
        this.checkQueryExpectOOM("select * from K ORDER BY K.indexed", true);
        QueryMemoryTrackerSelfTest.assertEquals((int)1, (int)localResults.size());
        QueryMemoryTrackerSelfTest.assertTrue((10000 > ((H2ManagedLocalResult)localResults.get(0)).getRowCount() ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testLazyQueryWithGroupByThenSort() {
        this.maxMem = 524288L;
        this.checkQueryExpectOOM("select K.indexed, sum(K.grp) as a from K GROUP BY K.indexed ORDER BY a DESC", true);
        QueryMemoryTrackerSelfTest.assertEquals((int)1, (int)localResults.size());
        QueryMemoryTrackerSelfTest.assertEquals((long)0L, (long)((H2ManagedLocalResult)localResults.get(0)).memoryReserved());
        QueryMemoryTrackerSelfTest.assertEquals((int)0, (int)((H2ManagedLocalResult)localResults.get(0)).getRowCount());
    }

    @Override
    @Test
    public void testQueryWithDistinctAndGroupBy() {
        this.checkQueryExpectOOM("select DISTINCT K.name from K GROUP BY K.id", true);
        QueryMemoryTrackerSelfTest.assertEquals((int)1, (int)localResults.size());
        QueryMemoryTrackerSelfTest.assertTrue((this.maxMem > ((H2ManagedLocalResult)localResults.get(0)).memoryReserved() ? 1 : 0) != 0);
        QueryMemoryTrackerSelfTest.assertTrue((10000 > ((H2ManagedLocalResult)localResults.get(0)).getRowCount() ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testQueryWithGroupsSmallResult() throws Exception {
        this.execQuery("select K.grp, avg(K.id), min(K.id), sum(K.id) from K GROUP BY K.grp", false);
        QueryMemoryTrackerSelfTest.assertEquals((int)2, (int)localResults.size());
        QueryMemoryTrackerSelfTest.assertEquals((int)100, (int)((H2ManagedLocalResult)localResults.get(0)).getRowCount());
        QueryMemoryTrackerSelfTest.assertEquals((int)100, (int)((H2ManagedLocalResult)localResults.get(1)).getRowCount());
    }

    @Override
    @Test
    public void testQueryWithGroupThenSort() throws Exception {
        this.execQuery("select K.grp_indexed, sum(K.id) as s from K GROUP BY K.grp_indexed ORDER BY s", false);
        QueryMemoryTrackerSelfTest.assertEquals((int)2, (int)localResults.size());
        QueryMemoryTrackerSelfTest.assertEquals((int)100, (int)((H2ManagedLocalResult)localResults.get(0)).getRowCount());
        QueryMemoryTrackerSelfTest.assertEquals((int)100, (int)((H2ManagedLocalResult)localResults.get(1)).getRowCount());
    }

    @Override
    @Test
    public void testQueryWithGroupByIndexedCol() {
        this.checkQueryExpectOOM("select K.indexed, sum(K.grp) from K GROUP BY K.indexed", true);
        QueryMemoryTrackerSelfTest.assertEquals((int)1, (int)localResults.size());
        QueryMemoryTrackerSelfTest.assertTrue((this.maxMem > ((H2ManagedLocalResult)localResults.get(0)).memoryReserved() ? 1 : 0) != 0);
        QueryMemoryTrackerSelfTest.assertTrue((10000 > ((H2ManagedLocalResult)localResults.get(0)).getRowCount() ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testQueryWithGroupByPrimaryKey() {
        this.checkQueryExpectOOM("select K.indexed, sum(K.grp) from K GROUP BY K.indexed", true);
        QueryMemoryTrackerSelfTest.assertEquals((int)1, (int)localResults.size());
        QueryMemoryTrackerSelfTest.assertTrue((this.maxMem > ((H2ManagedLocalResult)localResults.get(0)).memoryReserved() ? 1 : 0) != 0);
        QueryMemoryTrackerSelfTest.assertTrue((10000 > ((H2ManagedLocalResult)localResults.get(0)).getRowCount() ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testQueryWithDistinctAndLowCardinality() throws Exception {
        this.execQuery("select DISTINCT K.grp_indexed from K", false);
        QueryMemoryTrackerSelfTest.assertEquals((int)2, (int)localResults.size());
        QueryMemoryTrackerSelfTest.assertEquals((int)100, (int)((H2ManagedLocalResult)localResults.get(0)).getRowCount());
        QueryMemoryTrackerSelfTest.assertEquals((int)100, (int)((H2ManagedLocalResult)localResults.get(1)).getRowCount());
    }

    @Override
    @Test
    public void testLazyQueryWithGroupByIndexedColAndDistinctAggregates() {
        this.checkQueryExpectOOM("select K.grp_indexed, count(DISTINCT k.name) from K GROUP BY K.grp_indexed", true);
        QueryMemoryTrackerSelfTest.assertEquals((int)1, (int)localResults.size());
        QueryMemoryTrackerSelfTest.assertTrue((this.maxMem > ((H2ManagedLocalResult)localResults.get(0)).memoryReserved() ? 1 : 0) != 0);
        QueryMemoryTrackerSelfTest.assertTrue((10000 > ((H2ManagedLocalResult)localResults.get(0)).getRowCount() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test
    public void testGlobalQuota() throws Exception {
        ArrayList cursors = new ArrayList();
        try {
            for (int i = 0; i < 100; ++i) {
                FieldsQueryCursor<List<?>> fieldsQueryCursor = this.query("select DISTINCT T.name, T.id from T ORDER BY T.name", true);
                cursors.add(fieldsQueryCursor);
                Iterator iter = fieldsQueryCursor.iterator();
                iter.next();
            }
            QueryMemoryTrackerSelfTest.fail((String)"Exception not thrown.");
        }
        catch (SqlMemoryQuotaExceededException ex) {
            QueryMemoryTrackerSelfTest.assertTrue((boolean)ex.getMessage().contains("SQL query ran out of memory: Global quota was exceeded."));
            QueryMemoryTrackerSelfTest.assertEquals((int)3015, (int)ex.statusCode());
            QueryMemoryTrackerSelfTest.assertEquals((String)IgniteQueryErrorCode.codeToSqlState((int)3015), (String)ex.sqlState());
            QueryMemoryTrackerSelfTest.assertTrue((localResults.size() > 0 ? 1 : 0) != 0);
            QueryMemoryTrackerSelfTest.assertTrue((cursors.size() > 0 ? 1 : 0) != 0);
            IgniteH2Indexing igniteH2Indexing = (IgniteH2Indexing)this.grid(1).context().query().getIndexing();
            long globalAllocated = igniteH2Indexing.memoryManager().reserved();
            QueryMemoryTrackerSelfTest.assertTrue((igniteH2Indexing.memoryManager().memoryLimit() < globalAllocated + 0x100000L ? 1 : 0) != 0);
        }
        finally {
            for (QueryCursor queryCursor : cursors) {
                IgniteUtils.closeQuiet((AutoCloseable)queryCursor);
            }
        }
    }
}

