/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.oom;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.query.oom.DiskSpillingAbstractTest;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class DiskSpillingWithBaselineTest
extends DiskSpillingAbstractTest {
    @Override
    protected boolean persistence() {
        return true;
    }

    @Override
    protected int nodeCount() {
        return 3;
    }

    @Override
    protected void beforeTestsStarted() throws Exception {
    }

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.initGrid();
    }

    @Override
    protected void afterTest() throws Exception {
        this.destroyGrid();
    }

    @Test
    public void testSpillFilesDeletedOnConcurrentDeactivation() {
        DiskSpillingWithBaselineTest.assertEquals((int)this.nodeCount(), (int)this.grid(0).cluster().forServers().nodes().size());
        DiskSpillingWithBaselineTest.assertTrue((boolean)this.grid(0).cluster().active());
        DiskSpillingWithBaselineTest.assertEquals((int)this.grid(0).cluster().currentBaselineTopology().size(), (int)this.nodeCount());
        FieldsQueryCursor<List<?>> cur1 = this.getSpillableCursor("SELECT DISTINCT depId, code FROM person ORDER BY code");
        FieldsQueryCursor<List<?>> cur2 = this.getSpillableCursor("SELECT depId, age, COUNT(nulls), AVG(nulls), LISTAGG(nulls) FROM person GROUP BY age, depId");
        this.checkSpillFilesCreated(cur1);
        this.checkSpillFilesCreated(cur2);
        this.grid(0).cluster().active(false);
        this.checkSpillFilesDeletedOnClose(cur1);
        this.checkSpillFilesDeletedOnClose(cur2);
        this.assertWorkDirClean();
    }

    @Test
    public void testSpillFilesDeletedOnNewBaselineNodeExit() throws InterruptedException {
        DiskSpillingWithBaselineTest.assertEquals((int)this.nodeCount(), (int)this.grid(0).cluster().forServers().nodes().size());
        DiskSpillingWithBaselineTest.assertTrue((boolean)this.grid(0).cluster().active());
        DiskSpillingWithBaselineTest.assertEquals((int)this.grid(0).cluster().currentBaselineTopology().size(), (int)this.nodeCount());
        FieldsQueryCursor<List<?>> cur1 = this.getSpillableCursor("SELECT DISTINCT depId, code FROM person ORDER BY code");
        FieldsQueryCursor<List<?>> cur2 = this.getSpillableCursor("SELECT depId, age, COUNT(nulls), AVG(nulls), LISTAGG(nulls) FROM person GROUP BY age, depId");
        this.checkSpillFilesCreated(cur1);
        this.checkSpillFilesCreated(cur2);
        this.stopGrid(this.nodeCount() - 1);
        Collection aliveNodes = this.grid(0).cluster().forServers().nodes();
        this.grid(0).cluster().setBaselineTopology(aliveNodes);
        this.grid(0).resetLostPartitions(Collections.singleton("default"));
        this.awaitPartitionMapExchange();
        this.checkSpillFilesDeletedOnClose(cur1);
        this.checkSpillFilesDeletedOnClose(cur2);
        this.assertWorkDirClean();
    }

    @Test
    public void testSpillFilesDeletedOnNewBaselineNodeEnter() throws Exception {
        DiskSpillingWithBaselineTest.assertEquals((int)this.nodeCount(), (int)this.grid(0).cluster().forServers().nodes().size());
        DiskSpillingWithBaselineTest.assertTrue((boolean)this.grid(0).cluster().active());
        DiskSpillingWithBaselineTest.assertEquals((int)this.grid(0).cluster().currentBaselineTopology().size(), (int)this.nodeCount());
        FieldsQueryCursor<List<?>> cur1 = this.getSpillableCursor("SELECT DISTINCT depId, code FROM person ORDER BY code");
        FieldsQueryCursor<List<?>> cur2 = this.getSpillableCursor("SELECT depId, age, COUNT(nulls), AVG(nulls), LISTAGG(nulls) FROM person GROUP BY age, depId");
        this.checkSpillFilesCreated(cur1);
        this.checkSpillFilesCreated(cur2);
        this.startGrid(this.nodeCount());
        Collection aliveNodes = this.grid(0).cluster().forServers().nodes();
        this.grid(0).cluster().setBaselineTopology(aliveNodes);
        this.awaitPartitionMapExchange();
        this.checkSpillFilesDeletedOnClose(cur1);
        this.checkSpillFilesDeletedOnClose(cur2);
        this.assertWorkDirClean();
    }

    @Test
    public void testSpillFilesDeletedOnCacheDestroy() throws Exception {
        DiskSpillingWithBaselineTest.assertEquals((int)this.nodeCount(), (int)this.grid(0).cluster().forServers().nodes().size());
        DiskSpillingWithBaselineTest.assertTrue((boolean)this.grid(0).cluster().active());
        DiskSpillingWithBaselineTest.assertEquals((int)this.grid(0).cluster().currentBaselineTopology().size(), (int)this.nodeCount());
        FieldsQueryCursor<List<?>> cur1 = this.getSpillableCursor("SELECT DISTINCT depId, code FROM person ORDER BY code");
        FieldsQueryCursor<List<?>> cur2 = this.getSpillableCursor("SELECT depId, age, COUNT(nulls), AVG(nulls), LISTAGG(nulls) FROM person GROUP BY age, depId");
        this.checkSpillFilesCreated(cur1);
        this.checkSpillFilesCreated(cur2);
        for (String cacheName : this.grid(0).cacheNames()) {
            if (!cacheName.contains("SQL")) continue;
            this.grid(0).cache(cacheName).destroy();
        }
        this.checkSpillFilesDeletedOnClose(cur1);
        this.checkSpillFilesDeletedOnClose(cur2);
        this.assertWorkDirClean();
    }

    private FieldsQueryCursor<List<?>> getSpillableCursor(String qry) {
        return this.grid(0).cache("default").query(new SqlFieldsQueryEx(qry, null).setMaxMemory(4096L).setLazy(true));
    }

    private void checkSpillFilesCreated(FieldsQueryCursor<List<?>> cur) {
        WatchService watchSvc = null;
        try {
            Path workDir = this.getWorkDir();
            watchSvc = FileSystems.getDefault().newWatchService();
            WatchKey watchKey = workDir.register(watchSvc, StandardWatchEventKinds.ENTRY_CREATE);
            watchKey.reset();
            Iterator it = cur.iterator();
            DiskSpillingWithBaselineTest.assertTrue((boolean)it.hasNext());
            DiskSpillingWithBaselineTest.assertNotNull(it.next());
            DiskSpillingWithBaselineTest.assertTrue((boolean)it.hasNext());
            List<WatchEvent<?>> dirEvts = watchKey.pollEvents();
            DiskSpillingWithBaselineTest.assertFalse((String)"Disk events is empty. ", (boolean)dirEvts.isEmpty());
            List<String> nodeUuids = this.getNodesFromEvents(dirEvts);
            DiskSpillingWithBaselineTest.assertEquals((String)"Offload didn't happen on all nodes.", (int)this.nodeCount(), (int)nodeUuids.size());
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                U.closeQuiet(watchSvc);
                throw throwable;
            }
        }
        U.closeQuiet((AutoCloseable)watchSvc);
    }

    private List<String> getNodesFromEvents(List<WatchEvent<?>> evts) {
        return evts.stream().map(e -> e.context().toString().split("_")[1]).distinct().collect(Collectors.toList());
    }

    private void checkSpillFilesDeletedOnClose(FieldsQueryCursor<List<?>> cur) {
        WatchService watchSvc = null;
        try {
            Path workDir = this.getWorkDir();
            watchSvc = FileSystems.getDefault().newWatchService();
            WatchKey watchKey = workDir.register(watchSvc, StandardWatchEventKinds.ENTRY_DELETE);
            watchKey.reset();
            cur.close();
            GridTestUtils.waitForCondition(() -> !watchKey.pollEvents().isEmpty(), (long)1000L);
        }
        catch (IOException | IgniteInterruptedCheckedException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                U.closeQuiet(watchSvc);
                throw throwable;
            }
        }
        U.closeQuiet((AutoCloseable)watchSvc);
    }
}

