/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.oom;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.query.oom.DiskSpillingAbstractTest;
import org.junit.Test;

public class DiskSpillingGlobalQuotaTest
extends DiskSpillingAbstractTest {
    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.getSqlConfiguration().setSqlGlobalMemoryQuota("16k");
        return cfg;
    }

    @Test
    public void testGlobalQuotaCausesDiskSpilling() throws IOException {
        String qry = "SELECT DISTINCT *  FROM person p, department d  WHERE p.depId = d.id";
        this.checkGlobalQuota(qry);
    }

    @Test
    public void testGlobalQuotaCauseDiskSpillingForGroups() throws IOException {
        String qry = "SELECT weight, MAX(temperature), AVG(temperature), SUM(temperature) FROM person p GROUP BY weight ";
        this.checkGlobalQuota(qry);
    }

    private void checkGlobalQuota(String qry) throws IOException {
        Path workDir = this.getWorkDir();
        WatchService watchSvc = FileSystems.getDefault().newWatchService();
        WatchKey watchKey = workDir.register(watchSvc, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
        this.grid(0).cache("default").query(new SqlFieldsQuery(qry)).getAll();
        List<WatchEvent<?>> dirEvts = watchKey.pollEvents();
        DiskSpillingGlobalQuotaTest.assertFalse((boolean)dirEvts.isEmpty());
        this.assertWorkDirClean();
        this.checkMemoryManagerState();
    }
}

