/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.oom;

import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.internal.processors.query.oom.DiskSpillingAbstractTest;

public abstract class AbstractMemoryQuotaStaticConfigurationTest
extends DiskSpillingAbstractTest {
    private Boolean offloadingEnabled;
    private String globalQuota;
    private String qryQuota;

    @Override
    protected boolean persistence() {
        return false;
    }

    @Override
    protected int nodeCount() {
        return 1;
    }

    @Override
    protected void beforeTestsStarted() throws Exception {
    }

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.offloadingEnabled = null;
        this.globalQuota = null;
        this.qryQuota = null;
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        this.destroyGrid();
    }

    @Override
    protected boolean startClient() {
        return false;
    }

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setSqlConfiguration(new SqlConfiguration().setSqlOffloadingEnabled(false).setSqlQueryMemoryQuota("0").setSqlGlobalMemoryQuota("60%"));
        if (this.offloadingEnabled != null) {
            cfg.getSqlConfiguration().setSqlOffloadingEnabled(this.offloadingEnabled.booleanValue());
        }
        if (this.globalQuota != null) {
            cfg.getSqlConfiguration().setSqlGlobalMemoryQuota(this.globalQuota);
        }
        if (this.qryQuota != null) {
            cfg.getSqlConfiguration().setSqlQueryMemoryQuota(this.qryQuota);
        }
        return cfg;
    }

    protected void initGrid(String globalQuota, String queryQuota, Boolean offloadingEnabled) throws Exception {
        this.globalQuota = globalQuota;
        this.qryQuota = queryQuota;
        this.offloadingEnabled = offloadingEnabled;
        this.initGrid();
    }
}

