/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.List;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.h2.twostep.AbstractPartitionPruningBaseTest;
import org.junit.Test;

public class MvccDmlPartitionPruningSelfTest
extends AbstractPartitionPruningBaseTest {
    private static final int ROWS = 10;
    private boolean recreateTables;

    @Test
    public void testUpdate() {
        this.recreateTables = false;
        this.recreateTables();
        this.execute("UPDATE t1 SET v1 = 'new1' WHERE k1 = ?", res -> {
            MvccDmlPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1"));
            MvccDmlPartitionPruningSelfTest.assertNodes(this.node("t1", "1"));
            MvccDmlPartitionPruningSelfTest.assertUpdatedRows(res, 1L);
        }, "1");
        this.execute("UPDATE t1 SET v1 = 'new2' WHERE _KEY = ?", res -> {
            MvccDmlPartitionPruningSelfTest.assertPartitions(this.partition("t1", "2"));
            MvccDmlPartitionPruningSelfTest.assertNodes(this.node("t1", "2"));
            MvccDmlPartitionPruningSelfTest.assertUpdatedRows(res, 1L);
        }, "2");
        this.execute("UPDATE t2 SET v2 = 'new1' WHERE k2 = ?", res -> {
            MvccDmlPartitionPruningSelfTest.assertNoPartitions();
            MvccDmlPartitionPruningSelfTest.assertUpdatedRows(res, 1L);
        }, "1");
        this.execute("UPDATE t2 SET v2 = 'new1' WHERE ak2 = ?", res -> {
            MvccDmlPartitionPruningSelfTest.assertPartitions(this.partition("t2", "1"));
            MvccDmlPartitionPruningSelfTest.assertNodes(this.node("t2", "1"));
            MvccDmlPartitionPruningSelfTest.assertUpdatedRows(res, 1L);
        }, "1");
        this.execute("UPDATE t1 SET v1 = 'new1' WHERE k1 in (?, ?, ?)", res -> {
            MvccDmlPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1"), this.partition("t1", "2"), this.partition("t1", "3"));
            MvccDmlPartitionPruningSelfTest.assertNodes(this.node("t1", "1"), this.node("t1", "2"), this.node("t1", "3"));
            MvccDmlPartitionPruningSelfTest.assertUpdatedRows(res, 3L);
        }, "1", "2", "3");
        this.execute("UPDATE t1 SET v1 = 'new1' WHERE k1 in (?, ?) or k1 = ?", res -> {
            MvccDmlPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1"), this.partition("t1", "2"), this.partition("t1", "3"));
            MvccDmlPartitionPruningSelfTest.assertNodes(this.node("t1", "1"), this.node("t1", "2"), this.node("t1", "3"));
            MvccDmlPartitionPruningSelfTest.assertUpdatedRows(res, 3L);
        }, "3", "2", "1");
        this.execute("UPDATE t1 SET v1 = 'new1' WHERE k1 in (?, ?) and k1 = ?", res -> {
            MvccDmlPartitionPruningSelfTest.assertNoRequests();
            MvccDmlPartitionPruningSelfTest.assertUpdatedRows(res, 0L);
        }, "3", "2", "1");
        BinaryObject key = this.client().binary().builder("t2_key").setField("k1", (Object)"5").setField("ak2", (Object)"5").build();
        List<List<?>> res2 = this.executeSingle("UPDATE t2 SET v2 = 'new1' WHERE _KEY = ?", key);
        MvccDmlPartitionPruningSelfTest.assertPartitions(this.partition("t2", "5"));
        MvccDmlPartitionPruningSelfTest.assertNodes(this.node("t2", "5"));
        MvccDmlPartitionPruningSelfTest.assertUpdatedRows(res2, 1L);
    }

    @Test
    public void testDelete() {
        this.recreateTables = true;
        this.execute("DELETE FROM t1 WHERE k1 in (?, ?, ?)", res -> {
            MvccDmlPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1"), this.partition("t1", "2"), this.partition("t1", "3"));
            MvccDmlPartitionPruningSelfTest.assertNodes(this.node("t1", "1"), this.node("t1", "2"), this.node("t1", "3"));
            MvccDmlPartitionPruningSelfTest.assertUpdatedRows(res, 3L);
        }, "1", "2", "3");
        this.execute("DELETE FROM t1 WHERE k1 in (?, ?) or k1 = ?", res -> {
            MvccDmlPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1"), this.partition("t1", "2"), this.partition("t1", "3"));
            MvccDmlPartitionPruningSelfTest.assertNodes(this.node("t1", "1"), this.node("t1", "2"), this.node("t1", "3"));
            MvccDmlPartitionPruningSelfTest.assertUpdatedRows(res, 3L);
        }, "3", "2", "1");
        this.execute("DELETE FROM t1  WHERE k1 in (?, ?) and k1 = ?", res -> {
            MvccDmlPartitionPruningSelfTest.assertNoRequests();
            MvccDmlPartitionPruningSelfTest.assertUpdatedRows(res, 0L);
        }, "3", "2", "1");
    }

    private void recreateTables() {
        IgniteEx cli = this.client();
        cli.destroyCaches(cli.cacheNames());
        this.createPartitionedTable(true, "t1", this.pkColumn("k1"), "v1");
        this.createPartitionedTable(true, "t2", this.pkColumn("k2"), this.affinityColumn("ak2"), "v2");
        for (int i = 0; i < 10; ++i) {
            this.executeSql("INSERT INTO t1 VALUES (?, ?)", Integer.toString(i), Integer.toString(i));
            this.executeSql("INSERT INTO t2 VALUES (?, ?, ?)", Integer.toString(i), Integer.toString(i), Integer.toString(i));
        }
    }

    @Override
    protected List<List<?>> executeSingle(String sql, Object ... args) {
        if (this.recreateTables) {
            this.recreateTables();
        }
        return super.executeSingle(sql, args);
    }

    private static void assertUpdatedRows(List<List<?>> res, long expUpdated) {
        MvccDmlPartitionPruningSelfTest.assertEquals((int)1, (int)res.size());
        MvccDmlPartitionPruningSelfTest.assertEquals((Object)expUpdated, res.get(0).get(0));
    }
}

