/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.query.QueryCursorEx;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class ParameterTypeInferenceTest
extends GridCommonAbstractTest {
    private static final TcpDiscoveryVmIpFinder IP_FINDER = new TcpDiscoveryVmIpFinder(true);
    private static final String CACHE_NAME = "cache";
    private static final int NODE_CNT = 2;

    protected IgniteConfiguration getConfiguration(String name) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(name);
        cfg.setLocalHost("127.0.0.1");
        cfg.setDiscoverySpi((DiscoverySpi)new TcpDiscoverySpi().setIpFinder((TcpDiscoveryIpFinder)IP_FINDER));
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        IgniteEx node = this.startGrids(2);
        QueryEntity qryEntity = new QueryEntity(InferenceKey.class, InferenceValue.class).setTableName(CACHE_NAME);
        IgniteCache cache = node.createCache(new CacheConfiguration().setName(CACHE_NAME).setQueryEntities(Collections.singletonList(qryEntity)));
        for (int i = 0; i < 10; ++i) {
            cache.put((Object)new InferenceKey(i), (Object)new InferenceValue(i));
        }
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
    }

    protected void afterTest() throws Exception {
        this.clearParserCache();
    }

    @Test
    public void testInferenceLocal() {
        this.check("SELECT ? FROM cache", true);
        this.check("SELECT ? FROM cache ORDER BY val", true);
    }

    @Test
    public void testInferenceNoReduce() {
        this.check("SELECT ? FROM cache", false);
    }

    @Test
    public void testInferenceReduce() {
        this.check("SELECT ? FROM cache ORDER BY val", false);
    }

    private void check(String qry, boolean loc) {
        ArrayList<Object> argss = new ArrayList<Object>();
        argss.add(new Object[]{null});
        argss.add(new Object[]{"STRING"});
        argss.add(new Object[]{1});
        argss.add(new Object[]{1L});
        argss.add(new Object[]{new BigDecimal("12.12")});
        argss.add(new Object[]{UUID.randomUUID()});
        this.clearParserCache();
        for (int i = 0; i < argss.size(); ++i) {
            for (Object[] objectArray : argss) {
                for (int j = 0; j < 2; ++j) {
                    SqlFieldsQuery qry0 = new SqlFieldsQuery(qry).setLocal(loc).setArgs(objectArray);
                    try (QueryCursorEx cur = (QueryCursorEx)this.grid(0).cache(CACHE_NAME).query(qry0);){
                        GridQueryFieldMetadata meta = (GridQueryFieldMetadata)cur.fieldsMeta().get(0);
                        cur.getAll();
                        String errMsg = "Failure on i=" + i + ", j=" + j + ": " + meta.fieldTypeName();
                        ParameterTypeInferenceTest.assertEquals((String)errMsg, (String)Object.class.getName(), (String)meta.fieldTypeName());
                        continue;
                    }
                }
            }
            argss.add(argss.remove(0));
        }
    }

    private void clearParserCache() {
        for (int i = 0; i < 2; ++i) {
            ((IgniteH2Indexing)this.grid(i).context().query().getIndexing()).parser().clearCache();
        }
    }

    private static class InferenceValue {
        @QuerySqlField
        private int val;

        private InferenceValue(int val) {
            this.val = val;
        }
    }

    private static class InferenceKey {
        @QuerySqlField
        private int key;

        private InferenceKey(int key) {
            this.key = key;
        }
    }
}

