/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.maintenance;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.internal.processors.query.h2.maintenance.MaintenanceRebuildIndexTarget;
import org.apache.ignite.internal.processors.query.h2.maintenance.MaintenanceRebuildIndexUtils;
import org.apache.ignite.maintenance.MaintenanceTask;
import org.junit.Assert;
import org.junit.Test;

public class MaintenanceRebuildIndexUtilsSelfTest {
    @Test
    public void testSerializeAndParse() {
        int cacheId = 1;
        String idxName = "test";
        MaintenanceTask task = MaintenanceRebuildIndexUtils.toMaintenanceTask((int)cacheId, (String)idxName);
        Assert.assertEquals((Object)"indexRebuildMaintenanceTask", (Object)task.name());
        List targets = MaintenanceRebuildIndexUtils.parseMaintenanceTaskParameters((String)task.parameters());
        Assert.assertEquals((long)1L, (long)targets.size());
        MaintenanceRebuildIndexTarget target = (MaintenanceRebuildIndexTarget)targets.get(0);
        Assert.assertEquals((long)cacheId, (long)target.cacheId());
        Assert.assertEquals((Object)idxName, (Object)target.idxName());
    }

    @Test
    public void testMerge() {
        List targets = IntStream.range(0, 100).mapToObj(i -> new MaintenanceRebuildIndexTarget(i, "idx" + i)).collect(Collectors.toList());
        MaintenanceRebuildIndexTarget first = (MaintenanceRebuildIndexTarget)targets.get(0);
        MaintenanceTask task = MaintenanceRebuildIndexUtils.toMaintenanceTask((int)first.cacheId(), (String)first.idxName());
        for (MaintenanceRebuildIndexTarget target : targets) {
            task = MaintenanceRebuildIndexUtils.mergeTasks((MaintenanceTask)task, (MaintenanceTask)MaintenanceRebuildIndexUtils.toMaintenanceTask((int)target.cacheId(), (String)target.idxName()));
        }
        Assert.assertEquals((Object)"indexRebuildMaintenanceTask", (Object)task.name());
        List parsedTargets = MaintenanceRebuildIndexUtils.parseMaintenanceTaskParameters((String)task.parameters());
        Assert.assertEquals(targets, (Object)parsedTargets);
    }

    @Test
    public void testMergeSame() {
        int cacheId = 1;
        String idxName = "test";
        MaintenanceTask task1 = MaintenanceRebuildIndexUtils.toMaintenanceTask((int)cacheId, (String)idxName);
        MaintenanceTask task2 = MaintenanceRebuildIndexUtils.toMaintenanceTask((int)cacheId, (String)idxName);
        MaintenanceTask mergedTask = MaintenanceRebuildIndexUtils.mergeTasks((MaintenanceTask)task1, (MaintenanceTask)task2);
        Assert.assertEquals((Object)"indexRebuildMaintenanceTask", (Object)mergedTask.name());
        Assert.assertEquals((Object)task1.parameters(), (Object)mergedTask.parameters());
    }

    @Test
    public void testIndexNameWithSeparatorCharacter() {
        int cacheId = 1;
        String idxName = "test|test";
        MaintenanceTask task = MaintenanceRebuildIndexUtils.toMaintenanceTask((int)cacheId, (String)idxName);
        List targets = MaintenanceRebuildIndexUtils.parseMaintenanceTaskParameters((String)task.parameters());
        Assert.assertEquals((long)1L, (long)targets.size());
        MaintenanceRebuildIndexTarget target = (MaintenanceRebuildIndexTarget)targets.get(0);
        Assert.assertEquals((long)cacheId, (long)target.cacheId());
        Assert.assertEquals((Object)idxName, (Object)target.idxName());
    }
}

