/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ignite.Ignite;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public abstract class TableStatisticsAbstractTest
extends GridCommonAbstractTest {
    static final int BIG_SIZE = 1000;
    static final int MED_SIZE = 500;
    static final int SMALL_SIZE = 100;

    protected void checkOptimalPlanChosenForDifferentJoinOrders(Ignite grid, String sql, String ... tbls) {
        String directOrder = TableStatisticsAbstractTest.replaceTablePlaceholders(sql, tbls);
        if (log.isDebugEnabled()) {
            log.debug("Direct join order=" + directOrder);
        }
        this.ensureOptimalPlanChosen(grid, directOrder);
        List<String> dirOrdTbls = Arrays.asList(tbls);
        Collections.reverse(dirOrdTbls);
        String reversedOrder = TableStatisticsAbstractTest.replaceTablePlaceholders(sql, dirOrdTbls.toArray(new String[dirOrdTbls.size()]));
        if (log.isDebugEnabled()) {
            log.debug("Reversed join order=" + reversedOrder);
        }
        this.ensureOptimalPlanChosen(grid, reversedOrder);
    }

    private void ensureOptimalPlanChosen(Ignite grid, String sql) {
        int cntNoStats = this.runLocalExplainAnalyze(grid, true, sql);
        int cntStats = this.runLocalExplainAnalyze(grid, false, sql);
        String res = "Scanned rows count [noStats=" + cntNoStats + ", withStats=" + cntStats + ", diff=" + (cntNoStats - cntStats) + ']';
        if (log.isInfoEnabled()) {
            log.info(res);
        }
        TableStatisticsAbstractTest.assertTrue((String)res, (cntStats <= cntNoStats ? 1 : 0) != 0);
    }

    private int runLocalExplainAnalyze(Ignite grid, boolean enfJoinOrder, String sql) {
        List res = grid.cache("default").query((SqlFieldsQuery)new SqlFieldsQueryEx("EXPLAIN ANALYZE " + sql, null).setEnforceJoinOrder(enfJoinOrder).setLocal(true)).getAll();
        if (log.isDebugEnabled()) {
            log.debug("ExplainAnalyze enfJoinOrder=" + enfJoinOrder + ", res=" + res);
        }
        return this.extractScanCountFromExplain(res);
    }

    private int extractScanCountFromExplain(List<List<?>> res) {
        String explainRes = (String)res.get(0).get(0);
        Matcher m = Pattern.compile("scanCount: (?=(\\d+))").matcher(explainRes);
        int scanCnt = 0;
        while (m.find()) {
            scanCnt += Integer.valueOf(m.group(1)).intValue();
        }
        return scanCnt;
    }

    protected void runSql(String sql) {
        this.grid(0).cache("default").query(new SqlFieldsQuery(sql)).getAll();
    }

    private static String replaceTablePlaceholders(String sql, String ... tbls) {
        assert (!sql.contains("t0"));
        int i = 0;
        for (String tbl : tbls) {
            String tblPlaceHolder = "t" + ++i;
            assert (sql.contains(tblPlaceHolder));
            sql = sql.replace(tblPlaceHolder, tbl);
        }
        assert (!sql.contains("t" + (i + 1)));
        return sql;
    }

    static {
        TableStatisticsAbstractTest.assertTrue((boolean)true);
    }
}

