/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.tree.CacheDataTree;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.h2.H2PooledConnection;
import org.apache.ignite.internal.processors.query.h2.H2QueryInfo;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.testframework.MvccFeatureChecker;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.transactions.Transaction;
import org.jetbrains.annotations.Nullable;
import org.junit.Ignore;
import org.junit.Test;

public class QueryDataPageScanTest
extends GridCommonAbstractTest {
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
        return cfg;
    }

    protected void afterTestsStopped() throws Exception {
        this.cleanPersistenceDir();
    }

    protected void beforeTest() throws Exception {
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids(true);
    }

    @Test
    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-20800")
    public void testMultipleIndexedTypes() throws Exception {
        String cacheName = "test_multi_type";
        IgniteEx server = this.startGrid(0);
        server.cluster().active(true);
        CacheConfiguration ccfg = new CacheConfiguration("test_multi_type");
        ccfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 1));
        ccfg.setAtomicityMode(CacheAtomicityMode.ATOMIC);
        ccfg.setIndexedTypes(new Class[]{Integer.class, Integer.class, Long.class, String.class, Long.class, TestData.class});
        ccfg.setQueryEntities(Arrays.asList(new QueryEntity().setValueType(UUID.class.getName()).setKeyType(Integer.class.getName()).setTableName("Uuids"), new QueryEntity().setValueType(Person.class.getName()).setKeyType(Integer.class.getName()).setTableName("My_Persons").setFields(Person.getFields())));
        IgniteCache cache = server.createCache(ccfg);
        cache.put((Object)1L, (Object)"bla-bla");
        cache.put((Object)2L, (Object)new TestData(777L));
        cache.put((Object)3, (Object)3);
        cache.put((Object)7, (Object)UUID.randomUUID());
        cache.put((Object)9, (Object)new Person("Vasya", 99));
        CacheDataTree.isLastFindWithDataPageScan();
        List res = cache.query(new SqlFieldsQuery("select z, _key, _val from TestData use index()")).getAll();
        QueryDataPageScanTest.assertEquals((int)1, (int)res.size());
        QueryDataPageScanTest.assertEquals((Object)777L, ((List)res.get(0)).get(0));
        QueryDataPageScanTest.assertTrue((boolean)CacheDataTree.isLastFindWithDataPageScan());
        res = cache.query(new SqlFieldsQuery("select _val, _key from String use index()")).getAll();
        QueryDataPageScanTest.assertEquals((int)1, (int)res.size());
        QueryDataPageScanTest.assertEquals((Object)"bla-bla", ((List)res.get(0)).get(0));
        QueryDataPageScanTest.assertTrue((boolean)CacheDataTree.isLastFindWithDataPageScan());
        res = cache.query(new SqlFieldsQuery("select _key, _val from Integer use index()")).getAll();
        QueryDataPageScanTest.assertEquals((int)1, (int)res.size());
        QueryDataPageScanTest.assertEquals((Object)3, ((List)res.get(0)).get(0));
        QueryDataPageScanTest.assertTrue((boolean)CacheDataTree.isLastFindWithDataPageScan());
        res = cache.query(new SqlFieldsQuery("select _key, _val from uuids use index()")).getAll();
        QueryDataPageScanTest.assertEquals((int)1, (int)res.size());
        QueryDataPageScanTest.assertEquals((Object)7, ((List)res.get(0)).get(0));
        QueryDataPageScanTest.assertTrue((boolean)CacheDataTree.isLastFindWithDataPageScan());
        res = cache.query(new SqlFieldsQuery("select age, name from my_persons use index()")).getAll();
        QueryDataPageScanTest.assertEquals((int)1, (int)res.size());
        QueryDataPageScanTest.assertEquals((Object)99, ((List)res.get(0)).get(0));
        QueryDataPageScanTest.assertEquals((Object)"Vasya", ((List)res.get(0)).get(1));
        QueryDataPageScanTest.assertTrue((boolean)CacheDataTree.isLastFindWithDataPageScan());
    }

    @Test
    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-20800")
    public void testConcurrentUpdatesWithMvcc() throws Exception {
        this.doTestConcurrentUpdates(true);
    }

    @Test
    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-20800")
    public void testConcurrentUpdatesNoMvcc() throws Exception {
        try {
            this.doTestConcurrentUpdates(false);
            throw new IllegalStateException("Expected to detect data inconsistency.");
        }
        catch (AssertionError e) {
            QueryDataPageScanTest.assertTrue((boolean)((Throwable)((Object)e)).getMessage().startsWith("wrong sum!"));
            return;
        }
    }

    private void doTestConcurrentUpdates(boolean enableMvcc) throws Exception {
        String cacheName = "test_updates";
        IgniteEx server = this.startGrid(0);
        server.cluster().active(true);
        CacheConfiguration ccfg = new CacheConfiguration("test_updates");
        ccfg.setIndexedTypes(new Class[]{Long.class, Long.class});
        ccfg.setAtomicityMode(enableMvcc ? CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT : CacheAtomicityMode.TRANSACTIONAL);
        IgniteCache cache = server.createCache(ccfg);
        long accounts = 100L;
        long initialBalance = 100L;
        for (long i = 0L; i < accounts; ++i) {
            cache.put((Object)i, (Object)initialBalance);
        }
        QueryDataPageScanTest.assertEquals((long)(accounts * initialBalance), (long)((Number)((List)cache.query(new SqlFieldsQuery("select sum(_val) from Long use index()")).getAll().get(0)).get(0)).longValue());
        QueryDataPageScanTest.assertTrue((boolean)CacheDataTree.isLastFindWithDataPageScan());
        AtomicBoolean cancel = new AtomicBoolean();
        IgniteInternalFuture updFut = this.multithreadedAsync(() -> {
            ThreadLocalRandom rnd = ThreadLocalRandom.current();
            while (!cancel.get() && !Thread.interrupted()) {
                long accountId2;
                long accountId1 = ((Random)rnd).nextInt((int)accounts);
                if (accountId1 == (accountId2 = (long)((Random)rnd).nextInt((int)accounts))) continue;
                if (accountId1 > accountId2) {
                    long tmp = accountId1;
                    accountId1 = accountId2;
                    accountId2 = tmp;
                }
                try {
                    Transaction tx = server.transactions().txStart();
                    Throwable throwable = null;
                    try {
                        long transfer;
                        long balance1 = (Long)cache.get((Object)accountId1);
                        long balance2 = (Long)cache.get((Object)accountId2);
                        if (balance1 <= balance2) {
                            if (balance2 == 0L) continue;
                            transfer = ((Random)rnd).nextInt((int)balance2);
                            if (transfer == 0L) {
                                transfer = balance2;
                            }
                            balance1 += transfer;
                            balance2 -= transfer;
                        } else {
                            transfer = ((Random)rnd).nextInt((int)balance1);
                            if (transfer == 0L) {
                                transfer = balance1;
                            }
                            balance1 -= transfer;
                            balance2 += transfer;
                        }
                        cache.put((Object)accountId1, (Object)balance1);
                        cache.put((Object)accountId2, (Object)balance2);
                        tx.commit();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tx == null) continue;
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        tx.close();
                    }
                }
                catch (CacheException e) {
                    MvccFeatureChecker.assertMvccWriteConflict((Exception)((Object)e));
                    if (e.getMessage().contains("Cannot serialize transaction due to write conflict (transaction is marked for rollback)")) continue;
                    throw new IllegalStateException(e);
                }
            }
        }, 16, "updater");
        IgniteInternalFuture qryFut = this.multithreadedAsync(() -> {
            while (!cancel.get() && !Thread.interrupted()) {
                QueryDataPageScanTest.assertEquals((String)"wrong sum!", (long)(accounts * initialBalance), (long)((Number)((List)cache.query(new SqlFieldsQuery("select sum(_val) from Long use index()")).getAll().get(0)).get(0)).longValue());
            }
        }, 2, "query");
        qryFut.listen((IgniteInClosure & Serializable)f -> cancel.set(true));
        updFut.listen((IgniteInClosure & Serializable)f -> cancel.set(true));
        long start = U.currentTimeMillis();
        while (!cancel.get() && U.currentTimeMillis() - start < 15000L) {
            QueryDataPageScanTest.doSleep((long)100L);
        }
        cancel.set(true);
        qryFut.get(3000L);
        updFut.get(1L);
    }

    @Test
    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-20800")
    public void testDataPageScan() throws Exception {
        String cacheName = "test";
        GridQueryProcessor.idxCls = DirectPageScanIndexing.class;
        IgniteEx server = this.startGrid(0);
        server.cluster().active(true);
        Ignition.setClientMode((boolean)true);
        IgniteEx client = this.startGrid(1);
        CacheConfiguration ccfg = new CacheConfiguration("test");
        ccfg.setIndexedTypes(new Class[]{Long.class, TestData.class});
        ccfg.setSqlFunctionClasses(new Class[]{QueryDataPageScanTest.class});
        IgniteCache clientCache = client.createCache(ccfg);
        int keysCnt = 1000;
        for (long i = 0L; i < 1000L; ++i) {
            clientCache.put((Object)i, (Object)new TestData(i));
        }
        IgniteCache serverCache = server.cache("test");
        this.doTestScanQuery((IgniteCache<Long, TestData>)clientCache, 1000);
        this.doTestScanQuery((IgniteCache<Long, TestData>)serverCache, 1000);
        this.doTestSqlQuery((IgniteCache<Long, TestData>)clientCache);
        this.doTestSqlQuery((IgniteCache<Long, TestData>)serverCache);
        this.doTestDml((IgniteCache<Long, TestData>)clientCache);
        this.doTestDml((IgniteCache<Long, TestData>)serverCache);
        this.doTestLazySql((IgniteCache<Long, TestData>)clientCache, 1000);
        this.doTestLazySql((IgniteCache<Long, TestData>)serverCache, 1000);
    }

    private void doTestLazySql(IgniteCache<Long, TestData> cache, int keysCnt) {
        this.checkLazySql(cache, false, keysCnt);
        this.checkLazySql(cache, true, keysCnt);
        this.checkLazySql(cache, null, keysCnt);
    }

    private void checkLazySql(IgniteCache<Long, TestData> cache, Boolean dataPageScanEnabled, int keysCnt) {
        CacheDataTree.isLastFindWithDataPageScan();
        DirectPageScanIndexing.expectedDataPageScanEnabled = dataPageScanEnabled;
        int expNestedLoops = 5;
        try (FieldsQueryCursor cursor = cache.query(new SqlFieldsQuery("select 1 from TestData a use index(), TestData b use index() where a.z between ? and ? and check_scan_flag(?,true)").setLazy(true).setArgs(new Object[]{1, 5, DirectPageScanIndexing.expectedDataPageScanEnabled}).setPageSize(keysCnt / 10));){
            int nestedLoops = 0;
            int rowCnt = 0;
            for (List row : cursor) {
                if (dataPageScanEnabled == Boolean.FALSE) {
                    QueryDataPageScanTest.assertNull((Object)CacheDataTree.isLastFindWithDataPageScan());
                } else {
                    Boolean x = CacheDataTree.isLastFindWithDataPageScan();
                    if (x != null) {
                        QueryDataPageScanTest.assertTrue((boolean)x);
                        ++nestedLoops;
                    }
                }
                ++rowCnt;
            }
            QueryDataPageScanTest.assertEquals((int)(keysCnt * 5), (int)rowCnt);
            QueryDataPageScanTest.assertEquals((int)(dataPageScanEnabled == Boolean.FALSE ? 0 : 5), (int)nestedLoops);
        }
    }

    private void doTestDml(IgniteCache<Long, TestData> cache) {
        DirectPageScanIndexing.callsCnt.set(0);
        int callsCnt = 0;
        this.checkDml(cache, null);
        QueryDataPageScanTest.assertEquals((int)(++callsCnt), (int)DirectPageScanIndexing.callsCnt.get());
        this.checkDml(cache, true);
        QueryDataPageScanTest.assertEquals((int)(++callsCnt), (int)DirectPageScanIndexing.callsCnt.get());
        this.checkDml(cache, false);
        QueryDataPageScanTest.assertEquals((int)(++callsCnt), (int)DirectPageScanIndexing.callsCnt.get());
        this.checkDml(cache, null);
        QueryDataPageScanTest.assertEquals((int)(++callsCnt), (int)DirectPageScanIndexing.callsCnt.get());
    }

    private void checkDml(IgniteCache<Long, TestData> cache, Boolean dataPageScanEnabled) {
        DirectPageScanIndexing.expectedDataPageScanEnabled = dataPageScanEnabled;
        QueryDataPageScanTest.assertEquals((Object)0L, ((List)cache.query(new SqlFieldsQuery("update TestData set z = z + 1 where check_scan_flag(?,false)").setArgs(new Object[]{DirectPageScanIndexing.expectedDataPageScanEnabled})).getAll().get(0)).get(0));
        this.checkSqlLastFindDataPageScan(dataPageScanEnabled);
    }

    private void checkSqlLastFindDataPageScan(Boolean dataPageScanEnabled) {
        if (dataPageScanEnabled == Boolean.FALSE) {
            QueryDataPageScanTest.assertNull((Object)CacheDataTree.isLastFindWithDataPageScan());
        } else {
            QueryDataPageScanTest.assertTrue((boolean)CacheDataTree.isLastFindWithDataPageScan());
        }
    }

    private void doTestSqlQuery(IgniteCache<Long, TestData> cache) {
        DirectPageScanIndexing.callsCnt.set(0);
        int callsCnt = 0;
        this.checkSqlQuery(cache, null);
        QueryDataPageScanTest.assertEquals((int)(++callsCnt), (int)DirectPageScanIndexing.callsCnt.get());
        this.checkSqlQuery(cache, true);
        QueryDataPageScanTest.assertEquals((int)(++callsCnt), (int)DirectPageScanIndexing.callsCnt.get());
        this.checkSqlQuery(cache, false);
        QueryDataPageScanTest.assertEquals((int)(++callsCnt), (int)DirectPageScanIndexing.callsCnt.get());
        this.checkSqlQuery(cache, null);
        QueryDataPageScanTest.assertEquals((int)(++callsCnt), (int)DirectPageScanIndexing.callsCnt.get());
    }

    private void checkSqlQuery(IgniteCache<Long, TestData> cache, Boolean dataPageScanEnabled) {
        DirectPageScanIndexing.expectedDataPageScanEnabled = dataPageScanEnabled;
        QueryDataPageScanTest.assertTrue((boolean)cache.query((Query)new SqlQuery(TestData.class, "from TestData use index() where check_scan_flag(?,false)").setArgs(new Object[]{DirectPageScanIndexing.expectedDataPageScanEnabled})).getAll().isEmpty());
        this.checkSqlLastFindDataPageScan(dataPageScanEnabled);
    }

    private void doTestScanQuery(IgniteCache<Long, TestData> cache, int keysCnt) {
        TestPredicate.callsCnt.set(0);
        int callsCnt = 0;
        QueryDataPageScanTest.assertTrue((boolean)cache.query((Query)new ScanQuery((IgniteBiPredicate)new TestPredicate())).getAll().isEmpty());
        QueryDataPageScanTest.assertFalse((boolean)CacheDataTree.isLastFindWithDataPageScan());
        QueryDataPageScanTest.assertEquals((int)(callsCnt += keysCnt), (int)TestPredicate.callsCnt.get());
        this.checkScanQuery(cache, true, true);
        QueryDataPageScanTest.assertEquals((int)(callsCnt += keysCnt), (int)TestPredicate.callsCnt.get());
        this.checkScanQuery(cache, false, false);
        QueryDataPageScanTest.assertEquals((int)(callsCnt += keysCnt), (int)TestPredicate.callsCnt.get());
        this.checkScanQuery(cache, true, true);
        QueryDataPageScanTest.assertEquals((int)(callsCnt += keysCnt), (int)TestPredicate.callsCnt.get());
        this.checkScanQuery(cache, null, false);
        QueryDataPageScanTest.assertEquals((int)(callsCnt += keysCnt), (int)TestPredicate.callsCnt.get());
    }

    private void checkScanQuery(IgniteCache<Long, TestData> cache, Boolean dataPageScanEnabled, Boolean expLastDataPageScan) {
        QueryDataPageScanTest.assertTrue((boolean)cache.query((Query)new ScanQuery((IgniteBiPredicate)new TestPredicate())).getAll().isEmpty());
        QueryDataPageScanTest.assertEquals((Object)expLastDataPageScan, (Object)CacheDataTree.isLastFindWithDataPageScan());
    }

    @QuerySqlFunction(alias="check_scan_flag")
    public static boolean checkScanFlagFromSql(Boolean exp, boolean res) {
        QueryDataPageScanTest.assertEquals((exp != Boolean.FALSE ? 1 : 0) != 0, (boolean)CacheDataTree.isDataPageScanEnabled());
        return res;
    }

    static class Person
    implements Externalizable {
        String name;
        int age;

        public Person() {
        }

        Person(String name, int age) {
            this.name = Objects.requireNonNull(name);
            this.age = age;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.name);
            out.writeInt(this.age);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.name = in.readUTF();
            this.age = in.readInt();
        }

        static LinkedHashMap<String, String> getFields() {
            LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
            m.put("age", "INT");
            m.put("name", "VARCHAR");
            return m;
        }
    }

    static class TestData
    implements Serializable {
        static final long serialVersionUID = 42L;
        @QuerySqlField
        long z;

        TestData(long z) {
            this.z = z;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestData testData = (TestData)o;
            return this.z == testData.z;
        }

        public int hashCode() {
            return (int)(this.z ^ this.z >>> 32);
        }
    }

    static class TestPredicate
    implements IgniteBiPredicate<Long, TestData> {
        static final AtomicInteger callsCnt = new AtomicInteger();

        TestPredicate() {
        }

        public boolean apply(Long k, TestData v) {
            callsCnt.incrementAndGet();
            return false;
        }
    }

    static class DirectPageScanIndexing
    extends IgniteH2Indexing {
        static volatile Boolean expectedDataPageScanEnabled;
        static final AtomicInteger callsCnt;

        DirectPageScanIndexing() {
        }

        public ResultSet executeSqlQueryWithTimer(PreparedStatement stmt, H2PooledConnection conn, String sql, int timeoutMillis, @Nullable GridQueryCancel cancel, Boolean dataPageScanEnabled, H2QueryInfo qryInfo, long maxMem) throws IgniteCheckedException {
            callsCnt.incrementAndGet();
            QueryDataPageScanTest.assertEquals((Object)DirectPageScanIndexing.expectedDataPageScanEnabled, (Object)dataPageScanEnabled);
            return super.executeSqlQueryWithTimer(stmt, conn, sql, timeoutMillis, cancel, dataPageScanEnabled, qryInfo, maxMem);
        }

        static {
            callsCnt = new AtomicInteger();
        }
    }
}

