/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Set;
import javax.management.ObjectName;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.spi.metric.MetricExporterSpi;
import org.apache.ignite.spi.metric.jmx.JmxMetricExporterSpi;
import org.junit.Test;

public class QueryJmxMetricsTest
extends AbstractIndexingCommonTest {
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setMetricExporterSpi(new MetricExporterSpi[]{new JmxMetricExporterSpi()});
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.startGrid();
        this.fillGrid();
    }

    private void fillGrid() {
        this.grid().createCache(new CacheConfiguration().setName("test0").setGroupName("grp0"));
        this.grid().createCache(new CacheConfiguration().setName("test1"));
        this.grid().context().query().querySqlFields(new SqlFieldsQuery("CREATE TABLE TEST (ID INT PRIMARY KEY, VAL VARCHAR)"), false);
        for (int i = 0; i < 10; ++i) {
            this.grid().cache("test0").put((Object)i, (Object)("val" + i));
            this.grid().cache("test1").put((Object)("key" + i), (Object)i);
            this.grid().context().query().querySqlFields(new SqlFieldsQuery("INSERT INTO  TEST VALUES (?, ?)").setArgs(new Object[]{i, "val" + i}), false);
        }
        this.grid().context().query().querySqlFields(new SqlFieldsQuery("SELECT * FROM TEST"), false).getAll();
        this.grid().context().query().querySqlFields(new SqlFieldsQuery("CREATE INDEX IDX0 ON TEST(VAL)"), false).getAll();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    @Test
    public void testJmxAllMBeanInfo() throws Exception {
        Set<ObjectName> names = this.grid().configuration().getMBeanServer().queryNames(new ObjectName("*:*"), null);
        log.info("Available beans: " + names.size());
        boolean errors = false;
        for (ObjectName name : names) {
            try {
                this.grid().configuration().getMBeanServer().getMBeanInfo(name);
            }
            catch (Exception e) {
                log.error("Error on: " + name.getCanonicalName(), (Throwable)e);
                errors = true;
            }
        }
        QueryJmxMetricsTest.assertFalse((String)"There are errors at the MBeanInfo creation, see log above", (boolean)errors);
    }
}

