/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.TestRecordingCommunicationSpi;
import org.apache.ignite.internal.managers.discovery.CustomMessageWrapper;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.schema.message.SchemaFinishDiscoveryMessage;
import org.apache.ignite.internal.processors.query.schema.message.SchemaOperationStatusMessage;
import org.apache.ignite.internal.processors.query.schema.operation.SchemaIndexCreateOperation;
import org.apache.ignite.internal.util.lang.ConsumerX;
import org.apache.ignite.internal.util.lang.GridFunc;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.DiscoverySpiCustomMessage;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryAbstractMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryCustomEventMessage;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.internal.h2.index.Index;
import org.junit.Test;

public class IndexWithSameNameTest
extends GridCommonAbstractTest {
    public static final String TEST_INDEX = "TEST_IDX";
    public static final int BASELINE_SIZE = 3;
    public static final int NODES_COUNT = 5;
    public static final int CLIENT_INDEX = 4;
    public static final Set<String> CORRECT_FIELDS = GridFunc.asSet((Object[])new String[]{"K1", "V1"});
    public static final Set<String> DUPLICATE_FIELDS = GridFunc.asSet((Object[])new String[]{"K2", "V2"});
    public static CountDownLatch schemaFinishLatch;
    public static Map<Set<String>, UUID> idxOps;
    private CountDownLatch schemaStatusLatch;

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanPersistenceDir();
        idxOps.clear();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        super.afterTest();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        SchemaFinishListeningTcpDiscoverySpi discoSpi = new SchemaFinishListeningTcpDiscoverySpi();
        discoSpi.setIpFinder(((TcpDiscoverySpi)cfg.getDiscoverySpi()).getIpFinder());
        TestRecordingCommunicationSpi commSpi = new TestRecordingCommunicationSpi();
        commSpi.record((IgniteBiPredicate & Serializable)(n, msg) -> {
            if (msg instanceof SchemaOperationStatusMessage) {
                this.schemaStatusLatch.countDown();
                return true;
            }
            return false;
        });
        return cfg.setDiscoverySpi((DiscoverySpi)discoSpi).setCommunicationSpi((CommunicationSpi)commSpi).setSqlConfiguration(new SqlConfiguration()).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
    }

    @Test
    public void testSeparateRequests() throws Exception {
        this.doTestWithRestart((ConsumerX<GridQueryProcessor>)((ConsumerX)qryProc -> {
            this.checkIndexCreate((GridQueryProcessor)qryProc, (GridTuple3<String, Set<String>, Boolean>)GridFunc.t((Object)"TABLE1", CORRECT_FIELDS, (Object)false));
            this.checkIndexCreate((GridQueryProcessor)qryProc, (GridTuple3<String, Set<String>, Boolean>)GridFunc.t((Object)"TABLE2", DUPLICATE_FIELDS, (Object)true));
        }));
    }

    @Test
    public void testMultiLineRequest() throws Exception {
        this.doTestWithRestart((ConsumerX<GridQueryProcessor>)((ConsumerX)qryProc -> this.checkIndexCreate((GridQueryProcessor)qryProc, (GridTuple3<String, Set<String>, Boolean>)GridFunc.t((Object)"TABLE1", CORRECT_FIELDS, (Object)false), (GridTuple3<String, Set<String>, Boolean>)GridFunc.t((Object)"TABLE2", DUPLICATE_FIELDS, (Object)true))));
    }

    public void doTestWithRestart(ConsumerX<GridQueryProcessor> idxCreateAction) throws Exception {
        IgniteEx crd = this.startGrid(0);
        this.startGridsMultiThreaded(1, 2);
        this.waitForTopology(3);
        crd.cluster().state(ClusterState.ACTIVE);
        this.awaitPartitionMapExchange();
        this.startGrid(3);
        this.startClientGrid(4);
        this.waitForTopology(5);
        IndexWithSameNameTest.assertEquals((int)3, (int)crd.cluster().currentBaselineTopology().size());
        GridQueryProcessor qryProc = crd.context().query();
        qryProc.querySqlFields(new SqlFieldsQuery("CREATE TABLE TABLE1 (K1 INT PRIMARY KEY, V1 INT)"), true).getAll();
        qryProc.querySqlFields(new SqlFieldsQuery("CREATE TABLE TABLE2 (K2 INT PRIMARY KEY, V2 INT)"), true).getAll();
        idxCreateAction.accept((Object)qryProc);
        this.assertSingleIndex(5);
        crd.cluster().state(ClusterState.INACTIVE);
        this.awaitPartitionMapExchange();
        this.stopAllGrids();
        this.startGrids(3);
        this.assertSingleIndex(3);
    }

    private void checkIndexCreate(GridQueryProcessor qryProc, GridTuple3<String, Set<String>, Boolean> ... idxParams) throws InterruptedException {
        List<GridTuple3<String, Set<String>, Boolean>> idxParams0 = Arrays.asList(idxParams);
        String idxCreateSql = idxParams0.stream().map(t -> String.format("CREATE INDEX IF NOT EXISTS %s ON %s (%s)", TEST_INDEX, t.get1(), String.join((CharSequence)",", (Iterable)t.get2()))).collect(Collectors.joining("\n;"));
        schemaFinishLatch = new CountDownLatch(6 * idxParams0.size());
        this.schemaStatusLatch = new CountDownLatch(3 * idxParams0.size());
        qryProc.querySqlFields(new SqlFieldsQuery(idxCreateSql), true, false).forEach(QueryCursor::getAll);
        this.schemaStatusLatch.await(this.getTestTimeout(), TimeUnit.MILLISECONDS);
        schemaFinishLatch.await(this.getTestTimeout(), TimeUnit.MILLISECONDS);
        this.checkNoOpMessages(idxParams0);
    }

    private void checkNoOpMessages(List<GridTuple3<String, Set<String>, Boolean>> idxParams) {
        for (int i = 0; i < 5; ++i) {
            List commMsgs = TestRecordingCommunicationSpi.spi((Ignite)this.grid(i)).recordedMessages(false);
            boolean crdOrClient = i == 0 || i == 4;
            String commMsgErr = "Unexpected SchemaOperationStatusMessage count on node: igniteIndex=" + i + ", commMsgsCnt=" + commMsgs.size();
            int sqlCnt = idxParams.size();
            IndexWithSameNameTest.assertEquals((String)commMsgErr, (int)(crdOrClient ? 0 : sqlCnt), (int)commMsgs.size());
            List<SchemaFinishDiscoveryMessage> discoMsgs = SchemaFinishListeningTcpDiscoverySpi.discoSpi((Ignite)this.grid(i)).recordedMessages();
            String discoMsgErr = "Unexpected SchemaFinishDiscoveryMessage count on node: igniteIndex=" + i + ", discoMsgsCnt=" + discoMsgs.size();
            IndexWithSameNameTest.assertEquals((String)discoMsgErr, (int)(i == 0 ? 2 * sqlCnt : sqlCnt), (int)discoMsgs.size());
            for (GridTuple3<String, Set<String>, Boolean> param : idxParams) {
                Set expIdxFields = (Set)param.get2();
                boolean expNop = (Boolean)param.get3();
                UUID opId = idxOps.get(expIdxFields);
                String commNopErr = String.format("Unexpected no-op flag in communication messages: opId=%s, igniteIndex=%d, expNop=%b, recordedMsgs=%s", opId, i, expNop, commMsgs);
                IndexWithSameNameTest.assertTrue((String)commNopErr, (boolean)commMsgs.stream().map(msg -> (SchemaOperationStatusMessage)msg).filter(msg -> opId.equals(msg.operationId())).allMatch(msg -> msg.nop() == expNop));
                String discoNopErr = String.format("Unexpected no-op flag in discovery messages: opId=%s, igniteIndex=%d, expNop=%b, recordedMsgs=%s", opId, i, expNop, discoMsgs);
                IndexWithSameNameTest.assertTrue((String)discoNopErr, (boolean)discoMsgs.stream().filter(msg -> opId.equals(msg.operation().id())).allMatch(msg -> msg.nop() == expNop));
            }
        }
    }

    private void assertSingleIndex(int nodesCnt) {
        for (int i = 0; i < nodesCnt; ++i) {
            Collection indexes = ((IgniteH2Indexing)this.grid(i).context().query().getIndexing()).schemaManager().dataTables().stream().flatMap(t -> t.getIndexes().stream()).collect(Collectors.toList());
            List filteredIdxs = indexes.stream().filter(idx -> TEST_INDEX.equalsIgnoreCase(idx.getName())).collect(Collectors.toList());
            IndexWithSameNameTest.assertEquals((String)"There should be only one index", (int)1, (int)filteredIdxs.size());
            Set actualFields = Arrays.stream(((Index)filteredIdxs.get(0)).getIndexColumns()).map(c -> c.columnName).filter(f -> !"_KEY".equalsIgnoreCase((String)f)).collect(Collectors.toSet());
            IndexWithSameNameTest.assertEqualsSets(CORRECT_FIELDS, actualFields);
        }
    }

    static {
        idxOps = new ConcurrentHashMap<Set<String>, UUID>();
    }

    public static class SchemaFinishListeningTcpDiscoverySpi
    extends TcpDiscoverySpi {
        private final List<SchemaFinishDiscoveryMessage> recordedMsgs = new CopyOnWriteArrayList<SchemaFinishDiscoveryMessage>();

        protected void startMessageProcess(TcpDiscoveryAbstractMessage msg) {
            if (msg instanceof TcpDiscoveryCustomEventMessage) {
                try {
                    DiscoverySpiCustomMessage spiCustomMsg = ((TcpDiscoveryCustomEventMessage)msg).message(this.marshaller(), U.resolveClassLoader((IgniteConfiguration)this.ignite().configuration()));
                    DiscoveryCustomMessage discoCustomMsg = ((CustomMessageWrapper)spiCustomMsg).delegate();
                    if (discoCustomMsg instanceof SchemaFinishDiscoveryMessage) {
                        SchemaFinishDiscoveryMessage finishMsg = (SchemaFinishDiscoveryMessage)discoCustomMsg;
                        SchemaIndexCreateOperation op = (SchemaIndexCreateOperation)finishMsg.operation();
                        idxOps.putIfAbsent(new HashSet(op.index().getFieldNames()), op.id());
                        this.recordedMsgs.add(finishMsg);
                        schemaFinishLatch.countDown();
                    }
                }
                catch (Throwable e) {
                    this.log.error("Unexpected error", e);
                    IndexWithSameNameTest.fail((String)e.getMessage());
                }
            }
        }

        public static SchemaFinishListeningTcpDiscoverySpi discoSpi(Ignite ignite) {
            return (SchemaFinishListeningTcpDiscoverySpi)ignite.configuration().getDiscoverySpi();
        }

        public List<SchemaFinishDiscoveryMessage> recordedMessages() {
            ArrayList<SchemaFinishDiscoveryMessage> recordedMsgs0 = new ArrayList<SchemaFinishDiscoveryMessage>(this.recordedMsgs);
            this.recordedMsgs.clear();
            return recordedMsgs0;
        }
    }
}

