/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxyImpl;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.junit.Test;

public class IgniteSqlSinglePartitionMultiParallelismTest
extends AbstractIndexingCommonTest {
    private static final String CACHE_NAME = "SC_NULL_TEST";
    private static final int CACHE_PARALLELISM = 8;
    private static final int KEY_CNT = 1024;

    protected void beforeTestsStarted() throws Exception {
        this.startGrids(3);
        this.ignite(0).createCache(this.cacheConfig());
        this.fillTable();
    }

    protected CacheConfiguration<Integer, Integer> cacheConfig() {
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("id", Integer.class.getName());
        fields.put("val", Integer.class.getName());
        return new CacheConfiguration().setName(CACHE_NAME).setQueryParallelism(8).setQueryEntities(Collections.singletonList(new QueryEntity(Integer.class.getName(), "newKeyType").setTableName(CACHE_NAME).setFields(fields).setKeyFieldName("id")));
    }

    @Test
    public void testSimpleCountQuery() {
        List<List<?>> results = this.runQuery("select count(*) from SC_NULL_TEST");
        Long res = (Long)results.get(0).get(0);
        IgniteSqlSinglePartitionMultiParallelismTest.assertEquals((int)1, (int)results.size());
        IgniteSqlSinglePartitionMultiParallelismTest.assertEquals((Object)1024L, (Object)res);
    }

    @Test
    public void testWhereCountPartitionQuery() {
        for (int segment = 0; segment < 8; ++segment) {
            Integer keyForSegment = this.segmentKey(segment);
            List<List<?>> results = this.runQuery("select count(*) from SC_NULL_TEST where ID=" + keyForSegment);
            Long res = (Long)results.get(0).get(0);
            IgniteSqlSinglePartitionMultiParallelismTest.assertEquals((int)1, (int)results.size());
            IgniteSqlSinglePartitionMultiParallelismTest.assertEquals((Object)1L, (Object)res);
        }
    }

    @Test
    public void testWhereCountMultiPartitionsQuery() {
        Integer keyFromFirstSegment = this.segmentKey(0);
        Integer keyFromLastSegment = this.segmentKey(7);
        List<List<?>> results = this.runQuery("select count(*) from SC_NULL_TEST where ID=" + keyFromFirstSegment + " or ID=" + keyFromLastSegment);
        Long res = (Long)results.get(0).get(0);
        IgniteSqlSinglePartitionMultiParallelismTest.assertEquals((int)1, (int)results.size());
        IgniteSqlSinglePartitionMultiParallelismTest.assertEquals((Object)2L, (Object)res);
    }

    @Test
    public void testMultiPartitionedRdcMonoPartitionedMap() {
        Integer keyFromFirstSegment = this.segmentKey(0);
        for (int i = 1; i < 8; ++i) {
            Integer keyFromAnotherSegment = this.segmentKey(i);
            List<List<?>> results = this.runQuery("select * from SC_NULL_TEST where ID=" + keyFromFirstSegment + " or ID=" + keyFromAnotherSegment);
            IgniteSqlSinglePartitionMultiParallelismTest.assertEquals((int)2, (int)results.size());
        }
    }

    protected Integer segmentKey(int segment) {
        IgniteCache cache = this.ignite(0).cache(CACHE_NAME);
        IgniteCacheProxyImpl proxy = (IgniteCacheProxyImpl)cache.unwrap(IgniteCacheProxyImpl.class);
        GridCacheContext cctx = proxy.context();
        for (int k = 1; k <= 1024; ++k) {
            int keySegment = GridH2IndexBase.calculateSegment((int)8, (int)cctx.affinity().partition((Object)k));
            if (keySegment != segment) continue;
            return k;
        }
        throw new IgniteException("Key is not found. Please, check range of keys and segmentsCnt. Requested segmentId is " + segment);
    }

    public void fillTable() {
        for (int i = 1; i <= 1024; ++i) {
            this.runQuery(String.format("insert into SC_NULL_TEST(id, val) VALUES(%d, %d)", i, i));
        }
    }

    public List<List<?>> runQuery(String qry) {
        IgniteCache cache = this.ignite(0).cache(CACHE_NAME);
        return cache.query(new SqlFieldsQuery(qry)).getAll();
    }
}

